/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.environmental.common.levelgen.feature.NoiseThresholdPlacedFeature;
import com.teamabnormals.environmental.common.levelgen.feature.configurations.NoiseSelectorFeatureConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class NoiseSelectorFeature
extends Feature<NoiseSelectorFeatureConfiguration> {
    public NoiseSelectorFeature(Codec<NoiseSelectorFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoiseSelectorFeatureConfiguration> context) {
        NoiseSelectorFeatureConfiguration config = (NoiseSelectorFeatureConfiguration)context.config();
        RandomSource random = context.random();
        WorldGenLevel level = context.level();
        ChunkGenerator chunkgenerator = context.chunkGenerator();
        BlockPos origin = context.origin();
        double value = config.getNoise(level).getValue((double)origin.getX(), (double)origin.getY(), (double)origin.getZ());
        for (NoiseThresholdPlacedFeature feature : config.features) {
            if (!(value < (double)(feature.threshold - config.blending)) && (!(value < (double)(feature.threshold + config.blending)) || !((double)random.nextFloat() < 1.0 - (value - (double)feature.threshold + (double)config.blending) / (double)(2.0f * config.blending)))) continue;
            return feature.place(level, chunkgenerator, random, origin);
        }
        return ((PlacedFeature)config.defaultFeature.value()).place(level, chunkgenerator, random, origin);
    }
}

