/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;

public class PineSlopesBoulderFeature
extends Feature<BlockStateConfiguration> {
    public PineSlopesBoulderFeature(Codec<BlockStateConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<BlockStateConfiguration> context) {
        BlockStateConfiguration config = (BlockStateConfiguration)context.config();
        WorldGenLevel level = context.level();
        RandomSource random = context.random();
        BlockPos pos = context.origin();
        while (pos.getY() > 3) {
            if (!level.isEmptyBlock(pos.below())) {
                int i1 = random.nextInt(2);
                if (random.nextInt(4) == 0) {
                    ++i1;
                }
                boolean filledwithemeralds = random.nextInt(100) == 0;
                boolean hasemeralds = random.nextInt(7) == 0 || filledwithemeralds;
                HashSet<BlockPos> blockpositions = new HashSet<BlockPos>();
                for (int l = 0; l < 3; ++l) {
                    int i = i1 + random.nextInt(2);
                    int j = i1 + random.nextInt(2);
                    int k = i1 + random.nextInt(2);
                    float f = (float)(i + j + k) * 0.333f + 0.5f;
                    for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)pos.offset(-i, -j, -k), (BlockPos)pos.offset(i, j, k))) {
                        if (!(blockpos.distSqr((Vec3i)pos) <= (double)(f * f))) continue;
                        if (hasemeralds) {
                            blockpositions.add(blockpos.immutable());
                        }
                        level.setBlock(blockpos, config.state, 4);
                    }
                    if (level.isEmptyBlock((pos = pos.offset(-(i1 + 1) + random.nextInt(2 + i1 * 2), -random.nextInt(2), -(i1 + 1) + random.nextInt(2 + i1 * 2))).below())) break;
                }
                if (hasemeralds) {
                    BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
                    ArrayList<BlockPos> insidepositions = new ArrayList<BlockPos>();
                    for (BlockPos blockpos : blockpositions) {
                        boolean inside = true;
                        if (inside) {
                            for (Direction direction : Direction.values()) {
                                if (blockpositions.contains(mutable.setWithOffset((Vec3i)blockpos, direction))) continue;
                                inside = false;
                            }
                        }
                        if (!inside) continue;
                        insidepositions.add(blockpos);
                    }
                    if (filledwithemeralds) {
                        for (BlockPos blockpos : insidepositions) {
                            level.setBlock(blockpos, Blocks.EMERALD_ORE.defaultBlockState(), 4);
                        }
                    } else {
                        int emeralds = 2 + random.nextInt(2);
                        for (int i = 0; i < emeralds && !insidepositions.isEmpty(); ++i) {
                            level.setBlock((BlockPos)insidepositions.remove(random.nextInt(insidepositions.size())), Blocks.EMERALD_ORE.defaultBlockState(), 4);
                        }
                    }
                }
                return true;
            }
            pos = pos.below();
        }
        return false;
    }
}

