/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.feature;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.teamabnormals.blueprint.common.levelgen.feature.BlueprintTreeFeature;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class PineTreeFeature
extends BlueprintTreeFeature {
    public PineTreeFeature(Codec<TreeConfiguration> config) {
        super(config);
    }

    public void doPlace(FeaturePlaceContext<TreeConfiguration> context, BlueprintTreeFeature.TreeInfo info) {
        int leafbranches;
        TreeConfiguration config = (TreeConfiguration)context.config();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        int trunkheight = config.trunkPlacer.getTreeHeight(random);
        for (int y = 0; y < trunkheight; ++y) {
            info.addLog(origin.above(y));
        }
        float f = random.nextFloat();
        int n = f > 0.6f ? 4 : (f > 0.25f ? 3 : (leafbranches = f > 0.05f ? 2 : 1));
        if (trunkheight >= 14 && random.nextBoolean()) {
            ++leafbranches;
        }
        if (trunkheight >= 16) {
            ++leafbranches;
        }
        if (trunkheight >= 16 && leafbranches < 4) {
            leafbranches = 4;
        }
        if (trunkheight >= 18) {
            ++leafbranches;
        }
        ArrayList branchdirections = Lists.newArrayList();
        Direction.Plane.HORIZONTAL.forEach(branchdirections::add);
        int y = trunkheight - 4;
        while (y > 0) {
            BlockPos blockpos = origin.above(y);
            if (leafbranches > 0) {
                Direction direction = (Direction)branchdirections.remove(random.nextInt(branchdirections.size()));
                this.createBranchWithLeaves(blockpos, direction, random, config, info);
                --leafbranches;
                if (branchdirections.isEmpty()) {
                    Direction.Plane.HORIZONTAL.forEach(branchdirections::add);
                    branchdirections.remove(direction);
                }
            } else if (random.nextInt(y > 5 ? 2 : 6) == 0) {
                this.createBranch(blockpos, Direction.Plane.HORIZONTAL.getRandomDirection(random), random, config, info);
            }
            if (leafbranches == 0) {
                y -= 2 + random.nextInt(2);
                continue;
            }
            if (leafbranches == 1 && random.nextInt(3) == 0) {
                y -= 2;
                continue;
            }
            --y;
        }
        this.createTopLeaves(origin.above(trunkheight), info);
    }

    public BlockState getSapling() {
        return ((Block)EnvironmentalBlocks.PINE_SAPLING.get()).defaultBlockState();
    }

    private void createBranch(BlockPos pos, Direction direction, RandomSource random, TreeConfiguration config, BlueprintTreeFeature.TreeInfo info) {
        BlockPos blockpos = pos.relative(direction);
        info.addLog(blockpos, (BlockState)config.trunkProvider.getState(random, blockpos).setValue((Property)RotatedPillarBlock.AXIS, (Comparable)direction.getAxis()));
    }

    private void createBranchWithLeaves(BlockPos pos, Direction direction, RandomSource random, TreeConfiguration config, BlueprintTreeFeature.TreeInfo info) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        BlockPos blockpos = pos.relative(direction);
        this.createBranch(pos, direction, random, config, info);
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                mutable.setWithOffset((Vec3i)blockpos, x, 0, z);
                info.addFoliage((BlockPos)mutable);
                if (x != 0 && z != 0) continue;
                info.addFoliage(mutable.above());
            }
        }
        if (random.nextInt(3) == 0) {
            info.addFoliage(blockpos.relative(direction, 2));
        }
    }

    private void createTopLeaves(BlockPos pos, BlueprintTreeFeature.TreeInfo info) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int y = 0; y <= 3; ++y) {
            int r = y < 3 ? y : 1;
            for (int x = -r; x <= r; ++x) {
                for (int z = -r; z <= r; ++z) {
                    if (Math.abs(x) + Math.abs(z) > r) continue;
                    mutable.setWithOffset((Vec3i)pos, x, 1 - y, z);
                    info.addFoliage((BlockPos)mutable);
                }
            }
        }
    }
}

