/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.environmental.common.levelgen.feature.PineTreeFeature;
import com.teamabnormals.environmental.core.registry.datapack.EnvironmentalConfiguredFeatures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class PineTreeOnStoneFeature
extends PineTreeFeature {
    public PineTreeOnStoneFeature(Codec<TreeConfiguration> config) {
        super(config);
    }

    public boolean place(FeaturePlaceContext<TreeConfiguration> context) {
        boolean flag = super.place(context);
        if (flag) {
            WorldGenLevel level = context.level();
            RandomSource random = context.random();
            BlockPos origin = context.origin();
            if (origin.getY() != level.getHeight(Heightmap.Types.WORLD_SURFACE_WG, origin.getX(), origin.getZ())) {
                level.setBlock(origin.below(), Blocks.COARSE_DIRT.defaultBlockState(), 2);
                BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
                for (int x = -1; x <= 1; ++x) {
                    block1: for (int z = -1; z <= 1; ++z) {
                        for (int y = 0; y >= -2; --y) {
                            mutable.setWithOffset((Vec3i)origin, x, y, z);
                            BlockState blockstate = level.getBlockState((BlockPos)mutable);
                            BlockState abovestate = level.getBlockState(mutable.above());
                            if (!abovestate.isAir() || !blockstate.is(BlockTags.BASE_STONE_OVERWORLD)) continue;
                            if (x != 0 && z != 0 && random.nextInt(3) != 0) continue block1;
                            level.setBlock((BlockPos)mutable, Blocks.COARSE_DIRT.defaultBlockState(), 2);
                            continue block1;
                        }
                    }
                }
            } else {
                ((ConfiguredFeature)level.registryAccess().registryOrThrow(Registries.CONFIGURED_FEATURE).getOrThrow(EnvironmentalConfiguredFeatures.COARSE_DIRT_ON_STONE)).place(level, context.chunkGenerator(), random, origin);
            }
        }
        return flag;
    }

    public boolean canSurvive(WorldGenLevel level, BlockPos pos) {
        BlockState state = level.getBlockState(pos.below());
        return state.is(BlockTags.BASE_STONE_OVERWORLD);
    }
}

