/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.blueprint.common.levelgen.feature.BlueprintTreeFeature;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class PlumTreeFeature
extends BlueprintTreeFeature {
    public PlumTreeFeature(Codec<TreeConfiguration> config) {
        super(config);
    }

    public void doPlace(FeaturePlaceContext<TreeConfiguration> context, BlueprintTreeFeature.TreeInfo info) {
        RandomSource random = context.random();
        BlockPos origin = context.origin();
        TreeConfiguration config = (TreeConfiguration)context.config();
        int trunkHeight = config.trunkPlacer.getTreeHeight(random);
        for (int y = 0; y < trunkHeight; ++y) {
            info.addLog(origin.above(y));
        }
        Direction.Plane.HORIZONTAL.stream().forEach(direction -> {
            BlockPos stumpPos = origin.relative(direction);
            if (random.nextInt(3) != 0 && PlumTreeFeature.isGrassOrDirt((LevelSimulatedReader)context.level(), (BlockPos)stumpPos.below())) {
                info.addLog(stumpPos);
                if (random.nextInt(3) == 0) {
                    info.addLog(stumpPos.above());
                }
            }
        });
        Direction.Plane.HORIZONTAL.stream().forEach(direction -> {
            BlockPos newPos = this.createPlumBranch(origin.above(trunkHeight - random.nextInt(3)), (Direction)direction, random, info);
            for (int i = 0; i < 5; ++i) {
                this.createPlumLeaves(newPos.above().below(i), random, info, i);
            }
        });
    }

    private void createPlumLeaves(BlockPos pos, RandomSource random, BlueprintTreeFeature.TreeInfo info, int leafLevel) {
        int leafSize = 2;
        for (int k = -leafSize; k <= leafSize; ++k) {
            for (int j = -leafSize; j <= leafSize; ++j) {
                if (leafLevel == 2) {
                    info.addFoliage(pos.offset(k, 0, j));
                    continue;
                }
                if (leafLevel > 1 && leafLevel < 4 && (Math.abs(k) != leafSize || Math.abs(j) != leafSize)) {
                    info.addFoliage(pos.offset(k, 0, j));
                    continue;
                }
                if ((leafLevel == 1 || leafLevel == 4) && Math.abs(k) <= 1 && Math.abs(j) <= 1) {
                    if ((Math.abs(k) == 1 && Math.abs(j) == 1 && leafLevel == 4 || Math.abs(k) == 2 && Math.abs(j) == 2) && !random.nextBoolean()) continue;
                    info.addFoliage(pos.offset(k, 0, j));
                    continue;
                }
                if (leafLevel != 1) continue;
                if (random.nextInt(3) == 0 && (Math.abs(k) == 1 && Math.abs(j) == 2 || Math.abs(k) == 2 && Math.abs(j) == 1)) {
                    info.addFoliage(pos.offset(k, 0, j));
                    continue;
                }
                if (random.nextInt(4) == 0 || (Math.abs(k) != 0 || Math.abs(j) != 2) && (Math.abs(k) != 2 || Math.abs(j) != 0)) continue;
                info.addFoliage(pos.offset(k, 0, j));
            }
        }
    }

    private BlockPos createPlumBranch(BlockPos pos, Direction direction, RandomSource random, BlueprintTreeFeature.TreeInfo info) {
        int i;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(pos.getX(), pos.getY(), pos.getZ());
        int length = 2 + random.nextInt(2);
        for (i = 0; i < length; ++i) {
            info.addLog(mutablePos.relative(direction));
            if (random.nextInt(3) != 0) {
                mutablePos.set((Vec3i)mutablePos.above());
            }
            mutablePos.set((Vec3i)mutablePos.relative(direction, random.nextInt(2)));
        }
        for (i = 0; i < 3; ++i) {
            info.addLog(mutablePos.relative(direction));
            mutablePos.set((Vec3i)mutablePos.above());
        }
        return mutablePos.relative(direction);
    }

    public BlockState getSapling() {
        return ((Block)EnvironmentalBlocks.PLUM_SAPLING.get()).defaultBlockState();
    }
}

