/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BambooLeaves;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.ProbabilityFeatureConfiguration;

public class ShortBambooFeature
extends Feature<ProbabilityFeatureConfiguration> {
    private static final BlockState BAMBOO_TRUNK = (BlockState)((BlockState)((BlockState)Blocks.BAMBOO.defaultBlockState().setValue((Property)BambooStalkBlock.AGE, (Comparable)Integer.valueOf(1))).setValue((Property)BambooStalkBlock.LEAVES, (Comparable)BambooLeaves.NONE)).setValue((Property)BambooStalkBlock.STAGE, (Comparable)Integer.valueOf(0));
    private static final BlockState BAMBOO_FINAL_LARGE = (BlockState)((BlockState)BAMBOO_TRUNK.setValue((Property)BambooStalkBlock.LEAVES, (Comparable)BambooLeaves.LARGE)).setValue((Property)BambooStalkBlock.STAGE, (Comparable)Integer.valueOf(1));
    private static final BlockState BAMBOO_TOP_LARGE = (BlockState)BAMBOO_TRUNK.setValue((Property)BambooStalkBlock.LEAVES, (Comparable)BambooLeaves.LARGE);
    private static final BlockState BAMBOO_TOP_SMALL = (BlockState)BAMBOO_TRUNK.setValue((Property)BambooStalkBlock.LEAVES, (Comparable)BambooLeaves.SMALL);

    public ShortBambooFeature(Codec<ProbabilityFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<ProbabilityFeatureConfiguration> config) {
        int count = 0;
        BlockPos origin = config.origin();
        WorldGenLevel level = config.level();
        RandomSource random = config.random();
        ProbabilityFeatureConfiguration probabilityfeatureconfiguration = (ProbabilityFeatureConfiguration)config.config();
        BlockPos.MutableBlockPos bambooPos = origin.mutable();
        BlockPos.MutableBlockPos podzolPos = origin.mutable();
        if (level.isEmptyBlock((BlockPos)bambooPos)) {
            if (Blocks.BAMBOO.defaultBlockState().canSurvive((LevelReader)level, (BlockPos)bambooPos)) {
                int bambooHeight = random.nextInt(7) + 5;
                if (random.nextFloat() < probabilityfeatureconfiguration.probability) {
                    int podzolRadius = random.nextInt(4) + 1;
                    for (int xPos = origin.getX() - podzolRadius; xPos <= origin.getX() + podzolRadius; ++xPos) {
                        for (int zPos = origin.getZ() - podzolRadius; zPos <= origin.getZ() + podzolRadius; ++zPos) {
                            int zDist;
                            int xDist = xPos - origin.getX();
                            if (xDist * xDist + (zDist = zPos - origin.getZ()) * zDist > podzolRadius * podzolRadius) continue;
                            podzolPos.set(xPos, level.getHeight(Heightmap.Types.WORLD_SURFACE, xPos, zPos) - 1, zPos);
                            if (!ShortBambooFeature.isDirt((BlockState)level.getBlockState((BlockPos)podzolPos))) continue;
                            level.setBlock((BlockPos)podzolPos, Blocks.PODZOL.defaultBlockState(), 2);
                            if (!level.getBlockState(podzolPos.above()).isAir() || !random.nextBoolean()) continue;
                            level.setBlock(podzolPos.above(), Blocks.SHORT_GRASS.defaultBlockState(), 2);
                        }
                    }
                }
                for (int i = 0; i < bambooHeight && level.isEmptyBlock((BlockPos)bambooPos); ++i) {
                    level.setBlock((BlockPos)bambooPos, BAMBOO_TRUNK, 2);
                    bambooPos.move(Direction.UP, 1);
                }
                if (bambooPos.getY() - origin.getY() >= 3) {
                    level.setBlock((BlockPos)bambooPos, BAMBOO_FINAL_LARGE, 2);
                    level.setBlock((BlockPos)bambooPos.move(Direction.DOWN, 1), BAMBOO_TOP_LARGE, 2);
                    level.setBlock((BlockPos)bambooPos.move(Direction.DOWN, 1), BAMBOO_TOP_SMALL, 2);
                }
            }
            ++count;
        }
        return count > 0;
    }
}

