/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.feature;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.teamabnormals.blueprint.common.levelgen.feature.BlueprintTreeFeature;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class WeepingWillowTreeFeature
extends BlueprintTreeFeature {
    public WeepingWillowTreeFeature(Codec<TreeConfiguration> config) {
        super(config);
    }

    public void doPlace(FeaturePlaceContext<TreeConfiguration> context, BlueprintTreeFeature.TreeInfo info) {
        TreeConfiguration config = (TreeConfiguration)context.config();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        int trunkHeight = config.trunkPlacer.getTreeHeight(random);
        int branches = 2 + random.nextInt(2);
        ArrayList branchHeights = Lists.newArrayList((Object[])new Integer[]{3, 4, 5});
        ArrayList branchDirections = Lists.newArrayList();
        Direction.Plane.HORIZONTAL.forEach(branchDirections::add);
        for (int i = 0; i < branches; ++i) {
            int branchHeight = (Integer)branchHeights.remove(random.nextInt(branchHeights.size()));
            Direction direction = (Direction)branchDirections.remove(random.nextInt(branchDirections.size()));
            this.createBranch(origin.above(branchHeight), direction, random, config, info);
        }
        Direction direction = (Direction)branchDirections.get(random.nextInt(branchDirections.size()));
        for (int i = 0; i < trunkHeight; ++i) {
            if (i < trunkHeight - 5) {
                info.addLog(origin.above(i));
                continue;
            }
            info.addLog(origin.above(i).relative(direction));
        }
        this.createTopLeafBlob(origin.above(trunkHeight).relative(direction), random, direction, info);
    }

    private void createBranch(BlockPos pos, Direction direction, RandomSource random, TreeConfiguration config, BlueprintTreeFeature.TreeInfo info) {
        int length = 3 + random.nextInt(2);
        int offsetpos = 1 + random.nextInt(length - 1);
        BlockPos.MutableBlockPos mutablepos = new BlockPos.MutableBlockPos();
        mutablepos.set((Vec3i)pos);
        for (int i = 0; i < length; ++i) {
            if (i == offsetpos) {
                mutablepos.set((Vec3i)mutablepos.above());
            }
            info.addLog((BlockPos)mutablepos.set((Vec3i)mutablepos.relative(direction)), (BlockState)config.trunkProvider.getState(random, (BlockPos)mutablepos).setValue((Property)RotatedPillarBlock.AXIS, (Comparable)direction.getAxis()));
        }
        this.createBranchLeafBlob((BlockPos)mutablepos, random, direction, info, length <= 3);
    }

    private void createTopLeafBlob(BlockPos pos, RandomSource random, Direction direction, BlueprintTreeFeature.TreeInfo info) {
        BlockPos.MutableBlockPos mutablepos = new BlockPos.MutableBlockPos();
        for (int y = 0; y >= -3; --y) {
            int r = 2 - y / 2;
            for (int x = -r; x <= r; ++x) {
                for (int z = -r; z <= r; ++z) {
                    if (Math.abs(x) == r && Math.abs(z) == r && (random.nextInt(2) != 0 || y == 0)) continue;
                    mutablepos.setWithOffset((Vec3i)pos, x, y, z);
                    info.addFoliage((BlockPos)mutablepos);
                }
            }
        }
        this.createLeafWall(pos.below(4), random, direction, info, 3, 2);
    }

    private void createBranchLeafBlob(BlockPos pos, RandomSource random, Direction direction, BlueprintTreeFeature.TreeInfo info, boolean small) {
        BlockPos.MutableBlockPos mutablepos = new BlockPos.MutableBlockPos();
        int i = small ? 1 : 2;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (Math.abs(x) == 1 && Math.abs(z) == 1 && random.nextInt(4) != 0) continue;
                mutablepos.setWithOffset((Vec3i)pos, x, i, z);
                info.addFoliage((BlockPos)mutablepos);
            }
        }
        for (int y = i - 1; y >= 0; --y) {
            for (int x = -i; x <= i; ++x) {
                for (int z = -i; z <= i; ++z) {
                    if (Math.abs(x) == 2 && Math.abs(z) == 2) continue;
                    mutablepos.setWithOffset((Vec3i)pos, x, y, z);
                    info.addFoliage((BlockPos)mutablepos);
                }
            }
        }
        this.createLeafWall(pos.below(), random, direction, info, i, 3);
    }

    private void createLeafWall(BlockPos pos, RandomSource random, Direction direction, BlueprintTreeFeature.TreeInfo info, int width, int maxLength) {
        BlockPos.MutableBlockPos mutablepos = new BlockPos.MutableBlockPos();
        for (int x = -width; x <= width; ++x) {
            for (int z = -width; z <= width; ++z) {
                if (!this.shouldPlaceLeafColumn(x, z, direction, width)) continue;
                boolean flag = Math.abs(x) >= 2 && Math.abs(z) >= 2;
                int i = flag ? random.nextInt(2) : 1 + random.nextInt(maxLength);
                for (int y = 0; y > -i; --y) {
                    mutablepos.setWithOffset((Vec3i)pos, x, y, z);
                    info.addFoliage((BlockPos)mutablepos);
                }
            }
        }
    }

    private boolean shouldPlaceLeafColumn(int x, int z, Direction direction, int width) {
        Vec3i normal = direction.getNormal();
        int edgex = normal.getX() * width;
        int edgez = normal.getZ() * width;
        if (Math.abs(x) != width && Math.abs(z) != width) {
            return false;
        }
        if (width > 1 && Math.abs(x) == width && Math.abs(z) == width) {
            return false;
        }
        return (edgex == 0 || x != -edgex) && (edgez == 0 || z != -edgez);
    }

    public BlockState getSapling() {
        return ((Block)EnvironmentalBlocks.WILLOW_SAPLING.get()).defaultBlockState();
    }
}

