/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.feature.configurations;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class BestNoisesSelectorFeatureConfiguration
implements FeatureConfiguration {
    public static final Codec<BestNoisesSelectorFeatureConfiguration> CODEC = RecordCodecBuilder.create(builder -> builder.apply3(BestNoisesSelectorFeatureConfiguration::new, (App)NormalNoise.NoiseParameters.CODEC.fieldOf("noise").forGetter(config -> config.parameters), (App)Codec.floatRange((float)0.0f, (float)2.0f).fieldOf("blending").forGetter(config -> Float.valueOf(config.blending)), (App)PlacedFeature.CODEC.listOf().fieldOf("features").forGetter(config -> config.features)));
    public final Holder<NormalNoise.NoiseParameters> parameters;
    public final float blending;
    public final List<Holder<PlacedFeature>> features;
    private NormalNoise[] noises;
    private volatile boolean initialized;

    public BestNoisesSelectorFeatureConfiguration(Holder<NormalNoise.NoiseParameters> parameters, float blending, List<Holder<PlacedFeature>> features) {
        this.parameters = parameters;
        this.blending = blending;
        this.features = features;
        this.noises = new NormalNoise[features.size()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NormalNoise[] getNoises(WorldGenLevel level) {
        if (!this.initialized) {
            BestNoisesSelectorFeatureConfiguration bestNoisesSelectorFeatureConfiguration = this;
            synchronized (bestNoisesSelectorFeatureConfiguration) {
                if (!this.initialized) {
                    RandomSource random = WorldgenRandom.Algorithm.LEGACY.newInstance((long)((ResourceKey)this.parameters.unwrapKey().orElseThrow()).location().hashCode() ^ level.getSeed());
                    int size = this.features.size();
                    for (int i = 0; i < size; ++i) {
                        this.noises[i] = NormalNoise.create((RandomSource)new LegacyRandomSource(random.nextLong()), (NormalNoise.NoiseParameters)((NormalNoise.NoiseParameters)this.parameters.value()));
                    }
                    this.initialized = true;
                }
            }
        }
        return this.noises;
    }

    public Stream<ConfiguredFeature<?, ?>> getFeatures() {
        return this.features.stream().flatMap(holder -> ((PlacedFeature)holder.value()).getFeatures());
    }
}

