/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.feature.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.environmental.core.registry.EnvironmentalPlacementModifierTypes;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class NoiseDensityPlacement
extends PlacementModifier {
    public static final MapCodec<NoiseDensityPlacement> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)NormalNoise.NoiseParameters.CODEC.fieldOf("noise").forGetter(placement -> placement.noiseParameters), (App)Codec.DOUBLE.fieldOf("density").forGetter(placement -> placement.density), (App)Codec.DOUBLE.fieldOf("noise_offset").orElse((Object)0.0).forGetter(placement -> placement.noiseOffset)).apply((Applicative)instance, NoiseDensityPlacement::new));
    private final Holder<NormalNoise.NoiseParameters> noiseParameters;
    private final double density;
    private final double noiseOffset;
    private volatile boolean initialized;
    private NormalNoise noise;

    public NoiseDensityPlacement(Holder<NormalNoise.NoiseParameters> noiseParameters, double density, double noiseOffset) {
        this.noiseParameters = noiseParameters;
        this.density = density;
        this.noiseOffset = noiseOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<BlockPos> getPositions(PlacementContext context, RandomSource random, BlockPos pos) {
        if (!this.initialized) {
            NoiseDensityPlacement noiseDensityPlacement = this;
            synchronized (noiseDensityPlacement) {
                if (!this.initialized) {
                    this.noise = NormalNoise.create((RandomSource)WorldgenRandom.Algorithm.LEGACY.newInstance(context.getLevel().getSeed()).forkPositional().fromHashOf(((ResourceKey)this.noiseParameters.unwrapKey().orElseThrow()).location()), (NormalNoise.NoiseParameters)((NormalNoise.NoiseParameters)this.noiseParameters.value()));
                    this.initialized = true;
                }
            }
        }
        double value = (this.noise.getValue((double)pos.getX(), 0.0, (double)pos.getZ()) + this.noiseOffset) * this.density;
        int count = (int)value + ((double)random.nextFloat() < value - (double)((int)value) ? 1 : 0);
        return IntStream.range(0, count).mapToObj(i -> pos);
    }

    public PlacementModifierType<?> type() {
        return (PlacementModifierType)EnvironmentalPlacementModifierTypes.NOISE_DENSITY.get();
    }
}

