/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.treedecorators;

import com.mojang.serialization.MapCodec;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.teamabnormals.environmental.core.registry.EnvironmentalTreeDecorators;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class HangingWillowDecorator
extends TreeDecorator {
    public static final MapCodec<HangingWillowDecorator> CODEC;
    public static final HangingWillowDecorator INSTANCE;

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)EnvironmentalTreeDecorators.HANGING_WILLOW_LEAVES.get();
    }

    public void place(TreeDecorator.Context context) {
        for (BlockPos pos : context.leaves()) {
            if (!context.level().isStateAtPosition(pos.below(), BlockBehaviour.BlockStateBase::isAir) || context.random().nextInt(2) != 0) continue;
            context.setBlock(pos.below(), ((Block)EnvironmentalBlocks.HANGING_WILLOW_LEAVES.get()).defaultBlockState());
        }
    }

    static {
        INSTANCE = new HangingWillowDecorator();
        CODEC = MapCodec.unit(() -> INSTANCE);
    }
}

