/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.treedecorators;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.teamabnormals.environmental.core.registry.EnvironmentalTreeDecorators;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class PineconeDecorator
extends TreeDecorator {
    public static final MapCodec<PineconeDecorator> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(PineconeDecorator::new, decorator -> Float.valueOf(decorator.probability));
    private final float probability;

    public PineconeDecorator(float probability) {
        this.probability = probability;
    }

    public void place(TreeDecorator.Context context) {
        List<BlockPos> list;
        LevelSimulatedReader level = context.level();
        RandomSource random = context.random();
        if (!(random.nextFloat() >= this.probability) && !(list = context.leaves().stream().filter(blockpos -> level.isStateAtPosition(blockpos.below(), BlockBehaviour.BlockStateBase::isAir) && level.isStateAtPosition(blockpos.below(2), BlockBehaviour.BlockStateBase::isAir)).toList()).isEmpty()) {
            BlockPos pos = list.get(random.nextInt(list.size()));
            context.setBlock(pos.below(), ((Block)EnvironmentalBlocks.PINECONE.get()).defaultBlockState());
        }
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)EnvironmentalTreeDecorators.PINECONE.get();
    }
}

