/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.data.client;

import com.mojang.datafixers.util.Pair;
import com.teamabnormals.blueprint.core.data.client.BlueprintBlockStateProvider;
import com.teamabnormals.environmental.common.block.CattailBlock;
import com.teamabnormals.environmental.common.block.CattailStalkBlock;
import com.teamabnormals.environmental.core.Environmental;
import com.teamabnormals.environmental.core.other.EnvironmentalBlockFamilies;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;

public class EnvironmentalBlockStateProvider
extends BlueprintBlockStateProvider {
    public static final String[] WISTERIA_BOOKSHELF_POSITIONS = new String[]{"outer_left", "mid_left", "inner_left", "inner_right", "mid_right", "outer_right"};

    public EnvironmentalBlockStateProvider(PackOutput output, ExistingFileHelper helper) {
        super(output, "environmental", helper);
    }

    protected void registerStatesAndModels() {
        this.blockFamily(EnvironmentalBlockFamilies.DIRT_BRICK_FAMILY);
        this.blockFamily(EnvironmentalBlockFamilies.DIRT_TILE_FAMILY);
        this.blockFamily(EnvironmentalBlockFamilies.WILLOW_PLANKS_FAMILY);
        this.logBlocks((DeferredHolder)EnvironmentalBlocks.WILLOW_LOG, (DeferredHolder)EnvironmentalBlocks.WILLOW_WOOD);
        this.logBlocks((DeferredHolder)EnvironmentalBlocks.STRIPPED_WILLOW_LOG, (DeferredHolder)EnvironmentalBlocks.STRIPPED_WILLOW_WOOD);
        this.hangingSignBlocks((DeferredHolder)EnvironmentalBlocks.STRIPPED_WILLOW_LOG, (Pair)EnvironmentalBlocks.WILLOW_HANGING_SIGNS);
        this.leavesBlocks((DeferredHolder)EnvironmentalBlocks.WILLOW_LEAVES, (DeferredHolder)EnvironmentalBlocks.WILLOW_LEAF_PILE);
        this.crossBlockWithPot((DeferredHolder)EnvironmentalBlocks.WILLOW_SAPLING, (DeferredHolder)EnvironmentalBlocks.POTTED_WILLOW_SAPLING);
        this.woodworksBlocks((DeferredHolder)EnvironmentalBlocks.WILLOW_PLANKS, (DeferredHolder)EnvironmentalBlocks.WILLOW_BOARDS, (DeferredHolder)EnvironmentalBlocks.WILLOW_LADDER, (DeferredHolder)EnvironmentalBlocks.WILLOW_BOOKSHELF, (DeferredHolder)EnvironmentalBlocks.WILLOW_BEEHIVE, (DeferredHolder)EnvironmentalBlocks.WILLOW_CHEST, (DeferredHolder)EnvironmentalBlocks.TRAPPED_WILLOW_CHEST);
        this.chiseledBookshelfBlock((DeferredHolder)EnvironmentalBlocks.CHISELED_WILLOW_BOOKSHELF, DEFAULT_BOOKSHELF_POSITIONS);
        this.blockFamily(EnvironmentalBlockFamilies.PINE_PLANKS_FAMILY);
        this.logBlocks((DeferredHolder)EnvironmentalBlocks.PINE_LOG, (DeferredHolder)EnvironmentalBlocks.PINE_WOOD);
        this.logBlocks((DeferredHolder)EnvironmentalBlocks.STRIPPED_PINE_LOG, (DeferredHolder)EnvironmentalBlocks.STRIPPED_PINE_WOOD);
        this.hangingSignBlocks((DeferredHolder)EnvironmentalBlocks.STRIPPED_PINE_LOG, (Pair)EnvironmentalBlocks.PINE_HANGING_SIGNS);
        this.leavesBlocks((DeferredHolder)EnvironmentalBlocks.PINE_LEAVES, (DeferredHolder)EnvironmentalBlocks.PINE_LEAF_PILE);
        this.crossBlockWithPot((DeferredHolder)EnvironmentalBlocks.PINE_SAPLING, (DeferredHolder)EnvironmentalBlocks.POTTED_PINE_SAPLING);
        this.woodworksBlocks((DeferredHolder)EnvironmentalBlocks.PINE_PLANKS, (DeferredHolder)EnvironmentalBlocks.PINE_BOARDS, (DeferredHolder)EnvironmentalBlocks.PINE_LADDER, (DeferredHolder)EnvironmentalBlocks.PINE_BOOKSHELF, (DeferredHolder)EnvironmentalBlocks.PINE_BEEHIVE, (DeferredHolder)EnvironmentalBlocks.PINE_CHEST, (DeferredHolder)EnvironmentalBlocks.TRAPPED_PINE_CHEST);
        this.chiseledBookshelfBlock((DeferredHolder)EnvironmentalBlocks.CHISELED_PINE_BOOKSHELF, ALTERNATE_BOOKSHELF_POSITIONS);
        this.cubeColumnBlock(EnvironmentalBlocks.PINECONE);
        this.cubeColumnBlock(EnvironmentalBlocks.WAXED_PINECONE, EnvironmentalBlocks.PINECONE);
        this.blockFamily(EnvironmentalBlockFamilies.PLUM_PLANKS_FAMILY);
        this.logBlocks((DeferredHolder)EnvironmentalBlocks.PLUM_LOG, (DeferredHolder)EnvironmentalBlocks.PLUM_WOOD);
        this.logBlocks((DeferredHolder)EnvironmentalBlocks.STRIPPED_PLUM_LOG, (DeferredHolder)EnvironmentalBlocks.STRIPPED_PLUM_WOOD);
        this.hangingSignBlocks((DeferredHolder)EnvironmentalBlocks.STRIPPED_PLUM_LOG, (Pair)EnvironmentalBlocks.PLUM_HANGING_SIGNS);
        this.leavesBlocks((DeferredHolder)EnvironmentalBlocks.PLUM_LEAVES, (DeferredHolder)EnvironmentalBlocks.PLUM_LEAF_PILE);
        this.leavesBlocks((DeferredHolder)EnvironmentalBlocks.CHEERFUL_PLUM_LEAVES, (DeferredHolder)EnvironmentalBlocks.CHEERFUL_PLUM_LEAF_PILE);
        this.leavesBlocks((DeferredHolder)EnvironmentalBlocks.MOODY_PLUM_LEAVES, (DeferredHolder)EnvironmentalBlocks.MOODY_PLUM_LEAF_PILE);
        this.crossBlockWithPot((DeferredHolder)EnvironmentalBlocks.PLUM_SAPLING, (DeferredHolder)EnvironmentalBlocks.POTTED_PLUM_SAPLING);
        this.crossBlockWithPot((DeferredHolder)EnvironmentalBlocks.CHEERFUL_PLUM_SAPLING, (DeferredHolder)EnvironmentalBlocks.POTTED_CHEERFUL_PLUM_SAPLING);
        this.crossBlockWithPot((DeferredHolder)EnvironmentalBlocks.MOODY_PLUM_SAPLING, (DeferredHolder)EnvironmentalBlocks.POTTED_MOODY_PLUM_SAPLING);
        this.woodworksBlocks((DeferredHolder)EnvironmentalBlocks.PLUM_PLANKS, (DeferredHolder)EnvironmentalBlocks.PLUM_BOARDS, (DeferredHolder)EnvironmentalBlocks.PLUM_LADDER, (DeferredHolder)EnvironmentalBlocks.PLUM_BOOKSHELF, (DeferredHolder)EnvironmentalBlocks.PLUM_BEEHIVE, (DeferredHolder)EnvironmentalBlocks.PLUM_CHEST, (DeferredHolder)EnvironmentalBlocks.TRAPPED_PLUM_CHEST);
        this.chiseledBookshelfBlock((DeferredHolder)EnvironmentalBlocks.CHISELED_PLUM_BOOKSHELF, DEFAULT_BOOKSHELF_POSITIONS);
        this.blockFamily(EnvironmentalBlockFamilies.WISTERIA_PLANKS_FAMILY);
        this.logBlocks((DeferredHolder)EnvironmentalBlocks.WISTERIA_LOG, (DeferredHolder)EnvironmentalBlocks.WISTERIA_WOOD);
        this.logBlocks((DeferredHolder)EnvironmentalBlocks.STRIPPED_WISTERIA_LOG, (DeferredHolder)EnvironmentalBlocks.STRIPPED_WISTERIA_WOOD);
        this.hangingSignBlocks((DeferredHolder)EnvironmentalBlocks.STRIPPED_WISTERIA_LOG, (Pair)EnvironmentalBlocks.WISTERIA_HANGING_SIGNS);
        this.leavesBlocks((DeferredHolder)EnvironmentalBlocks.WISTERIA_LEAVES, (DeferredHolder)EnvironmentalBlocks.WISTERIA_LEAF_PILE);
        this.crossBlockWithPot((DeferredHolder)EnvironmentalBlocks.PINK_WISTERIA_SAPLING, (DeferredHolder)EnvironmentalBlocks.POTTED_PINK_WISTERIA_SAPLING);
        this.crossBlockWithPot((DeferredHolder)EnvironmentalBlocks.BLUE_WISTERIA_SAPLING, (DeferredHolder)EnvironmentalBlocks.POTTED_BLUE_WISTERIA_SAPLING);
        this.crossBlockWithPot((DeferredHolder)EnvironmentalBlocks.PURPLE_WISTERIA_SAPLING, (DeferredHolder)EnvironmentalBlocks.POTTED_PURPLE_WISTERIA_SAPLING);
        this.crossBlockWithPot((DeferredHolder)EnvironmentalBlocks.WHITE_WISTERIA_SAPLING, (DeferredHolder)EnvironmentalBlocks.POTTED_WHITE_WISTERIA_SAPLING);
        this.woodworksBlocks((DeferredHolder)EnvironmentalBlocks.WISTERIA_PLANKS, (DeferredHolder)EnvironmentalBlocks.WISTERIA_BOARDS, (DeferredHolder)EnvironmentalBlocks.WISTERIA_LADDER, (DeferredHolder)EnvironmentalBlocks.WISTERIA_BOOKSHELF, (DeferredHolder)EnvironmentalBlocks.WISTERIA_BEEHIVE, (DeferredHolder)EnvironmentalBlocks.WISTERIA_CHEST, (DeferredHolder)EnvironmentalBlocks.TRAPPED_WISTERIA_CHEST);
        this.leafPileBlock((DeferredHolder)EnvironmentalBlocks.PINK_WISTERIA_LEAVES, (DeferredHolder)EnvironmentalBlocks.PINK_WISTERIA_LEAF_PILE);
        this.leafPileBlock((DeferredHolder)EnvironmentalBlocks.BLUE_WISTERIA_LEAVES, (DeferredHolder)EnvironmentalBlocks.BLUE_WISTERIA_LEAF_PILE);
        this.leafPileBlock((DeferredHolder)EnvironmentalBlocks.PURPLE_WISTERIA_LEAVES, (DeferredHolder)EnvironmentalBlocks.PURPLE_WISTERIA_LEAF_PILE);
        this.leafPileBlock((DeferredHolder)EnvironmentalBlocks.WHITE_WISTERIA_LEAVES, (DeferredHolder)EnvironmentalBlocks.WHITE_WISTERIA_LEAF_PILE);
        this.chiseledBookshelfBlock((DeferredHolder)EnvironmentalBlocks.CHISELED_WISTERIA_BOOKSHELF, WISTERIA_BOOKSHELF_POSITIONS);
        this.leavesBlocks((DeferredHolder)EnvironmentalBlocks.HIBISCUS_LEAVES, (DeferredHolder)EnvironmentalBlocks.HIBISCUS_LEAF_PILE);
        this.block((DeferredHolder)EnvironmentalBlocks.CATTAIL_FLUFF_BLOCK);
        this.cattail(EnvironmentalBlocks.CATTAIL_SPROUT, EnvironmentalBlocks.CATTAIL, EnvironmentalBlocks.CATTAIL_STALK);
        this.block((DeferredHolder)EnvironmentalBlocks.BURIED_TRUFFLE);
        this.block((DeferredHolder)EnvironmentalBlocks.CHISELED_MUD_BRICKS);
        this.directionalBlock((DeferredHolder)EnvironmentalBlocks.CHERRY_CRATE);
        this.directionalBlock((DeferredHolder)EnvironmentalBlocks.PLUM_CRATE);
        this.cubeBottomTopBlock((DeferredHolder)EnvironmentalBlocks.DUCK_EGG_CRATE);
        this.crossBlock((DeferredHolder)EnvironmentalBlocks.MYCELIUM_SPROUTS);
        this.cactusBobble(EnvironmentalBlocks.CACTUS_BOBBLE);
        this.crossBlockWithPot((DeferredHolder)EnvironmentalBlocks.BLUEBELL, (DeferredHolder)EnvironmentalBlocks.POTTED_BLUEBELL);
        this.crossBlockWithPot((DeferredHolder)EnvironmentalBlocks.DIANTHUS, (DeferredHolder)EnvironmentalBlocks.POTTED_DIANTHUS);
        this.crossBlockWithPot((DeferredHolder)EnvironmentalBlocks.VIOLET, (DeferredHolder)EnvironmentalBlocks.POTTED_VIOLET);
        this.crossBlockWithPot((DeferredHolder)EnvironmentalBlocks.TASSELFLOWER, (DeferredHolder)EnvironmentalBlocks.POTTED_TASSELFLOWER);
        this.crossBlockWithPot((DeferredHolder)EnvironmentalBlocks.WHITE_LOTUS_FLOWER, (DeferredHolder)EnvironmentalBlocks.POTTED_WHITE_LOTUS_FLOWER);
        this.crossBlockWithPot((DeferredHolder)EnvironmentalBlocks.RED_LOTUS_FLOWER, (DeferredHolder)EnvironmentalBlocks.POTTED_RED_LOTUS_FLOWER);
    }

    public void leavesBlock(DeferredHolder<Block, ?> leaves) {
        this.simpleBlock((Block)leaves.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(EnvironmentalBlockStateProvider.name((Block)((Block)leaves.get())))).parent((ModelFile)new ModelFile.UncheckedModelFile(ResourceLocation.withDefaultNamespace((String)"block/leaves")))).texture("all", this.blockTexture((Block)leaves.get())));
        this.blockItem(leaves);
    }

    public void cubeColumnBlock(DeferredBlock<Block> block) {
        this.cubeColumnBlock(block, block);
    }

    public void cubeColumnBlock(DeferredBlock<Block> block, DeferredBlock<Block> parent) {
        this.simpleBlock((Block)block.get(), (ModelFile)this.models().cubeColumn(EnvironmentalBlockStateProvider.name((Block)((Block)block.get())), EnvironmentalBlockStateProvider.suffix((ResourceLocation)this.blockTexture((Block)parent.get()), (String)"_side"), EnvironmentalBlockStateProvider.suffix((ResourceLocation)this.blockTexture((Block)parent.get()), (String)"_end")));
        this.blockItem((DeferredHolder)block);
    }

    public void cattail(DeferredBlock<Block> cattailSproutObject, DeferredBlock<Block> cattailObject, DeferredBlock<Block> cattailStalkObject) {
        Block cattailSprout = (Block)cattailSproutObject.get();
        Block cattail = (Block)cattailObject.get();
        Block cattailStalk = (Block)cattailStalkObject.get();
        this.getVariantBuilder(cattailSprout).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile(this.cattailStalkModel(EnvironmentalBlockStateProvider.name((Block)cattailSprout), this.blockTexture(cattailSprout), (Integer)state.getValue((Property)CattailBlock.CATTAILS), false)).build(), new Property[]{BlockStateProperties.WATERLOGGED});
        MultiPartBlockStateBuilder cattailBuilder = this.getMultipartBuilder(cattail);
        for (int i = 1; i <= 3; ++i) {
            ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)cattailBuilder.part().modelFile(this.cattailStalkModel(EnvironmentalBlockStateProvider.name((Block)cattail), this.blockTexture(cattail), i, false)).addModel()).condition((Property)CattailBlock.TOP, (Comparable[])new Boolean[]{false}).condition((Property)CattailBlock.CATTAILS, (Comparable[])new Integer[]{i}).end().part().modelFile(this.cattailStalkModel(EnvironmentalBlockStateProvider.name((Block)cattail) + "_top", EnvironmentalBlockStateProvider.suffix((ResourceLocation)this.blockTexture(cattail), (String)"_stalk_top"), i, true)).addModel()).condition((Property)CattailBlock.TOP, (Comparable[])new Boolean[]{true}).condition((Property)CattailBlock.CATTAILS, (Comparable[])new Integer[]{i}).end().part().modelFile(this.cattailHeadModel(EnvironmentalBlockStateProvider.name((Block)cattail) + "_head", EnvironmentalBlockStateProvider.suffix((ResourceLocation)this.blockTexture(cattail), (String)"_head"), false, i)).addModel()).condition((Property)CattailBlock.FLUFFY, (Comparable[])new Boolean[]{false}).condition((Property)CattailBlock.TOP, (Comparable[])new Boolean[]{false}).condition((Property)CattailBlock.CATTAILS, (Comparable[])new Integer[]{i}).end().part().modelFile(this.cattailHeadModel(EnvironmentalBlockStateProvider.name((Block)cattail) + "_head", EnvironmentalBlockStateProvider.suffix((ResourceLocation)this.blockTexture(cattail), (String)"_head"), true, i)).addModel()).condition((Property)CattailBlock.FLUFFY, (Comparable[])new Boolean[]{false}).condition((Property)CattailBlock.TOP, (Comparable[])new Boolean[]{true}).condition((Property)CattailBlock.CATTAILS, (Comparable[])new Integer[]{i}).end().part().modelFile(this.cattailHeadModel(EnvironmentalBlockStateProvider.name((Block)cattail) + "_head_fluffy", EnvironmentalBlockStateProvider.suffix((ResourceLocation)this.blockTexture(cattail), (String)"_head_fluffy"), false, i)).addModel()).condition((Property)CattailBlock.FLUFFY, (Comparable[])new Boolean[]{true}).condition((Property)CattailBlock.TOP, (Comparable[])new Boolean[]{false}).condition((Property)CattailBlock.CATTAILS, (Comparable[])new Integer[]{i}).end().part().modelFile(this.cattailHeadModel(EnvironmentalBlockStateProvider.name((Block)cattail) + "_head_fluffy", EnvironmentalBlockStateProvider.suffix((ResourceLocation)this.blockTexture(cattail), (String)"_head_fluffy"), true, i)).addModel()).condition((Property)CattailBlock.FLUFFY, (Comparable[])new Boolean[]{true}).condition((Property)CattailBlock.TOP, (Comparable[])new Boolean[]{true}).condition((Property)CattailBlock.CATTAILS, (Comparable[])new Integer[]{i}).end();
        }
        this.getVariantBuilder(cattailStalk).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile(this.cattailStalkModel(EnvironmentalBlockStateProvider.name((Block)cattailStalk) + ((Boolean)state.getValue((Property)CattailStalkBlock.BOTTOM) != false ? "_bottom" : "_middle"), EnvironmentalBlockStateProvider.suffix((ResourceLocation)this.blockTexture(cattailStalk), (String)((Boolean)state.getValue((Property)CattailStalkBlock.BOTTOM) != false ? "_bottom" : "_middle")), (Integer)state.getValue((Property)CattailBlock.CATTAILS), false)).build(), new Property[]{BlockStateProperties.WATERLOGGED});
    }

    public ModelFile cattailStalkModel(String name, ResourceLocation texture, int stalks, boolean top) {
        String stalkSuffix = EnvironmentalBlockStateProvider.getStalkSuffix(stalks);
        ModelFile.UncheckedModelFile stalkParent = new ModelFile.UncheckedModelFile(Environmental.location("block/template_cattail_stalk" + stalkSuffix));
        BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name + stalkSuffix)).parent((ModelFile)stalkParent);
        for (int i = 1; i <= stalks; ++i) {
            String suffix = EnvironmentalBlockStateProvider.getStalkSuffix(i);
            builder.texture("stalk" + suffix, top ? EnvironmentalBlockStateProvider.suffix((ResourceLocation)texture, (String)suffix) : texture);
        }
        return builder;
    }

    public static String getStalkSuffix(int stalks) {
        return stalks == 3 ? "_three" : (stalks == 2 ? "_two" : "_one");
    }

    public ModelFile cattailHeadModel(String name, ResourceLocation texture, boolean top, int stalks) {
        String stalkSuffix = stalks == 3 ? "_three" : (stalks == 2 ? "_two" : "_one");
        ModelFile.UncheckedModelFile cattailParent = new ModelFile.UncheckedModelFile(Environmental.location("block/template_" + (top ? "cattail_top" : "cattail") + stalkSuffix));
        return ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name + (top ? "_top" : "") + stalkSuffix)).parent((ModelFile)cattailParent)).texture("cattail", texture);
    }

    public void cactusBobble(DeferredBlock<Block> cactusBobble) {
        this.simpleBlock((Block)cactusBobble.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(EnvironmentalBlockStateProvider.name((Block)((Block)cactusBobble.get())))).parent((ModelFile)new ModelFile.UncheckedModelFile(Environmental.location("block/template_cactus_bobble")))).texture("all", this.blockTexture((Block)cactusBobble.get())));
    }
}

