/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.data.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.teamabnormals.environmental.common.block.CattailBlock;
import com.teamabnormals.environmental.common.block.CupLichenBlock;
import com.teamabnormals.environmental.common.block.DwarfSpruceHeadBlock;
import com.teamabnormals.environmental.core.other.EnvironmentalLootTables;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantedCountIncreaseFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemDamageFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredBlock;

public class EnvironmentalLootTableProvider
extends LootTableProvider {
    public EnvironmentalLootTableProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super(output, BuiltInLootTables.all(), (List)ImmutableList.of((Object)new LootTableProvider.SubProviderEntry(EnvironmentalBlockLoot::new, LootContextParamSets.BLOCK), (Object)new LootTableProvider.SubProviderEntry(EnvironmentalEntityLoot::new, LootContextParamSets.ENTITY), (Object)new LootTableProvider.SubProviderEntry(EnvironmentalChestLoot::new, LootContextParamSets.CHEST)), provider);
    }

    protected void validate(WritableRegistry<LootTable> registry, ValidationContext context, ProblemReporter.Collector collector) {
    }

    private record EnvironmentalChestLoot(HolderLookup.Provider registries) implements LootTableSubProvider
    {
        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
            HolderLookup.RegistryLookup enchantments = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
            consumer.accept(EnvironmentalLootTables.LOG_CABIN_JUNK, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)4.0f, (float)6.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)6.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EnvironmentalBlocks.DWARF_SPRUCE.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EnvironmentalBlocks.PINE_PLANKS.get())).setWeight(3).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)6.0f, (float)12.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EnvironmentalBlocks.PINE_LOG.get())).setWeight(2).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)6.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EnvironmentalBlocks.STRIPPED_PINE_LOG.get())).setWeight(2).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)6.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EnvironmentalBlocks.PINE_LEAVES.get())).setWeight(2).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)4.0f, (float)8.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)2.0f, (float)3.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LANTERN).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.FLOWER_POT).setWeight(2).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EnvironmentalBlocks.PINE_TRAPDOOR.get())).setWeight(2).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EnvironmentalBlocks.PINE_SAPLING.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EnvironmentalBlocks.PINECONE.get())).setWeight(2).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))))));
            consumer.accept(EnvironmentalLootTables.LOG_CABIN, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.STONE_AXE).setWeight(3).apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomApplicableEnchantment((HolderLookup.Provider)this.registries))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.IRON_AXE))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SHEARS).setWeight(2).apply((LootItemFunction.Builder)SetItemDamageFunction.setDamage((NumberProvider)UniformGenerator.between((float)0.8f, (float)1.0f))).apply((LootItemFunction.Builder)new EnchantRandomlyFunction.Builder().withEnchantment((Holder)enchantments.getOrThrow(Enchantments.UNBREAKING)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SHEARS).apply((LootItemFunction.Builder)SetItemDamageFunction.setDamage((NumberProvider)UniformGenerator.between((float)0.5f, (float)0.8f))).apply((LootItemFunction.Builder)new EnchantRandomlyFunction.Builder().withEnchantment((Holder)enchantments.getOrThrow(Enchantments.UNBREAKING))).apply((LootItemFunction.Builder)new EnchantRandomlyFunction.Builder().withEnchantment((Holder)enchantments.getOrThrow(Enchantments.EFFICIENCY))))).withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.FLINT_AND_STEEL).apply((LootItemFunction.Builder)SetItemDamageFunction.setDamage((NumberProvider)UniformGenerator.between((float)0.5f, (float)0.8f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EnvironmentalItems.LUMBERER_BANNER_PATTERN.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EnvironmentalItems.HELPER_BANNER_PATTERN.get())))).withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)5.0f, (float)6.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ROTTEN_FLESH).setWeight(3).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.STICK).setWeight(3).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)6.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.COAL).setWeight(4).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER).setWeight(4).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EnvironmentalItems.VENISON.get())).setWeight(3).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EnvironmentalItems.COOKED_VENISON.get())).setWeight(1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.RABBIT_HIDE).setWeight(4).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.RABBIT).setWeight(3).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.COOKED_RABBIT).setWeight(1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CAMPFIRE).setWeight(4))).withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER_HELMET).setWeight(3)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER_CHESTPLATE).setWeight(3)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER_LEGGINGS).setWeight(3)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER_BOOTS).setWeight(3)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER_HELMET).apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomApplicableEnchantment((HolderLookup.Provider)this.registries))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER_CHESTPLATE).apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomApplicableEnchantment((HolderLookup.Provider)this.registries))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER_LEGGINGS).apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomApplicableEnchantment((HolderLookup.Provider)this.registries))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER_BOOTS).apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomApplicableEnchantment((HolderLookup.Provider)this.registries)))));
            consumer.accept(EnvironmentalLootTables.LOG_CABIN_DISPENSER, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CARVED_PUMPKIN))));
            consumer.accept(EnvironmentalLootTables.LOG_CABIN_DROPPER, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EnvironmentalBlocks.PINE_SAPLING.get())))));
        }
    }

    private static class EnvironmentalEntityLoot
    extends EntityLootSubProvider {
        private static final Set<EntityType<?>> SPECIAL_LOOT_TABLE_TYPES = ImmutableSet.of((Object)((EntityType)EnvironmentalEntityTypes.PINECONE_GOLEM.get()));

        protected EnvironmentalEntityLoot(HolderLookup.Provider provider) {
            super(FeatureFlags.REGISTRY.allFlags(), provider);
        }

        public void generate() {
            this.add((EntityType)EnvironmentalEntityTypes.DEER.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EnvironmentalItems.VENISON.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)this.shouldSmeltLoot())).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
            this.add((EntityType)EnvironmentalEntityTypes.REINDEER.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EnvironmentalItems.VENISON.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)this.shouldSmeltLoot())).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
            this.add((EntityType)EnvironmentalEntityTypes.DUCK.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.FEATHER).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EnvironmentalItems.DUCK.get())).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)this.shouldSmeltLoot())).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
            this.add((EntityType)EnvironmentalEntityTypes.KOI.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EnvironmentalItems.KOI.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BONE_MEAL)).when(LootItemRandomChanceCondition.randomChance((float)0.05f))));
            this.add((EntityType)EnvironmentalEntityTypes.SLABFISH.get(), LootTable.lootTable());
            this.add((EntityType)EnvironmentalEntityTypes.TAPIR.get(), LootTable.lootTable());
            this.add((EntityType)EnvironmentalEntityTypes.YAK.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EnvironmentalItems.YAK_HAIR.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)5.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BEEF).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)this.shouldSmeltLoot())).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
            this.add((EntityType)EnvironmentalEntityTypes.ZEBRA.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
            this.add((EntityType)EnvironmentalEntityTypes.ZORSE.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
            this.add((EntityType)EnvironmentalEntityTypes.ZONKEY.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
            this.add((EntityType)EnvironmentalEntityTypes.PINECONE_GOLEM.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EnvironmentalBlocks.PINE_SAPLING.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))))));
            this.add(EntityType.WANDERING_TRADER, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EnvironmentalItems.MUSIC_DISC_LEAVING_HOME.get()))).when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.ATTACKER, (EntityPredicate.Builder)EntityPredicate.Builder.entity().of(EntityTypeTags.SKELETONS)))));
        }

        public Stream<EntityType<?>> getKnownEntityTypes() {
            return BuiltInRegistries.ENTITY_TYPE.stream().filter(entity -> BuiltInRegistries.ENTITY_TYPE.getKey(entity).getNamespace().equals("environmental") || entity == EntityType.WANDERING_TRADER);
        }

        protected boolean canHaveLootTable(EntityType<?> entityType) {
            return SPECIAL_LOOT_TABLE_TYPES.contains(entityType) || entityType.getCategory() != MobCategory.MISC;
        }
    }

    public static class EnvironmentalBlockLoot
    extends BlockLootSubProvider {
        public static final LootItemCondition.Builder HAS_SHEARS = MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(Tags.Items.TOOLS_SHEAR));
        private static final float[] NORMAL_LEAVES_SAPLING_CHANCES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
        private static final float[] DOUBLE_LEAVES_SAPLING_CHANCES = new float[]{0.1f, 1.25f, 0.16666667f, 0.2f};
        private static final float[] NORMAL_LEAVES_STICK_CHANCES = new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f};
        private static final float[] DOUBLE_LEAVES_STICK_CHANCES = new float[]{0.04f, 0.044444446f, 0.05f, 0.06666667f, 0.2f};

        protected LootItemCondition.Builder doesNotHaveSilkTouch() {
            return this.hasSilkTouch().invert();
        }

        private LootItemCondition.Builder hasShearsOrSilkTouch() {
            return HAS_SHEARS.or(this.hasSilkTouch());
        }

        private LootItemCondition.Builder doesNotHaveShearsOrSilkTouch() {
            return this.hasShearsOrSilkTouch().invert();
        }

        protected EnvironmentalBlockLoot(HolderLookup.Provider provider) {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
        }

        public void generate() {
            HolderLookup.RegistryLookup enchantments = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
            this.dropSelf((Block)EnvironmentalBlocks.CARTWHEEL.get());
            this.dropSelf((Block)EnvironmentalBlocks.BLUEBELL.get());
            this.dropSelf((Block)EnvironmentalBlocks.VIOLET.get());
            this.dropSelf((Block)EnvironmentalBlocks.DIANTHUS.get());
            this.dropSelf((Block)EnvironmentalBlocks.RED_LOTUS_FLOWER.get());
            this.dropSelf((Block)EnvironmentalBlocks.WHITE_LOTUS_FLOWER.get());
            this.dropSelf((Block)EnvironmentalBlocks.TASSELFLOWER.get());
            this.dropSelf((Block)EnvironmentalBlocks.YELLOW_HIBISCUS.get());
            this.dropSelf((Block)EnvironmentalBlocks.ORANGE_HIBISCUS.get());
            this.dropSelf((Block)EnvironmentalBlocks.RED_HIBISCUS.get());
            this.dropSelf((Block)EnvironmentalBlocks.PINK_HIBISCUS.get());
            this.dropSelf((Block)EnvironmentalBlocks.MAGENTA_HIBISCUS.get());
            this.dropSelf((Block)EnvironmentalBlocks.PURPLE_HIBISCUS.get());
            this.dropOther((Block)EnvironmentalBlocks.YELLOW_WALL_HIBISCUS.get(), (ItemLike)EnvironmentalBlocks.YELLOW_HIBISCUS.get());
            this.dropOther((Block)EnvironmentalBlocks.ORANGE_WALL_HIBISCUS.get(), (ItemLike)EnvironmentalBlocks.ORANGE_HIBISCUS.get());
            this.dropOther((Block)EnvironmentalBlocks.RED_WALL_HIBISCUS.get(), (ItemLike)EnvironmentalBlocks.RED_HIBISCUS.get());
            this.dropOther((Block)EnvironmentalBlocks.PINK_WALL_HIBISCUS.get(), (ItemLike)EnvironmentalBlocks.PINK_HIBISCUS.get());
            this.dropOther((Block)EnvironmentalBlocks.MAGENTA_WALL_HIBISCUS.get(), (ItemLike)EnvironmentalBlocks.MAGENTA_HIBISCUS.get());
            this.dropOther((Block)EnvironmentalBlocks.PURPLE_WALL_HIBISCUS.get(), (ItemLike)EnvironmentalBlocks.PURPLE_HIBISCUS.get());
            this.add((Block)EnvironmentalBlocks.BIRD_OF_PARADISE.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
            this.add((Block)EnvironmentalBlocks.PINK_DELPHINIUM.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
            this.add((Block)EnvironmentalBlocks.BLUE_DELPHINIUM.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
            this.add((Block)EnvironmentalBlocks.PURPLE_DELPHINIUM.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
            this.add((Block)EnvironmentalBlocks.WHITE_DELPHINIUM.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
            this.dropPottedContents((Block)EnvironmentalBlocks.POTTED_CARTWHEEL.get());
            this.dropPottedContents((Block)EnvironmentalBlocks.POTTED_BLUEBELL.get());
            this.dropPottedContents((Block)EnvironmentalBlocks.POTTED_VIOLET.get());
            this.dropPottedContents((Block)EnvironmentalBlocks.POTTED_DIANTHUS.get());
            this.dropPottedContents((Block)EnvironmentalBlocks.POTTED_RED_LOTUS_FLOWER.get());
            this.dropPottedContents((Block)EnvironmentalBlocks.POTTED_WHITE_LOTUS_FLOWER.get());
            this.dropPottedContents((Block)EnvironmentalBlocks.POTTED_TASSELFLOWER.get());
            this.dropPottedContents((Block)EnvironmentalBlocks.POTTED_YELLOW_HIBISCUS.get());
            this.dropPottedContents((Block)EnvironmentalBlocks.POTTED_ORANGE_HIBISCUS.get());
            this.dropPottedContents((Block)EnvironmentalBlocks.POTTED_RED_HIBISCUS.get());
            this.dropPottedContents((Block)EnvironmentalBlocks.POTTED_PINK_HIBISCUS.get());
            this.dropPottedContents((Block)EnvironmentalBlocks.POTTED_MAGENTA_HIBISCUS.get());
            this.dropPottedContents((Block)EnvironmentalBlocks.POTTED_PURPLE_HIBISCUS.get());
            this.dropPottedContents((Block)EnvironmentalBlocks.POTTED_BIRD_OF_PARADISE.get());
            this.dropPottedContents((Block)EnvironmentalBlocks.POTTED_PINK_DELPHINIUM.get());
            this.dropPottedContents((Block)EnvironmentalBlocks.POTTED_BLUE_DELPHINIUM.get());
            this.dropPottedContents((Block)EnvironmentalBlocks.POTTED_PURPLE_DELPHINIUM.get());
            this.dropPottedContents((Block)EnvironmentalBlocks.POTTED_WHITE_DELPHINIUM.get());
            this.dropPottedContents((Block)EnvironmentalBlocks.POTTED_CATTAIL.get());
            this.dropPottedContents((Block)EnvironmentalBlocks.POTTED_CUP_LICHEN.get());
            this.dropPottedContents((Block)EnvironmentalBlocks.POTTED_DWARF_SPRUCE.get());
            this.dropSelf((Block)EnvironmentalBlocks.DIRT_BRICKS.get());
            this.dropSelf((Block)EnvironmentalBlocks.DIRT_BRICK_STAIRS.get());
            this.dropSelf((Block)EnvironmentalBlocks.DIRT_BRICK_WALL.get());
            this.add((Block)EnvironmentalBlocks.DIRT_BRICK_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.dropSelf((Block)EnvironmentalBlocks.DIRT_TILES.get());
            this.dropSelf((Block)EnvironmentalBlocks.DIRT_TILE_STAIRS.get());
            this.dropSelf((Block)EnvironmentalBlocks.DIRT_TILE_WALL.get());
            this.add((Block)EnvironmentalBlocks.DIRT_TILE_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.dropSelf((Block)EnvironmentalBlocks.SMOOTH_MUD.get());
            this.add((Block)EnvironmentalBlocks.SMOOTH_MUD_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.dropSelf((Block)EnvironmentalBlocks.CHISELED_MUD_BRICKS.get());
            this.dropSelf((Block)EnvironmentalBlocks.SLABFISH_EFFIGY.get());
            this.dropSelf((Block)EnvironmentalBlocks.GRASS_THATCH.get());
            this.dropSelf((Block)EnvironmentalBlocks.GRASS_THATCH_STAIRS.get());
            this.add((Block)EnvironmentalBlocks.GRASS_THATCH_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.dropSelf((Block)EnvironmentalBlocks.CATTAIL_THATCH.get());
            this.dropSelf((Block)EnvironmentalBlocks.CATTAIL_THATCH_STAIRS.get());
            this.add((Block)EnvironmentalBlocks.CATTAIL_THATCH_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.dropSelf((Block)EnvironmentalBlocks.DUCKWEED_THATCH.get());
            this.dropSelf((Block)EnvironmentalBlocks.DUCKWEED_THATCH_STAIRS.get());
            this.add((Block)EnvironmentalBlocks.DUCKWEED_THATCH_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.add((Block)EnvironmentalBlocks.BURIED_TRUFFLE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)EnvironmentalItems.TRUFFLE.get()));
            this.dropOther((Block)EnvironmentalBlocks.DIRT_PATH.get(), (ItemLike)Blocks.DIRT);
            this.dropOther((Block)EnvironmentalBlocks.MYCELIUM_PATH.get(), (ItemLike)Blocks.DIRT);
            this.dropOther((Block)EnvironmentalBlocks.PODZOL_PATH.get(), (ItemLike)Blocks.DIRT);
            this.add((Block)EnvironmentalBlocks.CATTAIL_SPROUT.get(), block -> this.createCattailDrops((Block)block, (ItemLike)EnvironmentalItems.CATTAIL_FLUFF.get()));
            this.add((Block)EnvironmentalBlocks.CATTAIL.get(), block -> this.createCattailDrops((Block)block, (ItemLike)block));
            this.add((Block)EnvironmentalBlocks.CATTAIL_STALK.get(), EnvironmentalBlockLoot.noDrop());
            this.add((Block)EnvironmentalBlocks.HIBISCUS_LEAVES.get(), block -> this.createSilkTouchOrShearsDispatchTable((Block)block, ((LootPoolSingletonContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)enchantments.getOrThrow(Enchantments.FORTUNE), (float[])DOUBLE_LEAVES_STICK_CHANCES))));
            this.add((Block)EnvironmentalBlocks.HIBISCUS_LEAF_PILE.get(), this::createLeafPileDrops);
            this.add((Block)EnvironmentalBlocks.MYCELIUM_SPROUTS.get(), x$0 -> BlockLootSubProvider.createShearsOnlyDrop((ItemLike)x$0));
            this.add((Block)EnvironmentalBlocks.DUCKWEED.get(), x$0 -> BlockLootSubProvider.createShearsOnlyDrop((ItemLike)x$0));
            this.add((Block)EnvironmentalBlocks.GIANT_TALL_GRASS.get(), block -> this.createDoublePlantWithOtherDrop((Block)block, Blocks.SHORT_GRASS, Items.WHEAT_SEEDS, 3, 0.125f));
            this.add((Block)EnvironmentalBlocks.CUP_LICHEN.get(), this::createCupLichenDrops);
            this.add((Block)EnvironmentalBlocks.CACTUS_BOBBLE.get(), EnvironmentalBlockLoot.noDrop());
            this.add((Block)EnvironmentalBlocks.DWARF_SPRUCE.get(), block -> this.createDwarfSpruceDrops((Block)block, true));
            this.add((Block)EnvironmentalBlocks.DWARF_SPRUCE_PLANT.get(), block -> this.createDwarfSpruceDrops((Block)block, false));
            this.add((Block)EnvironmentalBlocks.DWARF_SPRUCE_TORCH.get(), block -> this.createDwarfSpruceDrops((Block)block, true));
            this.add((Block)EnvironmentalBlocks.DWARF_SPRUCE_PLANT_TORCH.get(), block -> this.createDwarfSpruceDrops((Block)block, false));
            this.add((Block)EnvironmentalBlocks.DWARF_SPRUCE_SOUL_TORCH.get(), block -> this.createDwarfSpruceDrops((Block)block, true));
            this.add((Block)EnvironmentalBlocks.DWARF_SPRUCE_PLANT_SOUL_TORCH.get(), block -> this.createDwarfSpruceDrops((Block)block, false));
            this.add((Block)EnvironmentalBlocks.DWARF_SPRUCE_REDSTONE_TORCH.get(), block -> this.createDwarfSpruceDrops((Block)block, true));
            this.add((Block)EnvironmentalBlocks.DWARF_SPRUCE_PLANT_REDSTONE_TORCH.get(), block -> this.createDwarfSpruceDrops((Block)block, false));
            this.add((Block)EnvironmentalBlocks.DWARF_SPRUCE_ENDER_TORCH.get(), block -> this.createDwarfSpruceDrops((Block)block, true));
            this.add((Block)EnvironmentalBlocks.DWARF_SPRUCE_PLANT_ENDER_TORCH.get(), block -> this.createDwarfSpruceDrops((Block)block, false));
            this.add((Block)EnvironmentalBlocks.DWARF_SPRUCE_CUPRIC_TORCH.get(), block -> this.createDwarfSpruceDrops((Block)block, true));
            this.add((Block)EnvironmentalBlocks.DWARF_SPRUCE_PLANT_CUPRIC_TORCH.get(), block -> this.createDwarfSpruceDrops((Block)block, false));
            this.dropSelf((Block)EnvironmentalBlocks.CATTAIL_FLUFF_BLOCK.get());
            this.dropSelf((Block)EnvironmentalBlocks.CHERRY_CRATE.get());
            this.dropSelf((Block)EnvironmentalBlocks.PLUM_CRATE.get());
            this.dropSelf((Block)EnvironmentalBlocks.DUCK_EGG_CRATE.get());
            this.dropSelf((Block)EnvironmentalBlocks.YAK_HAIR_BLOCK.get());
            this.dropSelf((Block)EnvironmentalBlocks.YAK_HAIR_RUG.get());
            this.dropSelf((Block)EnvironmentalBlocks.PINECONE.get());
            this.dropSelf((Block)EnvironmentalBlocks.WAXED_PINECONE.get());
            this.dropSelf((Block)EnvironmentalBlocks.WILLOW_PLANKS.get());
            this.dropSelf((Block)EnvironmentalBlocks.WILLOW_LOG.get());
            this.dropSelf((Block)EnvironmentalBlocks.WILLOW_WOOD.get());
            this.dropSelf((Block)EnvironmentalBlocks.STRIPPED_WILLOW_LOG.get());
            this.dropSelf((Block)EnvironmentalBlocks.STRIPPED_WILLOW_WOOD.get());
            this.dropSelf((Block)((DeferredBlock)EnvironmentalBlocks.WILLOW_SIGNS.getFirst()).get());
            this.dropSelf((Block)((DeferredBlock)EnvironmentalBlocks.WILLOW_HANGING_SIGNS.getFirst()).get());
            this.dropSelf((Block)EnvironmentalBlocks.WILLOW_PRESSURE_PLATE.get());
            this.dropSelf((Block)EnvironmentalBlocks.WILLOW_TRAPDOOR.get());
            this.dropSelf((Block)EnvironmentalBlocks.WILLOW_BUTTON.get());
            this.dropSelf((Block)EnvironmentalBlocks.WILLOW_STAIRS.get());
            this.dropSelf((Block)EnvironmentalBlocks.WILLOW_FENCE.get());
            this.dropSelf((Block)EnvironmentalBlocks.WILLOW_FENCE_GATE.get());
            this.dropSelf((Block)EnvironmentalBlocks.WILLOW_BOARDS.get());
            this.add((Block)EnvironmentalBlocks.WILLOW_LEAF_PILE.get(), this::createLeafPileDrops);
            this.dropSelf((Block)EnvironmentalBlocks.WILLOW_SAPLING.get());
            this.dropPottedContents((Block)EnvironmentalBlocks.POTTED_WILLOW_SAPLING.get());
            this.dropSelf((Block)EnvironmentalBlocks.WILLOW_LADDER.get());
            this.add((Block)EnvironmentalBlocks.WILLOW_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.add((Block)EnvironmentalBlocks.WILLOW_DOOR.get(), x$0 -> this.createDoorTable((Block)x$0));
            this.add((Block)EnvironmentalBlocks.WILLOW_BEEHIVE.get(), x$0 -> this.createBeeHiveDrop((Block)x$0));
            this.add((Block)EnvironmentalBlocks.WILLOW_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)EnvironmentalBlocks.TRAPPED_WILLOW_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)EnvironmentalBlocks.WILLOW_BOOKSHELF.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Items.BOOK, (NumberProvider)ConstantValue.exactly((float)3.0f)));
            this.dropWhenSilkTouch((Block)EnvironmentalBlocks.CHISELED_WILLOW_BOOKSHELF.get());
            this.add((Block)EnvironmentalBlocks.WILLOW_LEAVES.get(), block -> this.createLeavesDrops((Block)block, (Block)EnvironmentalBlocks.WILLOW_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
            this.add((Block)EnvironmentalBlocks.HANGING_WILLOW_LEAVES.get(), x$0 -> BlockLootSubProvider.createShearsOnlyDrop((ItemLike)x$0));
            this.dropSelf((Block)EnvironmentalBlocks.PINE_PLANKS.get());
            this.dropSelf((Block)EnvironmentalBlocks.PINE_LOG.get());
            this.dropSelf((Block)EnvironmentalBlocks.PINE_WOOD.get());
            this.dropSelf((Block)EnvironmentalBlocks.STRIPPED_PINE_LOG.get());
            this.dropSelf((Block)EnvironmentalBlocks.STRIPPED_PINE_WOOD.get());
            this.dropSelf((Block)((DeferredBlock)EnvironmentalBlocks.PINE_SIGNS.getFirst()).get());
            this.dropSelf((Block)((DeferredBlock)EnvironmentalBlocks.PINE_HANGING_SIGNS.getFirst()).get());
            this.dropSelf((Block)EnvironmentalBlocks.PINE_PRESSURE_PLATE.get());
            this.dropSelf((Block)EnvironmentalBlocks.PINE_TRAPDOOR.get());
            this.dropSelf((Block)EnvironmentalBlocks.PINE_BUTTON.get());
            this.dropSelf((Block)EnvironmentalBlocks.PINE_STAIRS.get());
            this.dropSelf((Block)EnvironmentalBlocks.PINE_FENCE.get());
            this.dropSelf((Block)EnvironmentalBlocks.PINE_FENCE_GATE.get());
            this.dropSelf((Block)EnvironmentalBlocks.PINE_BOARDS.get());
            this.add((Block)EnvironmentalBlocks.PINE_LEAF_PILE.get(), this::createLeafPileDrops);
            this.dropSelf((Block)EnvironmentalBlocks.PINE_SAPLING.get());
            this.dropPottedContents((Block)EnvironmentalBlocks.POTTED_PINE_SAPLING.get());
            this.dropSelf((Block)EnvironmentalBlocks.PINE_LADDER.get());
            this.add((Block)EnvironmentalBlocks.PINE_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.add((Block)EnvironmentalBlocks.PINE_DOOR.get(), x$0 -> this.createDoorTable((Block)x$0));
            this.add((Block)EnvironmentalBlocks.PINE_BEEHIVE.get(), x$0 -> this.createBeeHiveDrop((Block)x$0));
            this.add((Block)EnvironmentalBlocks.PINE_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)EnvironmentalBlocks.TRAPPED_PINE_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)EnvironmentalBlocks.PINE_BOOKSHELF.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Items.BOOK, (NumberProvider)ConstantValue.exactly((float)3.0f)));
            this.dropWhenSilkTouch((Block)EnvironmentalBlocks.CHISELED_PINE_BOOKSHELF.get());
            this.add((Block)EnvironmentalBlocks.PINE_LEAVES.get(), block -> this.createLeavesDrops((Block)block, (Block)EnvironmentalBlocks.PINE_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
            this.dropSelf((Block)EnvironmentalBlocks.PLUM_PLANKS.get());
            this.dropSelf((Block)EnvironmentalBlocks.PLUM_LOG.get());
            this.dropSelf((Block)EnvironmentalBlocks.PLUM_WOOD.get());
            this.dropSelf((Block)EnvironmentalBlocks.STRIPPED_PLUM_LOG.get());
            this.dropSelf((Block)EnvironmentalBlocks.STRIPPED_PLUM_WOOD.get());
            this.dropSelf((Block)((DeferredBlock)EnvironmentalBlocks.PLUM_SIGNS.getFirst()).get());
            this.dropSelf((Block)((DeferredBlock)EnvironmentalBlocks.PLUM_HANGING_SIGNS.getFirst()).get());
            this.dropSelf((Block)EnvironmentalBlocks.PLUM_PRESSURE_PLATE.get());
            this.dropSelf((Block)EnvironmentalBlocks.PLUM_TRAPDOOR.get());
            this.dropSelf((Block)EnvironmentalBlocks.PLUM_BUTTON.get());
            this.dropSelf((Block)EnvironmentalBlocks.PLUM_STAIRS.get());
            this.dropSelf((Block)EnvironmentalBlocks.PLUM_FENCE.get());
            this.dropSelf((Block)EnvironmentalBlocks.PLUM_FENCE_GATE.get());
            this.dropSelf((Block)EnvironmentalBlocks.PLUM_BOARDS.get());
            this.dropSelf((Block)EnvironmentalBlocks.PLUM_LADDER.get());
            this.add((Block)EnvironmentalBlocks.PLUM_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.add((Block)EnvironmentalBlocks.PLUM_DOOR.get(), x$0 -> this.createDoorTable((Block)x$0));
            this.add((Block)EnvironmentalBlocks.PLUM_BEEHIVE.get(), x$0 -> this.createBeeHiveDrop((Block)x$0));
            this.add((Block)EnvironmentalBlocks.PLUM_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)EnvironmentalBlocks.TRAPPED_PLUM_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)EnvironmentalBlocks.PLUM_BOOKSHELF.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Items.BOOK, (NumberProvider)ConstantValue.exactly((float)3.0f)));
            this.dropWhenSilkTouch((Block)EnvironmentalBlocks.CHISELED_PLUM_BOOKSHELF.get());
            this.add((Block)EnvironmentalBlocks.PLUM_LEAVES.get(), block -> this.createPlumLeavesDrops((Block)block, (Block)EnvironmentalBlocks.PLUM_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
            this.add((Block)EnvironmentalBlocks.PLUM_LEAF_PILE.get(), this::createLeafPileDrops);
            this.dropSelf((Block)EnvironmentalBlocks.PLUM_SAPLING.get());
            this.dropPottedContents((Block)EnvironmentalBlocks.POTTED_PLUM_SAPLING.get());
            this.add((Block)EnvironmentalBlocks.CHEERFUL_PLUM_LEAVES.get(), block -> this.createPlumLeavesDrops((Block)block, (Block)EnvironmentalBlocks.CHEERFUL_PLUM_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
            this.add((Block)EnvironmentalBlocks.CHEERFUL_PLUM_LEAF_PILE.get(), this::createLeafPileDrops);
            this.dropSelf((Block)EnvironmentalBlocks.CHEERFUL_PLUM_SAPLING.get());
            this.dropPottedContents((Block)EnvironmentalBlocks.POTTED_CHEERFUL_PLUM_SAPLING.get());
            this.add((Block)EnvironmentalBlocks.MOODY_PLUM_LEAVES.get(), block -> this.createPlumLeavesDrops((Block)block, (Block)EnvironmentalBlocks.MOODY_PLUM_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
            this.add((Block)EnvironmentalBlocks.MOODY_PLUM_LEAF_PILE.get(), this::createLeafPileDrops);
            this.dropSelf((Block)EnvironmentalBlocks.MOODY_PLUM_SAPLING.get());
            this.dropPottedContents((Block)EnvironmentalBlocks.POTTED_MOODY_PLUM_SAPLING.get());
            this.dropSelf((Block)EnvironmentalBlocks.WISTERIA_PLANKS.get());
            this.dropSelf((Block)EnvironmentalBlocks.WISTERIA_LOG.get());
            this.dropSelf((Block)EnvironmentalBlocks.WISTERIA_WOOD.get());
            this.dropSelf((Block)EnvironmentalBlocks.STRIPPED_WISTERIA_LOG.get());
            this.dropSelf((Block)EnvironmentalBlocks.STRIPPED_WISTERIA_WOOD.get());
            this.dropSelf((Block)((DeferredBlock)EnvironmentalBlocks.WISTERIA_SIGNS.getFirst()).get());
            this.dropSelf((Block)((DeferredBlock)EnvironmentalBlocks.WISTERIA_HANGING_SIGNS.getFirst()).get());
            this.dropSelf((Block)EnvironmentalBlocks.WISTERIA_PRESSURE_PLATE.get());
            this.dropSelf((Block)EnvironmentalBlocks.WISTERIA_TRAPDOOR.get());
            this.dropSelf((Block)EnvironmentalBlocks.WISTERIA_BUTTON.get());
            this.dropSelf((Block)EnvironmentalBlocks.WISTERIA_STAIRS.get());
            this.dropSelf((Block)EnvironmentalBlocks.WISTERIA_FENCE.get());
            this.dropSelf((Block)EnvironmentalBlocks.WISTERIA_FENCE_GATE.get());
            this.dropSelf((Block)EnvironmentalBlocks.WISTERIA_BOARDS.get());
            this.add((Block)EnvironmentalBlocks.PINK_WISTERIA_LEAF_PILE.get(), this::createLeafPileDrops);
            this.add((Block)EnvironmentalBlocks.BLUE_WISTERIA_LEAF_PILE.get(), this::createLeafPileDrops);
            this.add((Block)EnvironmentalBlocks.PURPLE_WISTERIA_LEAF_PILE.get(), this::createLeafPileDrops);
            this.add((Block)EnvironmentalBlocks.WHITE_WISTERIA_LEAF_PILE.get(), this::createLeafPileDrops);
            this.add((Block)EnvironmentalBlocks.WISTERIA_LEAVES.get(), block -> this.createSilkTouchOrShearsDispatchTable((Block)block, ((LootPoolSingletonContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)enchantments.getOrThrow(Enchantments.FORTUNE), (float[])DOUBLE_LEAVES_STICK_CHANCES))));
            this.add((Block)EnvironmentalBlocks.WISTERIA_LEAF_PILE.get(), this::createLeafPileDrops);
            this.dropSelf((Block)EnvironmentalBlocks.PINK_WISTERIA_SAPLING.get());
            this.dropSelf((Block)EnvironmentalBlocks.BLUE_WISTERIA_SAPLING.get());
            this.dropSelf((Block)EnvironmentalBlocks.PURPLE_WISTERIA_SAPLING.get());
            this.dropSelf((Block)EnvironmentalBlocks.WHITE_WISTERIA_SAPLING.get());
            this.dropPottedContents((Block)EnvironmentalBlocks.POTTED_PINK_WISTERIA_SAPLING.get());
            this.dropPottedContents((Block)EnvironmentalBlocks.POTTED_BLUE_WISTERIA_SAPLING.get());
            this.dropPottedContents((Block)EnvironmentalBlocks.POTTED_PURPLE_WISTERIA_SAPLING.get());
            this.dropPottedContents((Block)EnvironmentalBlocks.POTTED_WHITE_WISTERIA_SAPLING.get());
            this.dropSelf((Block)EnvironmentalBlocks.WISTERIA_LADDER.get());
            this.add((Block)EnvironmentalBlocks.WISTERIA_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.add((Block)EnvironmentalBlocks.WISTERIA_DOOR.get(), x$0 -> this.createDoorTable((Block)x$0));
            this.add((Block)EnvironmentalBlocks.WISTERIA_BEEHIVE.get(), x$0 -> this.createBeeHiveDrop((Block)x$0));
            this.add((Block)EnvironmentalBlocks.WISTERIA_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)EnvironmentalBlocks.TRAPPED_WISTERIA_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)EnvironmentalBlocks.WISTERIA_BOOKSHELF.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Items.BOOK, (NumberProvider)ConstantValue.exactly((float)3.0f)));
            this.dropWhenSilkTouch((Block)EnvironmentalBlocks.CHISELED_WISTERIA_BOOKSHELF.get());
            this.add((Block)EnvironmentalBlocks.PINK_WISTERIA_LEAVES.get(), block -> this.createWisteriaLeavesDrops((Block)block, (Block)EnvironmentalBlocks.PINK_WISTERIA_SAPLING.get(), DOUBLE_LEAVES_SAPLING_CHANCES));
            this.add((Block)EnvironmentalBlocks.BLUE_WISTERIA_LEAVES.get(), block -> this.createWisteriaLeavesDrops((Block)block, (Block)EnvironmentalBlocks.BLUE_WISTERIA_SAPLING.get(), DOUBLE_LEAVES_SAPLING_CHANCES));
            this.add((Block)EnvironmentalBlocks.PURPLE_WISTERIA_LEAVES.get(), block -> this.createWisteriaLeavesDrops((Block)block, (Block)EnvironmentalBlocks.PURPLE_WISTERIA_SAPLING.get(), DOUBLE_LEAVES_SAPLING_CHANCES));
            this.add((Block)EnvironmentalBlocks.WHITE_WISTERIA_LEAVES.get(), block -> this.createWisteriaLeavesDrops((Block)block, (Block)EnvironmentalBlocks.WHITE_WISTERIA_SAPLING.get(), DOUBLE_LEAVES_SAPLING_CHANCES));
            this.add((Block)EnvironmentalBlocks.PINK_HANGING_WISTERIA_LEAVES.get(), x$0 -> BlockLootSubProvider.createShearsOnlyDrop((ItemLike)x$0));
            this.add((Block)EnvironmentalBlocks.BLUE_HANGING_WISTERIA_LEAVES.get(), x$0 -> BlockLootSubProvider.createShearsOnlyDrop((ItemLike)x$0));
            this.add((Block)EnvironmentalBlocks.PURPLE_HANGING_WISTERIA_LEAVES.get(), x$0 -> BlockLootSubProvider.createShearsOnlyDrop((ItemLike)x$0));
            this.add((Block)EnvironmentalBlocks.WHITE_HANGING_WISTERIA_LEAVES.get(), x$0 -> BlockLootSubProvider.createShearsOnlyDrop((ItemLike)x$0));
        }

        protected LootTable.Builder createCupLichenDrops(Block block) {
            return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, LootItem.lootTableItem((ItemLike)block).apply(List.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)), cups -> SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)cups.intValue())).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)CupLichenBlock.CUPS, cups.intValue())))))));
        }

        protected LootTable.Builder createDwarfSpruceDrops(Block block, boolean isHead) {
            LootTable.Builder builder = LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EnvironmentalBlocks.DWARF_SPRUCE.get())).when(HAS_SHEARS)).otherwise((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)))))));
            if (isHead) {
                builder = builder.withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.NETHER_STAR)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DwarfSpruceHeadBlock.STAR, true))));
            }
            return builder;
        }

        protected LootTable.Builder createCattailDrops(Block block, ItemLike drop) {
            return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, LootItem.lootTableItem((ItemLike)drop).apply(List.of(Integer.valueOf(2), Integer.valueOf(3)), cattails -> SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)cattails.intValue())).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)CattailBlock.CATTAILS, cattails.intValue())))))));
        }

        protected LootTable.Builder createPlumLeavesDrops(Block block, Block sapling, float ... saplingChances) {
            HolderLookup.RegistryLookup enchantments = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
            return this.createLeavesDrops(block, sapling, saplingChances).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.doesNotHaveShearsOrSilkTouch()).add(((LootPoolSingletonContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)EnvironmentalItems.PLUM.get())))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)enchantments.getOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.05f, 0.055555556f, 0.0625f, 0.08333334f, 0.25f}))));
        }

        protected LootTable.Builder createWisteriaLeavesDrops(Block block, Block sapling, float ... saplingChances) {
            HolderLookup.RegistryLookup enchantments = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
            LootItemBlockStatePropertyCondition.Builder isBottom = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM));
            LootItemCondition.Builder isTop = isBottom.invert();
            LootPool.Builder coloredLeafPool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when((LootItemCondition.Builder)isBottom).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(this.hasShearsOrSilkTouch())).otherwise(((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)sapling, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)sapling))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)enchantments.getOrThrow(Enchantments.FORTUNE), (float[])saplingChances))));
            LootPool.Builder greenLeafPool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(isTop).add(LootItem.lootTableItem((ItemLike)((ItemLike)EnvironmentalBlocks.WISTERIA_LEAVES.get())).when(this.hasShearsOrSilkTouch()));
            LootPool.Builder coloredStickPool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when((LootItemCondition.Builder)isBottom).when(this.doesNotHaveShearsOrSilkTouch()).add(((LootPoolSingletonContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)enchantments.getOrThrow(Enchantments.FORTUNE), (float[])NORMAL_LEAVES_STICK_CHANCES)));
            LootPool.Builder greenStickPool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(isTop).when(this.doesNotHaveShearsOrSilkTouch()).add(((LootPoolSingletonContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)enchantments.getOrThrow(Enchantments.FORTUNE), (float[])DOUBLE_LEAVES_STICK_CHANCES)));
            return LootTable.lootTable().withPool(coloredLeafPool).withPool(greenLeafPool).withPool(coloredStickPool).withPool(greenStickPool);
        }

        protected LootTable.Builder createLeafPileDrops(Block block) {
            return this.createMultifaceBlockDrops(block, HAS_SHEARS);
        }

        protected LootTable.Builder createDoublePlantWithOtherDrop(Block block, Block grass, Item drop, int count, float chance) {
            AlternativesEntry.Builder builder = ((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)grass).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)count))).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(Tags.Items.TOOLS_SHEAR)))).otherwise(((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)drop))).when(LootItemRandomChanceCondition.randomChance((float)chance)));
            return LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)builder).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER))).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{block}).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER))), (BlockPos)new BlockPos(0, 1, 0)))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)builder).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER))).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{block}).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER))), (BlockPos)new BlockPos(0, -1, 0))));
        }

        public Iterable<Block> getKnownBlocks() {
            return BuiltInRegistries.BLOCK.stream().filter(block -> BuiltInRegistries.BLOCK.getKey(block).getNamespace().equals("environmental")).collect(Collectors.toSet());
        }
    }
}

