/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.data.server;

import com.teamabnormals.blueprint.core.data.server.BlueprintRecipeProvider;
import com.teamabnormals.boatload.core.api.BoatloadBoatType;
import com.teamabnormals.boatload.core.data.server.BoatloadRecipeProvider;
import com.teamabnormals.environmental.core.Environmental;
import com.teamabnormals.environmental.core.other.EnvironmentalBlockFamilies;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalItemTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import com.teamabnormals.environmental.integration.boatload.EnvironmentalBoatTypes;
import com.teamabnormals.woodworks.core.data.server.WoodworksRecipeProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.registries.DeferredBlock;

public class EnvironmentalRecipeProvider
extends BlueprintRecipeProvider {
    public static final ModLoadedCondition INCUBATION_LOADED = new ModLoadedCondition("incubation");
    public static final ModLoadedCondition BERRY_GOOD_LOADED = new ModLoadedCondition("berry_good");

    public EnvironmentalRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super("environmental", output, provider);
    }

    public void buildRecipes(RecipeOutput consumer) {
        this.conversionRecipe(consumer, (ItemLike)Items.LIGHT_BLUE_DYE, (ItemLike)EnvironmentalBlocks.BLUE_DELPHINIUM.get(), "light_blue_dye", 2);
        this.conversionRecipe(consumer, (ItemLike)Items.PINK_DYE, (ItemLike)EnvironmentalBlocks.PINK_DELPHINIUM.get(), "pink_dye", 2);
        this.conversionRecipe(consumer, (ItemLike)Items.WHITE_DYE, (ItemLike)EnvironmentalBlocks.WHITE_DELPHINIUM.get(), "white_dye", 2);
        this.conversionRecipe(consumer, (ItemLike)Items.PURPLE_DYE, (ItemLike)EnvironmentalBlocks.PURPLE_DELPHINIUM.get(), "purple_dye", 2);
        this.conversionRecipe(consumer, (ItemLike)Items.BLUE_DYE, (ItemLike)EnvironmentalBlocks.BLUEBELL.get(), "blue_dye");
        this.conversionRecipe(consumer, (ItemLike)Items.LIME_DYE, (ItemLike)EnvironmentalBlocks.DIANTHUS.get(), "lime_dye");
        this.conversionRecipe(consumer, (ItemLike)Items.ORANGE_DYE, (ItemLike)EnvironmentalBlocks.BIRD_OF_PARADISE.get(), "orange_dye", 2);
        this.conversionRecipe(consumer, (ItemLike)Items.PINK_DYE, (ItemLike)EnvironmentalBlocks.CARTWHEEL.get(), "pink_dye");
        this.conversionRecipe(consumer, (ItemLike)Items.PURPLE_DYE, (ItemLike)EnvironmentalBlocks.VIOLET.get(), "purple_dye");
        this.conversionRecipe(consumer, (ItemLike)Items.RED_DYE, (ItemLike)EnvironmentalBlocks.RED_LOTUS_FLOWER.get(), "red_dye");
        this.conversionRecipe(consumer, (ItemLike)Items.WHITE_DYE, (ItemLike)EnvironmentalBlocks.WHITE_LOTUS_FLOWER.get(), "white_dye");
        this.conversionRecipe(consumer, (ItemLike)Items.ORANGE_DYE, (ItemLike)EnvironmentalBlocks.TASSELFLOWER.get(), "purple_dye");
        this.conversionRecipe(consumer, (ItemLike)Items.MAGENTA_DYE, (ItemLike)EnvironmentalBlocks.MAGENTA_HIBISCUS.get(), "magenta_dye");
        this.conversionRecipe(consumer, (ItemLike)Items.ORANGE_DYE, (ItemLike)EnvironmentalBlocks.ORANGE_HIBISCUS.get(), "orange_dye");
        this.conversionRecipe(consumer, (ItemLike)Items.PINK_DYE, (ItemLike)EnvironmentalBlocks.PINK_HIBISCUS.get(), "pink_dye");
        this.conversionRecipe(consumer, (ItemLike)Items.YELLOW_DYE, (ItemLike)EnvironmentalBlocks.YELLOW_HIBISCUS.get(), "yellow_dye");
        this.conversionRecipe(consumer, (ItemLike)Items.RED_DYE, (ItemLike)EnvironmentalBlocks.RED_HIBISCUS.get(), "red_dye");
        this.conversionRecipe(consumer, (ItemLike)Items.PURPLE_DYE, (ItemLike)EnvironmentalBlocks.PURPLE_HIBISCUS.get(), "purple_dye");
        WoodworksRecipeProvider.conditionalLeafPileRecipes((RecipeOutput)consumer, (ItemLike)((ItemLike)EnvironmentalBlocks.HIBISCUS_LEAVES.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.HIBISCUS_LEAF_PILE.get()), (String)"environmental");
        EnvironmentalRecipeProvider.foodCookingRecipes((RecipeOutput)consumer, (ItemLike)((ItemLike)EnvironmentalItems.DUCK.get()), (ItemLike)((ItemLike)EnvironmentalItems.COOKED_DUCK.get()));
        EnvironmentalRecipeProvider.foodCookingRecipes((RecipeOutput)consumer, (ItemLike)((ItemLike)EnvironmentalItems.VENISON.get()), (ItemLike)((ItemLike)EnvironmentalItems.COOKED_VENISON.get()));
        this.conditionalStorageRecipes(consumer, (ICondition)INCUBATION_LOADED, RecipeCategory.MISC, (ItemLike)EnvironmentalItems.DUCK_EGG.get(), RecipeCategory.DECORATIONS, (ItemLike)EnvironmentalBlocks.DUCK_EGG_CRATE.get());
        this.conditionalStorageRecipes(consumer, (ICondition)BERRY_GOOD_LOADED, RecipeCategory.FOOD, (ItemLike)EnvironmentalItems.CHERRIES.get(), RecipeCategory.DECORATIONS, (ItemLike)EnvironmentalBlocks.CHERRY_CRATE.get());
        this.conditionalStorageRecipes(consumer, (ICondition)BERRY_GOOD_LOADED, RecipeCategory.FOOD, (ItemLike)EnvironmentalItems.PLUM.get(), RecipeCategory.DECORATIONS, (ItemLike)EnvironmentalBlocks.PLUM_CRATE.get());
        this.storageRecipes(consumer, RecipeCategory.MISC, (ItemLike)EnvironmentalItems.CATTAIL_FLUFF.get(), RecipeCategory.BUILDING_BLOCKS, (ItemLike)EnvironmentalBlocks.CATTAIL_FLUFF_BLOCK.get());
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STRING).requires((ItemLike)EnvironmentalItems.CATTAIL_FLUFF.get(), 7).unlockedBy("has_cattail_seeds", EnvironmentalRecipeProvider.has((ItemLike)((ItemLike)EnvironmentalItems.CATTAIL_FLUFF.get()))).save(consumer, this.getModConversionRecipeName((ItemLike)Items.STRING, (ItemLike)EnvironmentalItems.CATTAIL_FLUFF.get()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnvironmentalBlocks.GRASS_THATCH.get()), (int)4).define(Character.valueOf('W'), (ItemLike)Items.WHEAT).define(Character.valueOf('G'), (ItemLike)Blocks.SHORT_GRASS).pattern("WG").pattern("GW").group("grass_thatch").unlockedBy("has_grass", EnvironmentalRecipeProvider.has((ItemLike)Blocks.SHORT_GRASS)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnvironmentalBlocks.GRASS_THATCH.get()), (int)6).define(Character.valueOf('W'), (ItemLike)Items.WHEAT).define(Character.valueOf('G'), (ItemLike)Blocks.TALL_GRASS).pattern("WG").pattern("GW").group("grass_thatch").unlockedBy("has_tall_grass", EnvironmentalRecipeProvider.has((ItemLike)Blocks.TALL_GRASS)).save(consumer, this.getModConversionRecipeName((ItemLike)EnvironmentalBlocks.GRASS_THATCH.get(), (ItemLike)Blocks.SHORT_GRASS));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnvironmentalBlocks.GRASS_THATCH.get()), (int)8).define(Character.valueOf('W'), (ItemLike)Items.WHEAT).define(Character.valueOf('G'), (ItemLike)EnvironmentalBlocks.GIANT_TALL_GRASS.get()).pattern("WG").pattern("GW").group("grass_thatch").unlockedBy("has_giant_tall_grass", EnvironmentalRecipeProvider.has((ItemLike)((ItemLike)EnvironmentalBlocks.GIANT_TALL_GRASS.get()))).save(consumer, this.getModConversionRecipeName((ItemLike)EnvironmentalBlocks.GRASS_THATCH.get(), (ItemLike)EnvironmentalBlocks.GIANT_TALL_GRASS.get()));
        EnvironmentalRecipeProvider.generateRecipes((RecipeOutput)consumer, (BlockFamily)EnvironmentalBlockFamilies.GRASS_THATCH_FAMILY);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnvironmentalBlocks.CATTAIL_THATCH.get()), (int)4).define(Character.valueOf('#'), (ItemLike)EnvironmentalBlocks.CATTAIL.get()).pattern("##").pattern("##").unlockedBy("has_cattail", EnvironmentalRecipeProvider.has((ItemLike)((ItemLike)EnvironmentalBlocks.CATTAIL.get()))).save(consumer);
        EnvironmentalRecipeProvider.generateRecipes((RecipeOutput)consumer, (BlockFamily)EnvironmentalBlockFamilies.CATTAIL_THATCH_FAMILY);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnvironmentalBlocks.DUCKWEED_THATCH.get()), (int)4).define(Character.valueOf('#'), (ItemLike)EnvironmentalBlocks.DUCKWEED.get()).pattern("##").pattern("##").unlockedBy("has_duckweed", EnvironmentalRecipeProvider.has((ItemLike)((ItemLike)EnvironmentalBlocks.DUCKWEED.get()))).save(consumer);
        EnvironmentalRecipeProvider.generateRecipes((RecipeOutput)consumer, (BlockFamily)EnvironmentalBlockFamilies.DUCKWEED_THATCH_FAMILY);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnvironmentalBlocks.DIRT_BRICKS.get()), (int)4).define(Character.valueOf('#'), (ItemLike)Blocks.DIRT).pattern("##").pattern("##").unlockedBy(EnvironmentalRecipeProvider.getHasName((ItemLike)Blocks.DIRT), EnvironmentalRecipeProvider.has((ItemLike)Blocks.DIRT)).save(consumer);
        EnvironmentalRecipeProvider.generateRecipes((RecipeOutput)consumer, (BlockFamily)EnvironmentalBlockFamilies.DIRT_BRICK_FAMILY);
        this.stonecutterRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)EnvironmentalBlocks.DIRT_BRICK_SLAB.get(), (ItemLike)EnvironmentalBlocks.DIRT_BRICKS.get(), 2);
        this.stonecutterRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)EnvironmentalBlocks.DIRT_BRICK_STAIRS.get(), (ItemLike)EnvironmentalBlocks.DIRT_BRICKS.get());
        this.stonecutterRecipe(consumer, RecipeCategory.DECORATIONS, (ItemLike)EnvironmentalBlocks.DIRT_BRICK_WALL.get(), (ItemLike)EnvironmentalBlocks.DIRT_BRICKS.get());
        this.stonecutterRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)EnvironmentalBlocks.DIRT_BRICKS.get(), (ItemLike)Blocks.DIRT);
        this.stonecutterRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)EnvironmentalBlocks.DIRT_BRICK_SLAB.get(), (ItemLike)Blocks.DIRT, 2);
        this.stonecutterRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)EnvironmentalBlocks.DIRT_BRICK_STAIRS.get(), (ItemLike)Blocks.DIRT);
        this.stonecutterRecipe(consumer, RecipeCategory.DECORATIONS, (ItemLike)EnvironmentalBlocks.DIRT_BRICK_WALL.get(), (ItemLike)Blocks.DIRT);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnvironmentalBlocks.DIRT_TILES.get()), (int)4).define(Character.valueOf('#'), (ItemLike)EnvironmentalBlocks.DIRT_BRICKS.get()).pattern("##").pattern("##").unlockedBy(EnvironmentalRecipeProvider.getHasName((ItemLike)((ItemLike)EnvironmentalBlocks.DIRT_BRICKS.get())), EnvironmentalRecipeProvider.has((ItemLike)((ItemLike)EnvironmentalBlocks.DIRT_BRICKS.get()))).save(consumer);
        EnvironmentalRecipeProvider.generateRecipes((RecipeOutput)consumer, (BlockFamily)EnvironmentalBlockFamilies.DIRT_TILE_FAMILY);
        this.stonecutterRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)EnvironmentalBlocks.DIRT_TILE_SLAB.get(), (ItemLike)EnvironmentalBlocks.DIRT_TILES.get(), 2);
        this.stonecutterRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)EnvironmentalBlocks.DIRT_TILE_STAIRS.get(), (ItemLike)EnvironmentalBlocks.DIRT_TILES.get());
        this.stonecutterRecipe(consumer, RecipeCategory.DECORATIONS, (ItemLike)EnvironmentalBlocks.DIRT_TILE_WALL.get(), (ItemLike)EnvironmentalBlocks.DIRT_TILES.get());
        this.stonecutterRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)EnvironmentalBlocks.DIRT_TILES.get(), (ItemLike)EnvironmentalBlocks.DIRT_BRICKS.get());
        this.stonecutterRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)EnvironmentalBlocks.DIRT_TILE_SLAB.get(), (ItemLike)EnvironmentalBlocks.DIRT_BRICKS.get(), 2);
        this.stonecutterRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)EnvironmentalBlocks.DIRT_TILE_STAIRS.get(), (ItemLike)EnvironmentalBlocks.DIRT_BRICKS.get());
        this.stonecutterRecipe(consumer, RecipeCategory.DECORATIONS, (ItemLike)EnvironmentalBlocks.DIRT_TILE_WALL.get(), (ItemLike)EnvironmentalBlocks.DIRT_BRICKS.get());
        this.stonecutterRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)EnvironmentalBlocks.DIRT_TILES.get(), (ItemLike)Blocks.DIRT);
        this.stonecutterRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)EnvironmentalBlocks.DIRT_TILE_SLAB.get(), (ItemLike)Blocks.DIRT, 2);
        this.stonecutterRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)EnvironmentalBlocks.DIRT_TILE_STAIRS.get(), (ItemLike)Blocks.DIRT);
        this.stonecutterRecipe(consumer, RecipeCategory.DECORATIONS, (ItemLike)EnvironmentalBlocks.DIRT_TILE_WALL.get(), (ItemLike)Blocks.DIRT);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.MUD).define(Character.valueOf('#'), (ItemLike)EnvironmentalItems.MUD_BALL.get()).pattern("##").pattern("##").unlockedBy("has_mud_ball", EnvironmentalRecipeProvider.has((ItemLike)((ItemLike)EnvironmentalItems.MUD_BALL.get()))).save(consumer, Environmental.location(RecipeBuilder.getDefaultRecipeId((ItemLike)Blocks.MUD).getPath()));
        EnvironmentalRecipeProvider.conversionRecipeBuilder((ItemLike)((ItemLike)EnvironmentalItems.MUD_BALL.get()), (ItemLike)Blocks.MUD, (int)4).group("mud_ball").save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)EnvironmentalItems.MUD_BALL.get()), (int)16).requires(Tags.Items.BUCKETS_WATER).requires(EnvironmentalItemTags.CONVERTABLE_TO_MUD).requires(EnvironmentalItemTags.CONVERTABLE_TO_MUD).requires(EnvironmentalItemTags.CONVERTABLE_TO_MUD).requires(EnvironmentalItemTags.CONVERTABLE_TO_MUD).group("mud_ball").unlockedBy("has_convertable_to_mud", EnvironmentalRecipeProvider.has(EnvironmentalItemTags.CONVERTABLE_TO_MUD)).save(consumer, this.getModConversionRecipeName((ItemLike)EnvironmentalItems.MUD_BALL.get(), (ItemLike)Blocks.DIRT));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnvironmentalBlocks.SLABFISH_EFFIGY.get())).define(Character.valueOf('#'), (ItemLike)Blocks.MUD_BRICKS).define(Character.valueOf('S'), (ItemLike)Blocks.MUD_BRICK_SLAB).pattern(" S ").pattern("S#S").unlockedBy("has_mud_bricks", EnvironmentalRecipeProvider.has((ItemLike)Blocks.MUD_BRICKS)).save(consumer);
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Blocks.PACKED_MUD}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((Block)EnvironmentalBlocks.SMOOTH_MUD.get()).asItem(), (float)0.1f, (int)200).unlockedBy("has_packed_mud", EnvironmentalRecipeProvider.has((ItemLike)Blocks.PACKED_MUD)).save(consumer);
        EnvironmentalRecipeProvider.generateRecipes((RecipeOutput)consumer, (BlockFamily)EnvironmentalBlockFamilies.SMOOTH_MUD_FAMILY);
        this.stonecutterRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)EnvironmentalBlocks.SMOOTH_MUD_SLAB.get(), (ItemLike)EnvironmentalBlocks.SMOOTH_MUD.get(), 2);
        EnvironmentalRecipeProvider.chiseled((RecipeOutput)consumer, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)EnvironmentalBlocks.CHISELED_MUD_BRICKS.get()), (ItemLike)Blocks.MUD_BRICK_SLAB);
        this.stonecutterRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)EnvironmentalBlocks.CHISELED_MUD_BRICKS.get(), (ItemLike)Blocks.MUD_BRICKS);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.BROWN_WOOL).define(Character.valueOf('#'), (ItemLike)EnvironmentalItems.YAK_HAIR.get()).pattern("##").pattern("##").unlockedBy("has_yak_hair", EnvironmentalRecipeProvider.has((ItemLike)((ItemLike)EnvironmentalItems.YAK_HAIR.get()))).save(consumer, Environmental.location(EnvironmentalRecipeProvider.getItemName((ItemLike)Blocks.BROWN_WOOL)));
        this.storageRecipes(consumer, RecipeCategory.MISC, (ItemLike)EnvironmentalItems.YAK_HAIR.get(), RecipeCategory.BUILDING_BLOCKS, (ItemLike)EnvironmentalBlocks.YAK_HAIR_BLOCK.get());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnvironmentalBlocks.YAK_HAIR_RUG.get())).define(Character.valueOf('#'), (ItemLike)EnvironmentalItems.YAK_HAIR.get()).pattern("###").unlockedBy("has_yak_hair", EnvironmentalRecipeProvider.has((ItemLike)((ItemLike)EnvironmentalItems.YAK_HAIR.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)EnvironmentalItems.YAK_PANTS.get())).define(Character.valueOf('#'), (ItemLike)Items.LEATHER).define(Character.valueOf('B'), (ItemLike)EnvironmentalBlocks.YAK_HAIR_BLOCK.get()).pattern("BBB").pattern("# #").pattern("# #").unlockedBy("has_yak_hair", EnvironmentalRecipeProvider.has((ItemLike)((ItemLike)EnvironmentalItems.YAK_HAIR.get()))).save(consumer);
        EnvironmentalRecipeProvider.generateRecipes((RecipeOutput)consumer, (BlockFamily)EnvironmentalBlockFamilies.WILLOW_PLANKS_FAMILY);
        EnvironmentalRecipeProvider.planksFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)EnvironmentalBlocks.WILLOW_PLANKS.get()), EnvironmentalItemTags.WILLOW_LOGS, (int)4);
        EnvironmentalRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)EnvironmentalBlocks.WILLOW_WOOD.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.WILLOW_LOG.get()));
        EnvironmentalRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)EnvironmentalBlocks.STRIPPED_WILLOW_WOOD.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.STRIPPED_WILLOW_LOG.get()));
        EnvironmentalRecipeProvider.hangingSign((RecipeOutput)consumer, (ItemLike)((ItemLike)((DeferredBlock)EnvironmentalBlocks.WILLOW_HANGING_SIGNS.getFirst()).get()), (ItemLike)((ItemLike)EnvironmentalBlocks.STRIPPED_WILLOW_LOG.get()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnvironmentalBlocks.HANGING_WILLOW_LEAVES.get()), (int)3).define(Character.valueOf('#'), (ItemLike)EnvironmentalBlocks.WILLOW_LEAVES.get()).pattern("#").pattern("#").pattern("#").unlockedBy(EnvironmentalRecipeProvider.getHasName((ItemLike)((ItemLike)EnvironmentalBlocks.WILLOW_LEAVES.get())), EnvironmentalRecipeProvider.has((ItemLike)((ItemLike)EnvironmentalBlocks.WILLOW_LEAVES.get()))).save(consumer);
        WoodworksRecipeProvider.conditionalLeafPileRecipes((RecipeOutput)consumer, (ItemLike)((ItemLike)EnvironmentalBlocks.WILLOW_LEAVES.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.WILLOW_LEAF_PILE.get()), (String)"environmental");
        BoatloadRecipeProvider.boatRecipes((RecipeOutput)consumer, (BoatloadBoatType)EnvironmentalBoatTypes.WILLOW);
        WoodworksRecipeProvider.baseRecipes((RecipeOutput)consumer, (ItemLike)((ItemLike)EnvironmentalBlocks.WILLOW_PLANKS.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.WILLOW_SLAB.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.WILLOW_BOARDS.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.WILLOW_BOOKSHELF.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.CHISELED_WILLOW_BOOKSHELF.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.WILLOW_LADDER.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.WILLOW_BEEHIVE.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.WILLOW_CHEST.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.TRAPPED_WILLOW_CHEST.get()), (String)"environmental");
        WoodworksRecipeProvider.sawmillRecipes((RecipeOutput)consumer, (BlockFamily)EnvironmentalBlockFamilies.WILLOW_PLANKS_FAMILY, EnvironmentalItemTags.WILLOW_LOGS, (ItemLike)((ItemLike)EnvironmentalBlocks.WILLOW_BOARDS.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.WILLOW_LADDER.get()), (String)"environmental");
        EnvironmentalRecipeProvider.generateRecipes((RecipeOutput)consumer, (BlockFamily)EnvironmentalBlockFamilies.PINE_PLANKS_FAMILY);
        EnvironmentalRecipeProvider.planksFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)EnvironmentalBlocks.PINE_PLANKS.get()), EnvironmentalItemTags.PINE_LOGS, (int)4);
        EnvironmentalRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)EnvironmentalBlocks.PINE_WOOD.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.PINE_LOG.get()));
        EnvironmentalRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)EnvironmentalBlocks.STRIPPED_PINE_WOOD.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.STRIPPED_PINE_LOG.get()));
        EnvironmentalRecipeProvider.hangingSign((RecipeOutput)consumer, (ItemLike)((ItemLike)((DeferredBlock)EnvironmentalBlocks.PINE_HANGING_SIGNS.getFirst()).get()), (ItemLike)((ItemLike)EnvironmentalBlocks.STRIPPED_PINE_LOG.get()));
        WoodworksRecipeProvider.conditionalLeafPileRecipes((RecipeOutput)consumer, (ItemLike)((ItemLike)EnvironmentalBlocks.PINE_LEAVES.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.PINE_LEAF_PILE.get()), (String)"environmental");
        BoatloadRecipeProvider.boatRecipes((RecipeOutput)consumer, (BoatloadBoatType)EnvironmentalBoatTypes.PINE);
        WoodworksRecipeProvider.baseRecipes((RecipeOutput)consumer, (ItemLike)((ItemLike)EnvironmentalBlocks.PINE_PLANKS.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.PINE_SLAB.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.PINE_BOARDS.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.PINE_BOOKSHELF.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.CHISELED_PINE_BOOKSHELF.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.PINE_LADDER.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.PINE_BEEHIVE.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.PINE_CHEST.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.TRAPPED_PINE_CHEST.get()), (String)"environmental");
        WoodworksRecipeProvider.sawmillRecipes((RecipeOutput)consumer, (BlockFamily)EnvironmentalBlockFamilies.PINE_PLANKS_FAMILY, EnvironmentalItemTags.PINE_LOGS, (ItemLike)((ItemLike)EnvironmentalBlocks.PINE_BOARDS.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.PINE_LADDER.get()), (String)"environmental");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnvironmentalBlocks.WAXED_PINECONE.get())).requires((ItemLike)EnvironmentalBlocks.PINECONE.get()).requires((ItemLike)Items.HONEYCOMB).unlockedBy(EnvironmentalRecipeProvider.getHasName((ItemLike)((ItemLike)EnvironmentalBlocks.PINECONE.get())), EnvironmentalRecipeProvider.has((ItemLike)((ItemLike)EnvironmentalBlocks.PINECONE.get()))).save(consumer, EnvironmentalRecipeProvider.getConversionRecipeName((ItemLike)((ItemLike)EnvironmentalBlocks.WAXED_PINECONE.get()), (ItemLike)Items.HONEYCOMB));
        EnvironmentalRecipeProvider.generateRecipes((RecipeOutput)consumer, (BlockFamily)EnvironmentalBlockFamilies.PLUM_PLANKS_FAMILY);
        EnvironmentalRecipeProvider.planksFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)EnvironmentalBlocks.PLUM_PLANKS.get()), EnvironmentalItemTags.PLUM_LOGS, (int)4);
        EnvironmentalRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)EnvironmentalBlocks.PLUM_WOOD.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.PLUM_LOG.get()));
        EnvironmentalRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)EnvironmentalBlocks.STRIPPED_PLUM_WOOD.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.STRIPPED_PLUM_LOG.get()));
        EnvironmentalRecipeProvider.hangingSign((RecipeOutput)consumer, (ItemLike)((ItemLike)((DeferredBlock)EnvironmentalBlocks.PLUM_HANGING_SIGNS.getFirst()).get()), (ItemLike)((ItemLike)EnvironmentalBlocks.STRIPPED_PLUM_LOG.get()));
        this.leafPileRecipes(consumer, (ItemLike)EnvironmentalBlocks.PLUM_LEAVES.get(), (ItemLike)EnvironmentalBlocks.PLUM_LEAF_PILE.get());
        this.leafPileRecipes(consumer, (ItemLike)EnvironmentalBlocks.CHEERFUL_PLUM_LEAVES.get(), (ItemLike)EnvironmentalBlocks.CHEERFUL_PLUM_LEAF_PILE.get());
        this.leafPileRecipes(consumer, (ItemLike)EnvironmentalBlocks.MOODY_PLUM_LEAVES.get(), (ItemLike)EnvironmentalBlocks.MOODY_PLUM_LEAF_PILE.get());
        BoatloadRecipeProvider.boatRecipes((RecipeOutput)consumer, (BoatloadBoatType)EnvironmentalBoatTypes.PLUM);
        WoodworksRecipeProvider.baseRecipes((RecipeOutput)consumer, (ItemLike)((ItemLike)EnvironmentalBlocks.PLUM_PLANKS.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.PLUM_SLAB.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.PLUM_BOARDS.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.PLUM_BOOKSHELF.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.CHISELED_PLUM_BOOKSHELF.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.PLUM_LADDER.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.PLUM_BEEHIVE.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.PLUM_CHEST.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.TRAPPED_PLUM_CHEST.get()), (String)"environmental");
        WoodworksRecipeProvider.sawmillRecipes((RecipeOutput)consumer, (BlockFamily)EnvironmentalBlockFamilies.PLUM_PLANKS_FAMILY, EnvironmentalItemTags.PLUM_LOGS, (ItemLike)((ItemLike)EnvironmentalBlocks.PLUM_BOARDS.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.PLUM_LADDER.get()), (String)"environmental");
        EnvironmentalRecipeProvider.generateRecipes((RecipeOutput)consumer, (BlockFamily)EnvironmentalBlockFamilies.WISTERIA_PLANKS_FAMILY);
        EnvironmentalRecipeProvider.planksFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)EnvironmentalBlocks.WISTERIA_PLANKS.get()), EnvironmentalItemTags.WISTERIA_LOGS, (int)4);
        EnvironmentalRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)EnvironmentalBlocks.WISTERIA_WOOD.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.WISTERIA_LOG.get()));
        EnvironmentalRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)EnvironmentalBlocks.STRIPPED_WISTERIA_WOOD.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.STRIPPED_WISTERIA_LOG.get()));
        EnvironmentalRecipeProvider.hangingSign((RecipeOutput)consumer, (ItemLike)((ItemLike)((DeferredBlock)EnvironmentalBlocks.WISTERIA_HANGING_SIGNS.getFirst()).get()), (ItemLike)((ItemLike)EnvironmentalBlocks.STRIPPED_WISTERIA_LOG.get()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnvironmentalBlocks.PINK_HANGING_WISTERIA_LEAVES.get()), (int)3).define(Character.valueOf('#'), (ItemLike)EnvironmentalBlocks.PINK_WISTERIA_LEAVES.get()).pattern("#").pattern("#").pattern("#").unlockedBy(EnvironmentalRecipeProvider.getHasName((ItemLike)((ItemLike)EnvironmentalBlocks.PINK_WISTERIA_LEAVES.get())), EnvironmentalRecipeProvider.has((ItemLike)((ItemLike)EnvironmentalBlocks.PINK_WISTERIA_LEAVES.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnvironmentalBlocks.BLUE_HANGING_WISTERIA_LEAVES.get()), (int)3).define(Character.valueOf('#'), (ItemLike)EnvironmentalBlocks.BLUE_WISTERIA_LEAVES.get()).pattern("#").pattern("#").pattern("#").unlockedBy(EnvironmentalRecipeProvider.getHasName((ItemLike)((ItemLike)EnvironmentalBlocks.BLUE_WISTERIA_LEAVES.get())), EnvironmentalRecipeProvider.has((ItemLike)((ItemLike)EnvironmentalBlocks.BLUE_WISTERIA_LEAVES.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnvironmentalBlocks.PURPLE_HANGING_WISTERIA_LEAVES.get()), (int)3).define(Character.valueOf('#'), (ItemLike)EnvironmentalBlocks.PURPLE_WISTERIA_LEAVES.get()).pattern("#").pattern("#").pattern("#").unlockedBy(EnvironmentalRecipeProvider.getHasName((ItemLike)((ItemLike)EnvironmentalBlocks.PURPLE_WISTERIA_LEAVES.get())), EnvironmentalRecipeProvider.has((ItemLike)((ItemLike)EnvironmentalBlocks.PURPLE_WISTERIA_LEAVES.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)EnvironmentalBlocks.WHITE_HANGING_WISTERIA_LEAVES.get()), (int)3).define(Character.valueOf('#'), (ItemLike)EnvironmentalBlocks.WHITE_WISTERIA_LEAVES.get()).pattern("#").pattern("#").pattern("#").unlockedBy(EnvironmentalRecipeProvider.getHasName((ItemLike)((ItemLike)EnvironmentalBlocks.WHITE_WISTERIA_LEAVES.get())), EnvironmentalRecipeProvider.has((ItemLike)((ItemLike)EnvironmentalBlocks.WHITE_WISTERIA_LEAVES.get()))).save(consumer);
        WoodworksRecipeProvider.conditionalLeafPileRecipes((RecipeOutput)consumer, (ItemLike)((ItemLike)EnvironmentalBlocks.PINK_WISTERIA_LEAVES.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.PINK_WISTERIA_LEAF_PILE.get()), (String)"environmental");
        WoodworksRecipeProvider.conditionalLeafPileRecipes((RecipeOutput)consumer, (ItemLike)((ItemLike)EnvironmentalBlocks.BLUE_WISTERIA_LEAVES.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.BLUE_WISTERIA_LEAF_PILE.get()), (String)"environmental");
        WoodworksRecipeProvider.conditionalLeafPileRecipes((RecipeOutput)consumer, (ItemLike)((ItemLike)EnvironmentalBlocks.PURPLE_WISTERIA_LEAVES.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.PURPLE_WISTERIA_LEAF_PILE.get()), (String)"environmental");
        WoodworksRecipeProvider.conditionalLeafPileRecipes((RecipeOutput)consumer, (ItemLike)((ItemLike)EnvironmentalBlocks.WHITE_WISTERIA_LEAVES.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.WHITE_WISTERIA_LEAF_PILE.get()), (String)"environmental");
        WoodworksRecipeProvider.conditionalLeafPileRecipes((RecipeOutput)consumer, (ItemLike)((ItemLike)EnvironmentalBlocks.WISTERIA_LEAVES.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.WISTERIA_LEAF_PILE.get()), (String)"environmental");
        BoatloadRecipeProvider.boatRecipes((RecipeOutput)consumer, (BoatloadBoatType)EnvironmentalBoatTypes.WISTERIA);
        WoodworksRecipeProvider.baseRecipes((RecipeOutput)consumer, (ItemLike)((ItemLike)EnvironmentalBlocks.WISTERIA_PLANKS.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.WISTERIA_SLAB.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.WISTERIA_BOARDS.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.WISTERIA_BOOKSHELF.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.CHISELED_WISTERIA_BOOKSHELF.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.WISTERIA_LADDER.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.WISTERIA_BEEHIVE.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.WISTERIA_CHEST.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.TRAPPED_WISTERIA_CHEST.get()), (String)"environmental");
        WoodworksRecipeProvider.sawmillRecipes((RecipeOutput)consumer, (BlockFamily)EnvironmentalBlockFamilies.WISTERIA_PLANKS_FAMILY, EnvironmentalItemTags.WISTERIA_LOGS, (ItemLike)((ItemLike)EnvironmentalBlocks.WISTERIA_BOARDS.get()), (ItemLike)((ItemLike)EnvironmentalBlocks.WISTERIA_LADDER.get()), (String)"environmental");
    }
}

