/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.data.server.modifiers;

import com.teamabnormals.environmental.core.Environmental;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalBiomeTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalBiomeModifierTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.datapack.EnvironmentalPlacedFeatures;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class EnvironmentalBiomeModifiers {
    public static void bootstrap(BootstrapContext<BiomeModifier> context) {
        EnvironmentalBiomeModifiers.addSpawn(context, "slabfish", EnvironmentalBiomeTags.HAS_SLABFISH, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.SLABFISH.get(), 12, 4, 4));
        EnvironmentalBiomeModifiers.addSpawn(context, "duck", EnvironmentalBiomeTags.HAS_DUCK, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.DUCK.get(), 10, 4, 4));
        EnvironmentalBiomeModifiers.addSpawn(context, "duck_rare", (ResourceKey<Biome>)Biomes.RIVER, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.DUCK.get(), 1, 1, 2));
        EnvironmentalBiomeModifiers.addSpawnIgnore(context, "deer", EnvironmentalBiomeTags.HAS_DEER, EnvironmentalBiomeTags.WITHOUT_DEER, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.DEER.get(), 10, 4, 4));
        EnvironmentalBiomeModifiers.addSpawn(context, "reindeer", EnvironmentalBiomeTags.HAS_REINDEER, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.REINDEER.get(), 10, 4, 4));
        EnvironmentalBiomeModifiers.addSpawn(context, "tapir", EnvironmentalBiomeTags.HAS_TAPIR, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.TAPIR.get(), 10, 2, 2));
        EnvironmentalBiomeModifiers.addSpawn(context, "tapir_rare", (ResourceKey<Biome>)Biomes.SPARSE_JUNGLE, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.TAPIR.get(), 4, 2, 2));
        EnvironmentalBiomeModifiers.addSpawn(context, "yak", EnvironmentalBiomeTags.HAS_YAK, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.YAK.get(), 8, 4, 4));
        EnvironmentalBiomeModifiers.addSpawn(context, "deer_meadow", (ResourceKey<Biome>)Biomes.MEADOW, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.DEER.get(), 1, 2, 4));
        EnvironmentalBiomeModifiers.addSpawn(context, "pig", (ResourceKey<Biome>)Biomes.MANGROVE_SWAMP, new MobSpawnSettings.SpawnerData(EntityType.PIG, 10, 4, 4));
        EnvironmentalBiomeModifiers.addFeature(context, "zebra_dazzle", EnvironmentalBiomeTags.HAS_ZEBRA, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.ZEBRA_DAZZLE);
        EnvironmentalBiomeModifiers.removeSpawnInvertedIgnore(context, "pig", EnvironmentalBiomeTags.HAS_PIG, (ResourceKey<Biome>)Biomes.GROVE, EntityType.PIG);
        EnvironmentalBiomeModifiers.removeSpawnInverted(context, "sheep", EnvironmentalBiomeTags.HAS_SHEEP, EntityType.SHEEP);
        EnvironmentalBiomeModifiers.removeSpawnInverted(context, "cow", EnvironmentalBiomeTags.HAS_COW, EntityType.COW);
        EnvironmentalBiomeModifiers.removeSpawnInvertedIgnore(context, "chicken", EnvironmentalBiomeTags.HAS_CHICKEN, (ResourceKey<Biome>)Biomes.GROVE, EntityType.CHICKEN);
        EnvironmentalBiomeModifiers.addFeature(context, "cattails", EnvironmentalBiomeTags.HAS_CATTAILS, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.CATTAILS);
        EnvironmentalBiomeModifiers.addFeature(context, "cup_lichen", EnvironmentalBiomeTags.HAS_CUP_LICHEN, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.PATCH_CUP_LICHEN_TAIGA);
        EnvironmentalBiomeModifiers.addFeatureIgnore(context, "dwarf_spruce_sparse", EnvironmentalBiomeTags.HAS_SPARSE_DWARF_SPRUCE, EnvironmentalBiomeTags.IS_PINE_BARRENS, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.DWARF_SPRUCE_SPARSE);
        EnvironmentalBiomeModifiers.addFeature(context, "bluebell", EnvironmentalBiomeTags.HAS_BLUEBELL, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.FLOWER_BLUEBELL, EnvironmentalPlacedFeatures.FLOWER_BLUEBELL_LARGE);
        EnvironmentalBiomeModifiers.addFeature(context, "violet", EnvironmentalBiomeTags.HAS_VIOLET, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.FLOWER_VIOLET);
        EnvironmentalBiomeModifiers.addFeature(context, "tasselflower", EnvironmentalBiomeTags.HAS_TASSELFLOWER, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.PATCH_TASSELFLOWER);
        EnvironmentalBiomeModifiers.addFeature(context, "bird_of_paradise", EnvironmentalBiomeTags.HAS_BIRD_OF_PARADISE, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.FLOWER_BIRD_OF_PARADISE);
        EnvironmentalBiomeModifiers.addFeature(context, "hibiscus_bush", EnvironmentalBiomeTags.HAS_HIBISCUS, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.HIBISCUS_BUSH);
        EnvironmentalBiomeModifiers.addFeature(context, "cartwheel", (TagKey<Biome>)BiomeTags.IS_OVERWORLD, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.FLOWER_CARTWHEEL);
        EnvironmentalBiomeModifiers.addFeature(context, "mycelium_sprouts", (ResourceKey<Biome>)Biomes.MUSHROOM_FIELDS, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.PATCH_MYCELIUM_SPROUTS);
        EnvironmentalBiomeModifiers.addFeature(context, "mud_disk", EnvironmentalBiomeTags.HAS_MUD_DISK, GenerationStep.Decoration.UNDERGROUND_ORES, EnvironmentalPlacedFeatures.ORE_MUD);
        EnvironmentalBiomeModifiers.removeFeature(context, "swamp_oak", (ResourceKey<Biome>)Biomes.SWAMP, GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.TREES_SWAMP);
        EnvironmentalBiomeModifiers.addFeature(context, "swamp_vegetation", (ResourceKey<Biome>)Biomes.SWAMP, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.TREES_SWAMP, EnvironmentalPlacedFeatures.PATCH_DUCKWEED_SWAMP);
        EnvironmentalBiomeModifiers.addFeature(context, "flower_forest_vegetation", (ResourceKey<Biome>)Biomes.FLOWER_FOREST, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.PATCH_DELPHINIUMS, EnvironmentalPlacedFeatures.TREES_WISTERIA);
        EnvironmentalBiomeModifiers.addFeature(context, "savanna_vegetation", (TagKey<Biome>)BiomeTags.IS_SAVANNA, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.PATCH_GIANT_TALL_GRASS_SAVANNA);
        EnvironmentalBiomeModifiers.addFeature(context, "plains_vegetation", (TagKey<Biome>)Tags.Biomes.IS_PLAINS, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.PATCH_GIANT_TALL_GRASS_PLAINS);
        EnvironmentalBiomeModifiers.addFeature(context, "jungle_vegetation", (TagKey<Biome>)BiomeTags.IS_JUNGLE, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.PATCH_GIANT_TALL_GRASS_JUNGLE, EnvironmentalPlacedFeatures.PATCH_LARGE_FERN_JUNGLE);
    }

    @SafeVarargs
    private static void removeFeature(BootstrapContext<BiomeModifier> context, String name, ResourceKey<Biome> biome, GenerationStep.Decoration step, ResourceKey<PlacedFeature> ... features) {
        EnvironmentalBiomeModifiers.register(context, "remove_feature/" + name, () -> new BiomeModifiers.RemoveFeaturesBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.BIOME).getOrThrow(biome)}), EnvironmentalBiomeModifiers.featureSet(context, features), Set.of(step)));
    }

    private static void removeSpawnInverted(BootstrapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, EntityType<?> ... types) {
        EnvironmentalBiomeModifiers.register(context, "remove_spawn/" + name, () -> new EnvironmentalBiomeModifierTypes.InvertedRemoveSpawnsBiomeModifier((HolderSet<Biome>)context.lookup(Registries.BIOME).getOrThrow(biomes), (HolderSet<EntityType<?>>)HolderSet.direct(Stream.of(types).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ENTITY_TYPE).wrapAsHolder(arg_0)).collect(Collectors.toList()))));
    }

    private static void removeSpawnInvertedIgnore(BootstrapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, ResourceKey<Biome> ignoredBiome, EntityType<?> ... types) {
        EnvironmentalBiomeModifiers.register(context, "remove_spawn/" + name, () -> new EnvironmentalBiomeModifierTypes.InvertedRemoveSpawnsIgnoreBiomeModifier((HolderSet<Biome>)context.lookup(Registries.BIOME).getOrThrow(biomes), (HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.BIOME).getOrThrow(ignoredBiome)}), (HolderSet<EntityType<?>>)HolderSet.direct(Stream.of(types).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ENTITY_TYPE).wrapAsHolder(arg_0)).collect(Collectors.toList()))));
    }

    @SafeVarargs
    private static void addFeatureIgnore(BootstrapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, TagKey<Biome> ignoredBiomes, GenerationStep.Decoration step, ResourceKey<PlacedFeature> ... features) {
        EnvironmentalBiomeModifiers.register(context, "add_feature/" + name, () -> new EnvironmentalBiomeModifierTypes.AddFeaturesIgnoreBiomeModifier((HolderSet<Biome>)context.lookup(Registries.BIOME).getOrThrow(biomes), (HolderSet<Biome>)context.lookup(Registries.BIOME).getOrThrow(ignoredBiomes), EnvironmentalBiomeModifiers.featureSet(context, features), step));
    }

    @SafeVarargs
    private static void addFeature(BootstrapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, GenerationStep.Decoration step, ResourceKey<PlacedFeature> ... features) {
        EnvironmentalBiomeModifiers.register(context, "add_feature/" + name, () -> new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)context.lookup(Registries.BIOME).getOrThrow(biomes), EnvironmentalBiomeModifiers.featureSet(context, features), step));
    }

    @SafeVarargs
    private static void addFeature(BootstrapContext<BiomeModifier> context, String name, ResourceKey<Biome> biome, GenerationStep.Decoration step, ResourceKey<PlacedFeature> ... features) {
        EnvironmentalBiomeModifiers.register(context, "add_feature/" + name, () -> new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.BIOME).getOrThrow(biome)}), EnvironmentalBiomeModifiers.featureSet(context, features), step));
    }

    private static void addSpawn(BootstrapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, MobSpawnSettings.SpawnerData ... spawns) {
        EnvironmentalBiomeModifiers.register(context, "add_spawn/" + name, () -> new BiomeModifiers.AddSpawnsBiomeModifier((HolderSet)context.lookup(Registries.BIOME).getOrThrow(biomes), List.of(spawns)));
    }

    private static void addSpawn(BootstrapContext<BiomeModifier> context, String name, ResourceKey<Biome> biome, MobSpawnSettings.SpawnerData ... spawns) {
        EnvironmentalBiomeModifiers.register(context, "add_spawn/" + name, () -> new BiomeModifiers.AddSpawnsBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.BIOME).getOrThrow(biome)}), List.of(spawns)));
    }

    private static void addSpawnIgnore(BootstrapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, TagKey<Biome> ignoredBiome, MobSpawnSettings.SpawnerData ... spawns) {
        EnvironmentalBiomeModifiers.register(context, "add_spawn/" + name, () -> new EnvironmentalBiomeModifierTypes.AddSpawnsIgnoreBiomeModifier((HolderSet<Biome>)context.lookup(Registries.BIOME).getOrThrow(biomes), (HolderSet<Biome>)context.lookup(Registries.BIOME).getOrThrow(ignoredBiome), List.of(spawns)));
    }

    private static void register(BootstrapContext<BiomeModifier> context, String name, Supplier<? extends BiomeModifier> modifier) {
        context.register(ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)Environmental.location(name)), (Object)modifier.get());
    }

    @SafeVarargs
    private static HolderSet<PlacedFeature> featureSet(BootstrapContext<?> context, ResourceKey<PlacedFeature> ... features) {
        return HolderSet.direct(Stream.of(features).map(key -> context.lookup(Registries.PLACED_FEATURE).getOrThrow(key)).collect(Collectors.toList()));
    }
}

