/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.data.server.modifiers;

import com.teamabnormals.blueprint.common.world.modification.chunk.ChunkGeneratorModifierProvider;
import com.teamabnormals.blueprint.common.world.modification.chunk.modifiers.SurfaceRuleModifier;
import com.teamabnormals.blueprint.core.util.modification.ObjectModifier;
import com.teamabnormals.environmental.core.registry.datapack.EnvironmentalBiomes;
import com.teamabnormals.environmental.core.registry.datapack.EnvironmentalNoiseParameters;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.neoforged.neoforge.common.conditions.ICondition;

public class EnvironmentalChunkGeneratorModifierProvider
extends ChunkGeneratorModifierProvider {
    public EnvironmentalChunkGeneratorModifierProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super("environmental", output, provider);
    }

    protected void registerEntries(HolderLookup.Provider provider) {
        SurfaceRules.ConditionSource isPineBarrens = SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{EnvironmentalBiomes.PINE_BARRENS, EnvironmentalBiomes.SNOWY_PINE_BARRENS, EnvironmentalBiomes.OLD_GROWTH_PINE_BARRENS, EnvironmentalBiomes.SNOWY_OLD_GROWTH_PINE_BARRENS});
        SurfaceRules.ConditionSource isPineSlopes = SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{EnvironmentalBiomes.PINE_SLOPES});
        SurfaceRules.RuleSource stone = SurfaceRules.state((BlockState)Blocks.STONE.defaultBlockState());
        SurfaceRules.RuleSource nearSurfaceStone = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR), (SurfaceRules.RuleSource)stone);
        this.entry("environmental_surface_rule").selects(new String[]{"minecraft:overworld"}).addModifier((ObjectModifier)new SurfaceRuleModifier(SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.abovePreliminarySurface(), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isPineBarrens, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.steep(), (SurfaceRules.RuleSource)stone), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)EnvironmentalChunkGeneratorModifierProvider.surfaceNoiseAbove((ResourceKey<NormalNoise.NoiseParameters>)Noises.SURFACE, 3.0), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)EnvironmentalChunkGeneratorModifierProvider.noiseRange(EnvironmentalNoiseParameters.PINE_BARRENS_STONE, -1.25, 1.25)), (SurfaceRules.RuleSource)stone)), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)EnvironmentalChunkGeneratorModifierProvider.surfaceNoiseAbove((ResourceKey<NormalNoise.NoiseParameters>)Noises.SURFACE, 2.0), (SurfaceRules.RuleSource)nearSurfaceStone), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)-1, (boolean)true, (CaveSurface)CaveSurface.FLOOR)), (SurfaceRules.RuleSource)nearSurfaceStone)}))), false), new ICondition[0]).addModifier((ObjectModifier)new SurfaceRuleModifier(SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.abovePreliminarySurface(), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isPineSlopes, (SurfaceRules.RuleSource)stone)), false), new ICondition[0]);
    }

    private static SurfaceRules.ConditionSource noiseRange(ResourceKey<NormalNoise.NoiseParameters> noise, double low, double high) {
        return SurfaceRules.noiseCondition(noise, (double)(low / 8.25), (double)(high / 8.25));
    }

    private static SurfaceRules.ConditionSource surfaceNoiseAbove(ResourceKey<NormalNoise.NoiseParameters> noise, double low) {
        return SurfaceRules.noiseCondition(noise, (double)(low / 8.25), (double)Double.MAX_VALUE);
    }
}

