/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.data.server.modifiers;

import com.teamabnormals.blueprint.common.remolder.data.RemolderProvider;
import com.teamabnormals.blueprint.common.remolder.util.LootRemolders;
import com.teamabnormals.environmental.core.data.server.EnvironmentalLootTableProvider;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import com.teamabnormals.environmental.core.registry.datapack.EnvironmentalBiomes;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.IntStream;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemEnchantmentsPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicates;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PinkPetalsBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class EnvironmentalDataRemolderProvider
extends RemolderProvider {
    public EnvironmentalDataRemolderProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super("environmental", PackOutput.Target.DATA_PACK, output, provider);
    }

    protected void registerEntries(HolderLookup.Provider provider) {
        HolderLookup.RegistryLookup biomes = provider.lookupOrThrow(Registries.BIOME);
        LootItemCondition.Builder inBlossomWoods = LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBiomes((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(EnvironmentalBiomes.BLOSSOM_WOODS), biomes.getOrThrow(EnvironmentalBiomes.BLOSSOM_VALLEYS)})));
        this.entry("loot_table/gameplay/fishing/fish").path(new String[]{"loot_table/gameplay/fishing/fish"}).remolder(LootRemolders.addEntry((int)0, (LootPoolEntryContainer)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)EnvironmentalItems.KOI.get())).setWeight(70).when(inBlossomWoods)).build()));
        this.entry("loot_table/blocks/pink_petals").path(new String[]{"loot_table/blocks/pink_petals"}).remolder(LootRemolders.replacePools((LootPool[])new LootPool[]{EnvironmentalDataRemolderProvider.createPetalsDrops(Blocks.PINK_PETALS).build()}));
        this.entry("loot_table/blocks/cherry_leaves").path(new String[]{"loot_table/blocks/cherry_leaves"}).remolder(LootRemolders.addPool((LootPool)LootPool.lootPool().name("environmental:cherries").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.doesNotHaveShearsOrSilkTouch(provider)).add(LootItem.lootTableItem((ItemLike)((ItemLike)EnvironmentalItems.CHERRIES.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay()).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)provider.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.05f, 0.055555556f, 0.0625f, 0.08333334f, 0.25f}))).build()));
    }

    protected static LootPool.Builder createPetalsDrops(Block block) {
        return LootPool.lootPool().name("environmental:pink_petals").when(EnvironmentalLootTableProvider.EnvironmentalBlockLoot.HAS_SHEARS).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block).apply(IntStream.rangeClosed(1, 4).boxed().toList(), amount -> SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)amount.intValue())).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)PinkPetalsBlock.AMOUNT, amount.intValue()))))).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay());
    }

    private LootItemCondition.Builder hasShearsOrSilkTouch(HolderLookup.Provider provider) {
        return EnvironmentalLootTableProvider.EnvironmentalBlockLoot.HAS_SHEARS.or(this.hasSilkTouch(provider));
    }

    private LootItemCondition.Builder doesNotHaveShearsOrSilkTouch(HolderLookup.Provider provider) {
        return this.hasShearsOrSilkTouch(provider).invert();
    }

    protected LootItemCondition.Builder hasSilkTouch(HolderLookup.Provider provider) {
        HolderLookup.RegistryLookup registrylookup = provider.lookupOrThrow(Registries.ENCHANTMENT);
        return MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().withSubPredicate(ItemSubPredicates.ENCHANTMENTS, (ItemSubPredicate)ItemEnchantmentsPredicate.enchantments(List.of(new EnchantmentPredicate((Holder)registrylookup.getOrThrow(Enchantments.SILK_TOUCH), MinMaxBounds.Ints.atLeast((int)1))))));
    }
}

