/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.other;

import com.teamabnormals.blueprint.core.util.DataUtil;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;

public class EnvironmentalCompat {
    public static DispenseItemBehavior EMPTY_FISH_BUCKET_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

        public ItemStack execute(BlockSource source, ItemStack stack) {
            DispensibleContainerItem item = (DispensibleContainerItem)stack.getItem();
            BlockPos pos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
            ServerLevel level = source.level();
            if (item.emptyContents(null, (Level)level, pos, null, stack)) {
                item.checkExtraContent(null, (Level)level, stack, pos);
                return this.consumeWithRemainder(source, stack, new ItemStack((ItemLike)Items.BUCKET));
            }
            return this.defaultDispenseItemBehavior.dispense(source, stack);
        }
    };

    public static void register() {
        EnvironmentalCompat.registerFlammables();
        EnvironmentalCompat.registerDispenserBehaviors();
        EnvironmentalCompat.changeLocalization();
    }

    private static void changeLocalization() {
        DataUtil.changeBlockLocalization((Block)Blocks.DIRT_PATH, (String)"environmental", (String)"grass_path");
    }

    public static void registerFlammables() {
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.YAK_HAIR_BLOCK.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.YAK_HAIR_RUG.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.CATTAIL_FLUFF_BLOCK.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.GRASS_THATCH.get()), (int)60, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.GRASS_THATCH_STAIRS.get()), (int)60, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.GRASS_THATCH_SLAB.get()), (int)60, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.CATTAIL_THATCH.get()), (int)60, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.CATTAIL_THATCH_STAIRS.get()), (int)60, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.CATTAIL_THATCH_SLAB.get()), (int)60, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.DUCKWEED_THATCH.get()), (int)60, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.DUCKWEED_THATCH_STAIRS.get()), (int)60, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.DUCKWEED_THATCH_SLAB.get()), (int)60, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.HIBISCUS_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.HIBISCUS_LEAF_PILE.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WILLOW_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.HANGING_WILLOW_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WILLOW_LOG.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WILLOW_WOOD.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.STRIPPED_WILLOW_LOG.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.STRIPPED_WILLOW_WOOD.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WILLOW_PLANKS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WILLOW_SLAB.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WILLOW_STAIRS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WILLOW_FENCE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WILLOW_FENCE_GATE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WILLOW_BOOKSHELF.get()), (int)30, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WILLOW_BEEHIVE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WILLOW_LEAF_PILE.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WILLOW_BOARDS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PINE_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PINE_LOG.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PINE_WOOD.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.STRIPPED_PINE_LOG.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.STRIPPED_PINE_WOOD.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PINE_PLANKS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PINE_SLAB.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PINE_STAIRS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PINE_FENCE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PINE_FENCE_GATE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PINE_BOOKSHELF.get()), (int)30, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PINE_BEEHIVE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PINE_LEAF_PILE.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PINE_BOARDS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PINECONE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PLUM_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PLUM_LOG.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PLUM_WOOD.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.STRIPPED_PLUM_LOG.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.STRIPPED_PLUM_WOOD.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PLUM_PLANKS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PLUM_SLAB.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PLUM_STAIRS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PLUM_FENCE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PLUM_FENCE_GATE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PLUM_BOOKSHELF.get()), (int)30, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.CHERRY_CRATE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PLUM_CRATE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PLUM_BEEHIVE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PLUM_LEAF_PILE.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PLUM_BOARDS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.CHEERFUL_PLUM_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.CHEERFUL_PLUM_LEAF_PILE.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.MOODY_PLUM_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.MOODY_PLUM_LEAF_PILE.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.GIANT_TALL_GRASS.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.MYCELIUM_SPROUTS.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.CUP_LICHEN.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.DWARF_SPRUCE.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.DWARF_SPRUCE_PLANT.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.DWARF_SPRUCE_TORCH.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.DWARF_SPRUCE_PLANT_TORCH.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.DWARF_SPRUCE_SOUL_TORCH.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.DWARF_SPRUCE_PLANT_SOUL_TORCH.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.DWARF_SPRUCE_REDSTONE_TORCH.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.DWARF_SPRUCE_PLANT_REDSTONE_TORCH.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.DWARF_SPRUCE_ENDER_TORCH.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.DWARF_SPRUCE_PLANT_ENDER_TORCH.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.DWARF_SPRUCE_CUPRIC_TORCH.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.DWARF_SPRUCE_PLANT_CUPRIC_TORCH.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WISTERIA_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WISTERIA_LEAF_PILE.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.BLUE_WISTERIA_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WHITE_WISTERIA_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PINK_WISTERIA_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PURPLE_WISTERIA_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.BLUE_HANGING_WISTERIA_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WHITE_HANGING_WISTERIA_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PINK_HANGING_WISTERIA_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PURPLE_HANGING_WISTERIA_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WISTERIA_LOG.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WISTERIA_WOOD.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.STRIPPED_WISTERIA_LOG.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.STRIPPED_WISTERIA_WOOD.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WISTERIA_PLANKS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WISTERIA_SLAB.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WISTERIA_STAIRS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WISTERIA_FENCE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WISTERIA_FENCE_GATE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.BLUE_DELPHINIUM.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WHITE_DELPHINIUM.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PINK_DELPHINIUM.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PURPLE_DELPHINIUM.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WISTERIA_BOOKSHELF.get()), (int)30, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WISTERIA_BEEHIVE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WISTERIA_BOARDS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.BLUE_WISTERIA_LEAF_PILE.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.WHITE_WISTERIA_LEAF_PILE.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PINK_WISTERIA_LEAF_PILE.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)EnvironmentalBlocks.PURPLE_WISTERIA_LEAF_PILE.get()), (int)30, (int)60);
    }

    public static void registerDispenserBehaviors() {
        DispenserBlock.registerProjectileBehavior((ItemLike)((ItemLike)EnvironmentalItems.DUCK_EGG.get()));
        DispenserBlock.registerProjectileBehavior((ItemLike)((ItemLike)EnvironmentalItems.MUD_BALL.get()));
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)EnvironmentalItems.KOI_BUCKET.get()), (DispenseItemBehavior)EMPTY_FISH_BUCKET_BEHAVIOR);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)EnvironmentalItems.SLABFISH_BUCKET.get()), (DispenseItemBehavior)EMPTY_FISH_BUCKET_BEHAVIOR);
    }
}

