/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.other;

import com.teamabnormals.environmental.core.registry.datapack.EnvironmentalPlacedFeatures;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.biome.OverworldBiomes;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.levelgen.GenerationStep;

public class EnvironmentalGeneration {
    public static void marsh(BiomeGenerationSettings.Builder generation) {
        BiomeDefaultFeatures.addFossilDecoration((BiomeGenerationSettings.Builder)generation);
        OverworldBiomes.globalOverworldGeneration((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addSavannaGrass((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addSwampClayDisk((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addSwampExtraVegetation((BiomeGenerationSettings.Builder)generation);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.TREES_MARSH);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.FLOWER_BLUE_ORCHID);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.FLOWER_CORNFLOWER);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.FLOWER_DIANTHUS);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.PATCH_WATERLILY_MARSH);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.PATCH_GRASS_MARSH);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.CATTAILS_DENSE);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.PATCH_DUCKWEED);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.SEAGRASS_MARSH);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.HUGE_BROWN_MUSHROOM_MARSH);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.PATCH_GIANT_TALL_GRASS_MARSH);
    }

    public static void blossomWoods(BiomeGenerationSettings.Builder generation, boolean valley) {
        OverworldBiomes.globalOverworldGeneration((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addSavannaGrass((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)generation);
        generation.addFeature(GenerationStep.Decoration.UNDERGROUND_DECORATION, EnvironmentalPlacedFeatures.BLOSSOM_WOODS_ROCK);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)generation);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.FOREST_FLOWERS);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.PATCH_SUGAR_CANE_BLOSSOM);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.PATCH_TULIPS);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.PATCH_GRASS_BLOSSOM_WOODS);
        if (!valley) {
            generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.PINE_TREES_BLOSSOM_WOODS);
            generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.PLUM_TREES_BLOSSOM_WOODS);
            generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.FALLEN_PLUM_LEAVES_BLOSSOM_WOODS);
            generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.BAMBOO_BLOSSOM_WOODS);
            generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.BAMBOO_LIGHT_BLOSSOM_WOODS);
            generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.FLOWER_RED_LOTUS);
        } else {
            generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.PINE_TREES_BLOSSOM_VALLEYS);
            generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.PLUM_TREES_BLOSSOM_VALLEYS);
            generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.FALLEN_PLUM_LEAVES_BLOSSOM_VALLEYS);
            generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.BAMBOO_BLOSSOM_VALLEYS);
            generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.BAMBOO_LIGHT_BLOSSOM_VALLEYS);
            generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.FLOWER_WHITE_LOTUS);
        }
    }

    public static void pineBarrens(BiomeGenerationSettings.Builder generation, boolean snowy, boolean oldGrowth) {
        OverworldBiomes.globalOverworldGeneration((BiomeGenerationSettings.Builder)generation);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.PATCH_CUP_LICHEN);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.PATCH_CUP_LICHEN_SMALL);
        if (oldGrowth) {
            BiomeDefaultFeatures.addFerns((BiomeGenerationSettings.Builder)generation);
        } else {
            generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.PATCH_LARGE_FERN_PINE_BARRENS);
        }
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)generation);
        generation.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, EnvironmentalPlacedFeatures.SMALL_COARSE_DIRT_ON_STONE);
        if (oldGrowth) {
            generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.FALLEN_TALL_PINE_TREE);
        } else {
            generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.GRAINY_COARSE_DIRT);
            generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.FALLEN_PINE_TREE);
        }
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, oldGrowth ? EnvironmentalPlacedFeatures.TREES_OLD_GROWTH_PINE_BARRENS : EnvironmentalPlacedFeatures.TREES_PINE_BARRENS);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.TREES_PINE_BARRENS_ON_STONE);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.BROWN_MUSHROOM_TAIGA);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.RED_MUSHROOM_TAIGA);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.DWARF_SPRUCE);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.DWARF_SPRUCE_THICKET);
        if (oldGrowth) {
            generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, snowy ? EnvironmentalPlacedFeatures.PATCH_GRASS_PINE_BARRENS : EnvironmentalPlacedFeatures.PATCH_GRASS_OLD_GROWTH_PINE_BARRENS);
        } else {
            generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, snowy ? EnvironmentalPlacedFeatures.PATCH_GRASS_SNOWY_PINE_BARRENS : EnvironmentalPlacedFeatures.PATCH_GRASS_PINE_BARRENS);
        }
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generation);
    }

    public static void pineSlopes(BiomeGenerationSettings.Builder generation) {
        OverworldBiomes.globalOverworldGeneration((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)generation);
        generation.addFeature(GenerationStep.Decoration.UNDERGROUND_DECORATION, EnvironmentalPlacedFeatures.PINE_SLOPES_BOULDER);
        generation.addFeature(GenerationStep.Decoration.UNDERGROUND_DECORATION, EnvironmentalPlacedFeatures.PINE_SLOPES_ROCK);
        BiomeDefaultFeatures.addDefaultFlowers((BiomeGenerationSettings.Builder)generation);
        generation.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, EnvironmentalPlacedFeatures.COARSE_DIRT_ON_STONE);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.TREES_PINE_SLOPES);
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalPlacedFeatures.PATCH_GRASS_PINE_SLOPES);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addExtraEmeralds((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.addInfestedStone((BiomeGenerationSettings.Builder)generation);
    }
}

