/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.other;

import com.teamabnormals.blueprint.core.api.BlockSetTypeRegistryHelper;
import com.teamabnormals.blueprint.core.api.WoodTypeRegistryHelper;
import com.teamabnormals.blueprint.core.util.PropertyUtil;
import com.teamabnormals.environmental.common.block.WallHibiscusBlock;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;

public class EnvironmentalProperties {
    public static final BlockSetType WILLOW_BLOCK_SET = EnvironmentalProperties.blockSetType("willow");
    public static final BlockSetType PINE_BLOCK_SET = EnvironmentalProperties.blockSetType("pine");
    public static final BlockSetType PLUM_BLOCK_SET = EnvironmentalProperties.blockSetType("plum");
    public static final BlockSetType WISTERIA_BLOCK_SET = EnvironmentalProperties.blockSetType("wisteria");
    public static final WoodType WILLOW_WOOD_TYPE = EnvironmentalProperties.woodSetType(WILLOW_BLOCK_SET);
    public static final WoodType PINE_WOOD_TYPE = EnvironmentalProperties.woodSetType(PINE_BLOCK_SET);
    public static final WoodType PLUM_WOOD_TYPE = EnvironmentalProperties.woodSetType(PLUM_BLOCK_SET);
    public static final WoodType WISTERIA_WOOD_TYPE = EnvironmentalProperties.woodSetType(WISTERIA_BLOCK_SET);
    public static final PropertyUtil.WoodSetProperties WILLOW = PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.TERRACOTTA_GREEN, (MapColor)MapColor.WOOD).build();
    public static final PropertyUtil.WoodSetProperties PINE = PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.TERRACOTTA_LIGHT_GRAY, (MapColor)MapColor.WOOD).build();
    public static final PropertyUtil.WoodSetProperties PLUM = PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.TERRACOTTA_RED, (MapColor)MapColor.WOOD).leavesColor(MapColor.COLOR_PINK).build();
    public static final PropertyUtil.WoodSetProperties WISTERIA = PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.TERRACOTTA_WHITE, (MapColor)MapColor.TERRACOTTA_CYAN).leavesColor(MapColor.SNOW).build();
    public static final PropertyUtil.WoodSetProperties PINK_WISTERIA = PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.TERRACOTTA_WHITE, (MapColor)MapColor.TERRACOTTA_CYAN).leavesColor(MapColor.COLOR_PINK).build();
    public static final PropertyUtil.WoodSetProperties BLUE_WISTERIA = PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.TERRACOTTA_WHITE, (MapColor)MapColor.TERRACOTTA_CYAN).leavesColor(MapColor.COLOR_LIGHT_BLUE).build();
    public static final PropertyUtil.WoodSetProperties PURPLE_WISTERIA = PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.TERRACOTTA_WHITE, (MapColor)MapColor.TERRACOTTA_CYAN).leavesColor(MapColor.COLOR_PURPLE).build();
    public static final PropertyUtil.WoodSetProperties HIBISCUS = PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.COLOR_GREEN).build();
    public static final BlockBehaviour.Properties CATTAIL = BlockBehaviour.Properties.of().instabreak().noCollission().randomTicks().sound(SoundType.WET_GRASS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY);
    public static final BlockBehaviour.Properties CATTAIL_STALK = BlockBehaviour.Properties.of().instabreak().noCollission().sound(SoundType.WET_GRASS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY);
    public static final BlockBehaviour.Properties DUCKWEED = BlockBehaviour.Properties.of().instabreak().noCollission().sound(SoundType.CROP).pushReaction(PushReaction.DESTROY);
    public static final BlockBehaviour.Properties MYCELIUM_SPROUTS = BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).replaceable().noCollission().instabreak().sound(SoundType.NETHER_SPROUTS).offsetType(BlockBehaviour.OffsetType.XZ).ignitedByLava().pushReaction(PushReaction.DESTROY);
    public static final BlockBehaviour.Properties CUP_LICHEN = BlockBehaviour.Properties.of().mapColor(MapColor.GLOW_LICHEN).replaceable().noCollission().instabreak().sound(SoundType.NETHER_SPROUTS).ignitedByLava().pushReaction(PushReaction.DESTROY);
    public static final BlockBehaviour.Properties CACTUS_BOBBLE = BlockBehaviour.Properties.of().replaceable().noCollission().instabreak().sound(SoundType.WOOL).ignitedByLava().pushReaction(PushReaction.DESTROY);
    public static final BlockBehaviour.Properties DWARF_SPRUCE = BlockBehaviour.Properties.of().noCollission().instabreak().sound(SoundType.GRASS).pushReaction(PushReaction.DESTROY);
    public static final BlockBehaviour.Properties TALL_FLOWERS = PropertyUtil.flower().ignitedByLava();
    public static final BlockBehaviour.Properties WALL_HIBISCUS = EnvironmentalProperties.wallHibiscus();
    public static final BlockBehaviour.Properties PINECONE = BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).strength(1.5f).sound(SoundType.WOOD).ignitedByLava();
    public static final BlockBehaviour.Properties DIRT_PATH = BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).strength(0.65f).sound(SoundType.GRAVEL).isViewBlocking(PropertyUtil::always).isSuffocating(PropertyUtil::always);
    public static final BlockBehaviour.Properties MYCELIUM_PATH = BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).strength(0.65f).sound(SoundType.GRASS).isViewBlocking(PropertyUtil::always).isSuffocating(PropertyUtil::always);
    public static final BlockBehaviour.Properties PODZOL_PATH = BlockBehaviour.Properties.of().mapColor(MapColor.PODZOL).strength(0.65f).sound(SoundType.GRASS).isViewBlocking(PropertyUtil::always).isSuffocating(PropertyUtil::always);
    public static final BlockBehaviour.Properties DIRT_BRICKS = BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).strength(0.5f).sound(SoundType.GRAVEL);
    public static final BlockBehaviour.Properties MUD_BRICKS = BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_LIGHT_GRAY).requiresCorrectToolForDrops().strength(1.5f, 3.0f).sound(SoundType.MUD_BRICKS);
    public static final BlockBehaviour.Properties YAK_HAIR_BLOCK = BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).strength(0.8f).sound(SoundType.WOOL).noOcclusion().ignitedByLava();
    public static final BlockBehaviour.Properties YAK_HAIR_RUG = BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).strength(0.1f).sound(SoundType.WOOL).noOcclusion().ignitedByLava();
    public static final BlockBehaviour.Properties GRASS_THATCH = PropertyUtil.thatch((MapColor)MapColor.COLOR_YELLOW, (SoundType)SoundType.GRASS);
    public static final BlockBehaviour.Properties DUCKWEED_THATCH = PropertyUtil.thatch((MapColor)MapColor.COLOR_GREEN, (SoundType)SoundType.GRASS);
    public static final BlockBehaviour.Properties CATTAIL_THATCH = PropertyUtil.thatch((MapColor)MapColor.TERRACOTTA_GREEN, (SoundType)SoundType.GRASS);
    public static final BlockBehaviour.Properties BURIED_TRUFFLE = BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).strength(0.6f).sound(SoundType.GRAVEL);

    public static BlockSetType blockSetType(String name) {
        return BlockSetTypeRegistryHelper.register((BlockSetType)new BlockSetType("environmental:" + name));
    }

    public static WoodType woodSetType(BlockSetType type) {
        return WoodTypeRegistryHelper.registerWoodType((WoodType)new WoodType(type.name(), type));
    }

    public static BlockBehaviour.Properties wallHibiscus() {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.of().noCollission().instabreak().sound(SoundType.GRASS).ignitedByLava().pushReaction(PushReaction.DESTROY);
        properties.offsetFunction = (state, level, pos) -> {
            WallHibiscusBlock block = (WallHibiscusBlock)state.getBlock();
            long i = Mth.getSeed((int)pos.getX(), (int)pos.getY(), (int)pos.getZ());
            float f = block.getMaxHorizontalOffset();
            double d0 = Mth.clamp((double)(((double)((float)(i & 0xFL) / 15.0f) - 0.5) * 0.4), (double)(-f), (double)f);
            double d1 = Mth.clamp((double)(((double)((float)(i >> 8 & 0xFL) / 15.0f) - 0.5) * 0.4), (double)(-f), (double)f);
            Direction facing = (Direction)state.getValue((Property)WallHibiscusBlock.FACING);
            Direction.Axis axis = facing.getAxis();
            Vec3 vec3 = state.getValue(WallHibiscusBlock.FACE) != AttachFace.WALL ? new Vec3(d0, 0.0, d1) : (axis == Direction.Axis.X ? new Vec3(0.0, d0, d1) : new Vec3(d0, d1, 0.0));
            return vec3;
        };
        return properties;
    }
}

