/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.registry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.world.BiomeGenerationSettingsBuilder;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.MobSpawnSettingsBuilder;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class EnvironmentalBiomeModifierTypes {
    public static final DeferredRegister<MapCodec<? extends BiomeModifier>> BIOME_MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"environmental");
    public static final DeferredHolder<MapCodec<? extends BiomeModifier>, MapCodec<InvertedRemoveSpawnsBiomeModifier>> REMOVE_SPAWNS_INVERTED = BIOME_MODIFIER_SERIALIZERS.register("remove_spawns_inverted", () -> RecordCodecBuilder.mapCodec(builder -> builder.group((App)Biome.LIST_CODEC.fieldOf("inverted_biomes").forGetter(InvertedRemoveSpawnsBiomeModifier::biomes), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.ENTITY_TYPE).fieldOf("entity_types").forGetter(InvertedRemoveSpawnsBiomeModifier::entityTypes)).apply((Applicative)builder, InvertedRemoveSpawnsBiomeModifier::new)));
    public static final DeferredHolder<MapCodec<? extends BiomeModifier>, MapCodec<InvertedRemoveSpawnsIgnoreBiomeModifier>> REMOVE_SPAWNS_INVERTED_WITH_IGNORE = BIOME_MODIFIER_SERIALIZERS.register("remove_spawns_inverted_ignore", () -> RecordCodecBuilder.mapCodec(builder -> builder.group((App)Biome.LIST_CODEC.fieldOf("inverted_biomes").forGetter(InvertedRemoveSpawnsIgnoreBiomeModifier::biomes), (App)Biome.LIST_CODEC.fieldOf("ignored_biomes").forGetter(InvertedRemoveSpawnsIgnoreBiomeModifier::ignoredBiomes), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.ENTITY_TYPE).fieldOf("entity_types").forGetter(InvertedRemoveSpawnsIgnoreBiomeModifier::entityTypes)).apply((Applicative)builder, InvertedRemoveSpawnsIgnoreBiomeModifier::new)));
    public static final DeferredHolder<MapCodec<? extends BiomeModifier>, MapCodec<AddSpawnsIgnoreBiomeModifier>> ADD_SPAWNS_WITH_IGNORE = BIOME_MODIFIER_SERIALIZERS.register("add_spawns_ignore", () -> RecordCodecBuilder.mapCodec(builder -> builder.group((App)Biome.LIST_CODEC.fieldOf("biomes").forGetter(AddSpawnsIgnoreBiomeModifier::biomes), (App)Biome.LIST_CODEC.fieldOf("ignored_biomes").forGetter(AddSpawnsIgnoreBiomeModifier::ignoredBiomes), (App)Codec.either((Codec)MobSpawnSettings.SpawnerData.CODEC.listOf(), (Codec)MobSpawnSettings.SpawnerData.CODEC).xmap(either -> (List)either.map(Function.identity(), List::of), list -> list.size() == 1 ? Either.right((Object)((MobSpawnSettings.SpawnerData)list.get(0))) : Either.left((Object)list)).fieldOf("spawners").forGetter(AddSpawnsIgnoreBiomeModifier::spawners)).apply((Applicative)builder, AddSpawnsIgnoreBiomeModifier::new)));
    public static final DeferredHolder<MapCodec<? extends BiomeModifier>, MapCodec<AddFeaturesIgnoreBiomeModifier>> ADD_FEATURES_WITH_IGNORE = BIOME_MODIFIER_SERIALIZERS.register("add_features_ignore", () -> RecordCodecBuilder.mapCodec(builder -> builder.group((App)Biome.LIST_CODEC.fieldOf("biomes").forGetter(AddFeaturesIgnoreBiomeModifier::biomes), (App)Biome.LIST_CODEC.fieldOf("ignored_biomes").forGetter(AddFeaturesIgnoreBiomeModifier::ignoredBiomes), (App)PlacedFeature.LIST_CODEC.fieldOf("features").forGetter(AddFeaturesIgnoreBiomeModifier::features), (App)GenerationStep.Decoration.CODEC.fieldOf("step").forGetter(AddFeaturesIgnoreBiomeModifier::step)).apply((Applicative)builder, AddFeaturesIgnoreBiomeModifier::new)));

    public record AddFeaturesIgnoreBiomeModifier(HolderSet<Biome> biomes, HolderSet<Biome> ignoredBiomes, HolderSet<PlacedFeature> features, GenerationStep.Decoration step) implements BiomeModifier
    {
        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.ADD && this.biomes.contains(biome) && !this.ignoredBiomes.contains(biome)) {
                BiomeGenerationSettingsBuilder generationSettings = builder.getGenerationSettings();
                this.features.forEach(holder -> generationSettings.addFeature(this.step, holder));
            }
        }

        public MapCodec<? extends BiomeModifier> codec() {
            return (MapCodec)ADD_FEATURES_WITH_IGNORE.get();
        }
    }

    public record AddSpawnsIgnoreBiomeModifier(HolderSet<Biome> biomes, HolderSet<Biome> ignoredBiomes, List<MobSpawnSettings.SpawnerData> spawners) implements BiomeModifier
    {
        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.ADD && this.biomes.contains(biome) && !this.ignoredBiomes.contains(biome)) {
                MobSpawnSettingsBuilder spawns = builder.getMobSpawnSettings();
                for (MobSpawnSettings.SpawnerData spawner : this.spawners) {
                    EntityType type = spawner.type;
                    spawns.addSpawn(type.getCategory(), spawner);
                }
            }
        }

        public MapCodec<? extends BiomeModifier> codec() {
            return (MapCodec)ADD_SPAWNS_WITH_IGNORE.get();
        }
    }

    public record InvertedRemoveSpawnsIgnoreBiomeModifier(HolderSet<Biome> biomes, HolderSet<Biome> ignoredBiomes, HolderSet<EntityType<?>> entityTypes) implements BiomeModifier
    {
        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.REMOVE && (!this.biomes.contains(biome) || this.ignoredBiomes.contains(biome))) {
                MobSpawnSettingsBuilder spawnBuilder = builder.getMobSpawnSettings();
                for (MobCategory category : MobCategory.values()) {
                    List spawns = spawnBuilder.getSpawner(category);
                    spawns.removeIf(spawnerData -> this.entityTypes.contains(BuiltInRegistries.ENTITY_TYPE.wrapAsHolder((Object)spawnerData.type)));
                }
            }
        }

        public MapCodec<? extends BiomeModifier> codec() {
            return (MapCodec)REMOVE_SPAWNS_INVERTED_WITH_IGNORE.get();
        }
    }

    public record InvertedRemoveSpawnsBiomeModifier(HolderSet<Biome> biomes, HolderSet<EntityType<?>> entityTypes) implements BiomeModifier
    {
        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.REMOVE && !this.biomes.contains(biome)) {
                MobSpawnSettingsBuilder spawnBuilder = builder.getMobSpawnSettings();
                for (MobCategory category : MobCategory.values()) {
                    List spawns = spawnBuilder.getSpawner(category);
                    spawns.removeIf(spawnerData -> this.entityTypes.contains(BuiltInRegistries.ENTITY_TYPE.wrapAsHolder((Object)spawnerData.type)));
                }
            }
        }

        public MapCodec<? extends BiomeModifier> codec() {
            return (MapCodec)REMOVE_SPAWNS_INVERTED.get();
        }
    }
}

