/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.registry;

import com.teamabnormals.blueprint.core.util.registry.EntitySubRegistryHelper;
import com.teamabnormals.environmental.common.entity.animal.Duck;
import com.teamabnormals.environmental.common.entity.animal.PineconeGolem;
import com.teamabnormals.environmental.common.entity.animal.Tapir;
import com.teamabnormals.environmental.common.entity.animal.deer.AbstractDeer;
import com.teamabnormals.environmental.common.entity.animal.deer.Deer;
import com.teamabnormals.environmental.common.entity.animal.deer.Reindeer;
import com.teamabnormals.environmental.common.entity.animal.koi.Koi;
import com.teamabnormals.environmental.common.entity.animal.slabfish.Slabfish;
import com.teamabnormals.environmental.common.entity.animal.yak.Yak;
import com.teamabnormals.environmental.common.entity.animal.zebroid.Zebra;
import com.teamabnormals.environmental.common.entity.animal.zebroid.Zonkey;
import com.teamabnormals.environmental.common.entity.animal.zebroid.Zorse;
import com.teamabnormals.environmental.common.entity.projectile.ThrownDuckEgg;
import com.teamabnormals.environmental.common.entity.projectile.ThrownMudBall;
import com.teamabnormals.environmental.core.Environmental;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

@EventBusSubscriber(modid="environmental", bus=EventBusSubscriber.Bus.MOD)
public class EnvironmentalEntityTypes {
    public static final EntitySubRegistryHelper ENTITY_TYPES = (EntitySubRegistryHelper)Environmental.REGISTRY_HELPER.getEntitySubHelper();
    public static final DeferredHolder<EntityType<?>, EntityType<Slabfish>> SLABFISH = ENTITY_TYPES.createEntity("slabfish", Slabfish::new, MobCategory.CREATURE, builder -> builder.sized(0.45f, 0.9f).eyeHeight(0.72f).clientTrackingRange(10));
    public static final DeferredHolder<EntityType<?>, EntityType<Duck>> DUCK = ENTITY_TYPES.createEntity("duck", Duck::new, MobCategory.CREATURE, builder -> builder.sized(0.5f, 0.75f).eyeHeight(0.644f).passengerAttachments(new Vec3[]{new Vec3(0.0, (double)0.45f, (double)-0.2f)}).clientTrackingRange(10));
    public static final DeferredHolder<EntityType<?>, EntityType<Deer>> DEER = ENTITY_TYPES.createEntity("deer", Deer::new, MobCategory.CREATURE, builder -> builder.sized(0.8f, 1.6f).eyeHeight(1.52f).passengerAttachments(new float[]{1.1f}).clientTrackingRange(10));
    public static final DeferredHolder<EntityType<?>, EntityType<Reindeer>> REINDEER = ENTITY_TYPES.createEntity("reindeer", Reindeer::new, MobCategory.CREATURE, builder -> builder.sized(0.8f, 1.6f).eyeHeight(1.52f).passengerAttachments(new float[]{1.1f}).clientTrackingRange(10));
    public static final DeferredHolder<EntityType<?>, EntityType<Yak>> YAK = ENTITY_TYPES.createEntity("yak", Yak::new, MobCategory.CREATURE, builder -> builder.sized(1.2f, 1.4f).eyeHeight(1.3f).passengerAttachments(new float[]{1.36875f}).clientTrackingRange(10));
    public static final DeferredHolder<EntityType<?>, EntityType<Koi>> KOI = ENTITY_TYPES.createEntity("koi", Koi::new, MobCategory.WATER_AMBIENT, builder -> builder.sized(0.75f, 0.4f).eyeHeight(0.26f).clientTrackingRange(4));
    public static final DeferredHolder<EntityType<?>, EntityType<Tapir>> TAPIR = ENTITY_TYPES.createEntity("tapir", Tapir::new, MobCategory.CREATURE, builder -> builder.sized(0.9f, 0.98f).passengerAttachments(new float[]{0.96875f}).clientTrackingRange(10));
    public static final DeferredHolder<EntityType<?>, EntityType<Zebra>> ZEBRA = ENTITY_TYPES.createEntity("zebra", Zebra::new, MobCategory.CREATURE, builder -> builder.sized(1.3964844f, 1.5f).eyeHeight(1.425f).passengerAttachments(new float[]{1.1125f}).clientTrackingRange(10));
    public static final DeferredHolder<EntityType<?>, EntityType<Zorse>> ZORSE = ENTITY_TYPES.createEntity("zorse", Zorse::new, MobCategory.CREATURE, builder -> builder.sized(1.3964844f, 1.6f).eyeHeight(1.52f).passengerAttachments(new float[]{1.3125f}).clientTrackingRange(10));
    public static final DeferredHolder<EntityType<?>, EntityType<Zonkey>> ZONKEY = ENTITY_TYPES.createEntity("zonkey", Zonkey::new, MobCategory.CREATURE, builder -> builder.sized(1.3964844f, 1.5f).eyeHeight(1.425f).passengerAttachments(new float[]{1.1125f}).clientTrackingRange(10));
    public static final DeferredHolder<EntityType<?>, EntityType<PineconeGolem>> PINECONE_GOLEM = ENTITY_TYPES.createEntity("pinecone_golem", PineconeGolem::new, MobCategory.MISC, builder -> builder.sized(0.65f, 0.65f).eyeHeight(0.325f).clientTrackingRange(10));
    public static final DeferredHolder<EntityType<?>, EntityType<ThrownDuckEgg>> DUCK_EGG = ENTITY_TYPES.createEntity("duck_egg", ThrownDuckEgg::new, MobCategory.MISC, builder -> builder.sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(10));
    public static final DeferredHolder<EntityType<?>, EntityType<ThrownMudBall>> MUD_BALL = ENTITY_TYPES.createEntity("mud_ball", ThrownMudBall::new, MobCategory.MISC, builder -> builder.sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(10));

    @SubscribeEvent
    public static void registerSpawnPlacements(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)SLABFISH.get(), SpawnPlacementTypes.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Duck::checkDuckSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register((EntityType)YAK.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register((EntityType)DUCK.get(), SpawnPlacementTypes.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Duck::checkDuckSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register((EntityType)DEER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, AbstractDeer::checkDeerSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register((EntityType)REINDEER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, AbstractDeer::checkDeerSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register((EntityType)KOI.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Koi::canKoiSpawn, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register((EntityType)TAPIR.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register((EntityType)ZEBRA.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)SLABFISH.get(), Slabfish.registerAttributes().build());
        event.put((EntityType)DEER.get(), Deer.registerAttributes().build());
        event.put((EntityType)REINDEER.get(), Reindeer.registerAttributes().build());
        event.put((EntityType)DUCK.get(), Duck.registerAttributes().build());
        event.put((EntityType)YAK.get(), Yak.registerAttributes().build());
        event.put((EntityType)KOI.get(), Koi.registerAttributes().build());
        event.put((EntityType)TAPIR.get(), Tapir.createAttributes().build());
        event.put((EntityType)ZEBRA.get(), Zebra.createAttributes().build());
        event.put((EntityType)ZORSE.get(), Zorse.createAttributes().build());
        event.put((EntityType)ZONKEY.get(), Zonkey.createAttributes().build());
        event.put((EntityType)PINECONE_GOLEM.get(), PineconeGolem.createAttributes().build());
    }
}

