/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.registry.datapack;

import com.teamabnormals.environmental.core.Environmental;
import com.teamabnormals.environmental.core.other.EnvironmentalGeneration;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class EnvironmentalBiomes {
    public static final ResourceKey<Biome> MARSH = EnvironmentalBiomes.create("marsh");
    public static final ResourceKey<Biome> BLOSSOM_WOODS = EnvironmentalBiomes.create("blossom_woods");
    public static final ResourceKey<Biome> BLOSSOM_VALLEYS = EnvironmentalBiomes.create("blossom_valleys");
    public static final ResourceKey<Biome> PINE_BARRENS = EnvironmentalBiomes.create("pine_barrens");
    public static final ResourceKey<Biome> SNOWY_PINE_BARRENS = EnvironmentalBiomes.create("snowy_pine_barrens");
    public static final ResourceKey<Biome> OLD_GROWTH_PINE_BARRENS = EnvironmentalBiomes.create("old_growth_pine_barrens");
    public static final ResourceKey<Biome> SNOWY_OLD_GROWTH_PINE_BARRENS = EnvironmentalBiomes.create("snowy_old_growth_pine_barrens");
    public static final ResourceKey<Biome> PINE_SLOPES = EnvironmentalBiomes.create("pine_slopes");
    public static final List<ResourceKey<Biome>> NATURAL_BIOMES = List.of(MARSH, BLOSSOM_WOODS, BLOSSOM_VALLEYS, PINE_BARRENS, SNOWY_PINE_BARRENS, OLD_GROWTH_PINE_BARRENS, SNOWY_OLD_GROWTH_PINE_BARRENS, PINE_SLOPES);

    public static void bootstrap(BootstrapContext<Biome> context) {
        HolderGetter features = context.lookup(Registries.PLACED_FEATURE);
        HolderGetter carvers = context.lookup(Registries.CONFIGURED_CARVER);
        context.register(MARSH, (Object)EnvironmentalBiomes.marsh((HolderGetter<PlacedFeature>)features, carvers));
        context.register(BLOSSOM_WOODS, (Object)EnvironmentalBiomes.blossomBiome((HolderGetter<PlacedFeature>)features, carvers, false));
        context.register(BLOSSOM_VALLEYS, (Object)EnvironmentalBiomes.blossomBiome((HolderGetter<PlacedFeature>)features, carvers, true));
        context.register(PINE_BARRENS, (Object)EnvironmentalBiomes.pineBarrens((HolderGetter<PlacedFeature>)features, carvers, false, false));
        context.register(SNOWY_PINE_BARRENS, (Object)EnvironmentalBiomes.pineBarrens((HolderGetter<PlacedFeature>)features, carvers, true, false));
        context.register(OLD_GROWTH_PINE_BARRENS, (Object)EnvironmentalBiomes.pineBarrens((HolderGetter<PlacedFeature>)features, carvers, false, true));
        context.register(SNOWY_OLD_GROWTH_PINE_BARRENS, (Object)EnvironmentalBiomes.pineBarrens((HolderGetter<PlacedFeature>)features, carvers, true, true));
        context.register(PINE_SLOPES, (Object)EnvironmentalBiomes.pineSlopes((HolderGetter<PlacedFeature>)features, carvers));
    }

    public static ResourceKey<Biome> create(String name) {
        return ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)Environmental.location(name));
    }

    private static Biome marsh(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder(features, carvers);
        EnvironmentalGeneration.marsh(generation);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawns);
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawns);
        spawns.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.FROG, 10, 2, 5));
        spawns.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 4, 2, 3));
        return EnvironmentalBiomes.biome(true, 0.8f, 0.9f, 6263617, 6975545, 6134398, 2302743, 12638463, spawns, generation, Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_SWAMP));
    }

    private static Biome blossomBiome(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers, boolean valley) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder(features, carvers);
        EnvironmentalGeneration.blossomWoods(generation, valley);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawns);
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawns);
        spawns.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.PANDA, 1, 1, 2));
        spawns.addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.KOI.get(), 8, 1, 1));
        return EnvironmentalBiomes.biome(true, 0.45f, 0.8f, 5938278, 5216182, 335411, spawns, generation, null);
    }

    private static Biome pineBarrens(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers, boolean snowy, boolean oldGrowth) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder(features, carvers);
        EnvironmentalGeneration.pineBarrens(generation, snowy, oldGrowth);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawns);
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawns);
        spawns.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.WOLF, 8, 4, 4));
        spawns.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 4, 2, 3));
        return EnvironmentalBiomes.biome(true, snowy ? -0.2f : 0.4f, snowy ? 0.4f : 0.6f, snowy ? 8828286 : (oldGrowth ? 9221482 : 9484136), snowy ? 6789454 : 7578444, 4159204, 329011, 12638463, spawns, generation, null);
    }

    private static Biome pineSlopes(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder(features, carvers);
        EnvironmentalGeneration.pineSlopes(generation);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawns);
        spawns.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.WOLF, 8, 4, 4));
        spawns.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 4, 2, 3));
        return EnvironmentalBiomes.biome(true, 0.4f, 0.3f, 4159204, 329011, spawns, generation, null);
    }

    private static Biome biome(boolean precipitation, float temperature, float downfall, int waterColor, int waterFogColor, MobSpawnSettings.Builder spawns, BiomeGenerationSettings.Builder generation, @Nullable Music music) {
        return new Biome.BiomeBuilder().hasPrecipitation(precipitation).temperature(temperature).downfall(downfall).specialEffects(new BiomeSpecialEffects.Builder().waterColor(waterColor).waterFogColor(waterFogColor).fogColor(12638463).skyColor(EnvironmentalBiomes.calculateSkyColor(temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(music).build()).mobSpawnSettings(spawns.build()).generationSettings(generation.build()).build();
    }

    private static Biome biome(boolean precipitation, float temperature, float downfall, int foliageColor, int waterColor, int waterFogColor, MobSpawnSettings.Builder spawns, BiomeGenerationSettings.Builder generation, @Nullable Music music) {
        return new Biome.BiomeBuilder().hasPrecipitation(precipitation).temperature(temperature).downfall(downfall).specialEffects(new BiomeSpecialEffects.Builder().foliageColorOverride(foliageColor).waterColor(waterColor).waterFogColor(waterFogColor).fogColor(12638463).skyColor(EnvironmentalBiomes.calculateSkyColor(temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(music).build()).mobSpawnSettings(spawns.build()).generationSettings(generation.build()).build();
    }

    private static Biome biome(boolean precipitation, float temperature, float downfall, int grassColor, int foliageColor, int waterColor, int waterFogColor, int fogColor, MobSpawnSettings.Builder spawns, BiomeGenerationSettings.Builder generation, @Nullable Music music) {
        return new Biome.BiomeBuilder().hasPrecipitation(precipitation).temperature(temperature).downfall(downfall).specialEffects(new BiomeSpecialEffects.Builder().grassColorOverride(grassColor).foliageColorOverride(foliageColor).waterColor(waterColor).waterFogColor(waterFogColor).fogColor(fogColor).skyColor(EnvironmentalBiomes.calculateSkyColor(temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(music).build()).mobSpawnSettings(spawns.build()).generationSettings(generation.build()).build();
    }

    private static int calculateSkyColor(float temperature) {
        float clampedTemp = Mth.clamp((float)(temperature / 3.0f), (float)-1.0f, (float)1.0f);
        return Mth.hsvToRgb((float)(0.62222224f - clampedTemp * 0.05f), (float)(0.5f + clampedTemp * 0.1f), (float)1.0f);
    }
}

