/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.registry.datapack;

import com.google.common.collect.ImmutableList;
import com.teamabnormals.environmental.common.block.CartwheelBlock;
import com.teamabnormals.environmental.common.levelgen.feature.configurations.BestNoisesSelectorFeatureConfiguration;
import com.teamabnormals.environmental.common.levelgen.feature.configurations.CupLichenPatchConfiguration;
import com.teamabnormals.environmental.common.levelgen.feature.configurations.DwarfSpruceConfiguration;
import com.teamabnormals.environmental.common.levelgen.feature.configurations.FallenLeavesConfiguration;
import com.teamabnormals.environmental.common.levelgen.treedecorators.FallenLeavesDecorator;
import com.teamabnormals.environmental.common.levelgen.treedecorators.HangingWillowDecorator;
import com.teamabnormals.environmental.common.levelgen.treedecorators.HangingWisteriaDecorator;
import com.teamabnormals.environmental.common.levelgen.treedecorators.PinePodzolDecorator;
import com.teamabnormals.environmental.common.levelgen.treedecorators.PineconeDecorator;
import com.teamabnormals.environmental.core.Environmental;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalBlockTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.teamabnormals.environmental.core.registry.EnvironmentalFeatures;
import com.teamabnormals.environmental.core.registry.datapack.EnvironmentalNoiseParameters;
import com.teamabnormals.environmental.core.registry.datapack.EnvironmentalPlacedFeatures;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.TreePlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.BiasedToBottomInt;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockColumnConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ProbabilityFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleRandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.BeehiveDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.LeaveVineDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class EnvironmentalConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILLOW = EnvironmentalConfiguredFeatures.createKey("willow");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WEEPING_WILLOW = EnvironmentalConfiguredFeatures.createKey("weeping_willow");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TREES_WILLOW = EnvironmentalConfiguredFeatures.createKey("trees_willow");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TREES_SWAMP = EnvironmentalConfiguredFeatures.createKey("trees_swamp");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SWAMP_OAK = EnvironmentalConfiguredFeatures.createKey("swamp_oak");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MARSH_OAK = EnvironmentalConfiguredFeatures.createKey("marsh_oak");
    public static final ResourceKey<ConfiguredFeature<?, ?>> STONE_ROCK = EnvironmentalConfiguredFeatures.createKey("stone_rock");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PINE_SLOPES_BOULDER = EnvironmentalConfiguredFeatures.createKey("pine_slopes_boulder");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PLUM = EnvironmentalConfiguredFeatures.createKey("plum");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PLUM_BEES_0002 = EnvironmentalConfiguredFeatures.createKey("plum_bees_0002");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PLUM_BEES_005 = EnvironmentalConfiguredFeatures.createKey("plum_bees_005");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PLUM_BEES_005_FALLEN_LEAVES = EnvironmentalConfiguredFeatures.createKey("plum_bees_005_fallen_leaves");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CHEERFUL_PLUM = EnvironmentalConfiguredFeatures.createKey("cheerful_plum");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CHEERFUL_PLUM_BEES_0002 = EnvironmentalConfiguredFeatures.createKey("cheerful_plum_bees_0002");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CHEERFUL_PLUM_BEES_005 = EnvironmentalConfiguredFeatures.createKey("cheerful_plum_bees_005");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CHEERFUL_PLUM_BEES_005_FALLEN_LEAVES = EnvironmentalConfiguredFeatures.createKey("cheerful_plum_bees_005_fallen_leaves");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MOODY_PLUM = EnvironmentalConfiguredFeatures.createKey("moody_plum");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MOODY_PLUM_BEES_0002 = EnvironmentalConfiguredFeatures.createKey("moody_plum_bees_0002");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MOODY_PLUM_BEES_005 = EnvironmentalConfiguredFeatures.createKey("moody_plum_bees_005");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MOODY_PLUM_BEES_005_FALLEN_LEAVES = EnvironmentalConfiguredFeatures.createKey("moody_plum_bees_005_fallen_leaves");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TREES_BLOSSOM_WOODS = EnvironmentalConfiguredFeatures.createKey("trees_blossom_woods");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TREES_BLOSSOM_VALLEYS = EnvironmentalConfiguredFeatures.createKey("trees_blossom_valleys");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FALLEN_LEAVES_BLOSSOM_WOODS = EnvironmentalConfiguredFeatures.createKey("fallen_leaves_blossom_woods");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WHITE_WISTERIA = EnvironmentalConfiguredFeatures.createKey("white_wisteria");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WHITE_WISTERIA_BEES_002 = EnvironmentalConfiguredFeatures.createKey("white_wisteria_bees_002");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WHITE_WISTERIA_BEES_005 = EnvironmentalConfiguredFeatures.createKey("white_wisteria_bees_005");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BLUE_WISTERIA = EnvironmentalConfiguredFeatures.createKey("blue_wisteria");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BLUE_WISTERIA_BEES_002 = EnvironmentalConfiguredFeatures.createKey("blue_wisteria_bees_002");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BLUE_WISTERIA_BEES_005 = EnvironmentalConfiguredFeatures.createKey("blue_wisteria_bees_005");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PURPLE_WISTERIA = EnvironmentalConfiguredFeatures.createKey("purple_wisteria");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PURPLE_WISTERIA_BEES_002 = EnvironmentalConfiguredFeatures.createKey("purple_wisteria_bees_002");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PURPLE_WISTERIA_BEES_005 = EnvironmentalConfiguredFeatures.createKey("purple_wisteria_bees_005");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PINK_WISTERIA = EnvironmentalConfiguredFeatures.createKey("pink_wisteria");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PINK_WISTERIA_BEES_002 = EnvironmentalConfiguredFeatures.createKey("pink_wisteria_bees_002");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PINK_WISTERIA_BEES_005 = EnvironmentalConfiguredFeatures.createKey("pink_wisteria_bees_005");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TREES_WISTERIA = EnvironmentalConfiguredFeatures.createKey("trees_wisteria");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PINE = EnvironmentalConfiguredFeatures.createKey("pine");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PINE_BEES_0002 = EnvironmentalConfiguredFeatures.createKey("pine_bees_0002");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PINE_ON_STONE = EnvironmentalConfiguredFeatures.createKey("pine_on_stone");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TALL_PINE = EnvironmentalConfiguredFeatures.createKey("tall_pine");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TALL_PINE_WITH_PODZOL = EnvironmentalConfiguredFeatures.createKey("tall_pine_with_podzol");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TREES_PINE_BARRENS = EnvironmentalConfiguredFeatures.createKey("trees_pine_barrens");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TREES_OLD_GROWTH_PINE_BARRENS = EnvironmentalConfiguredFeatures.createKey("trees_old_growth_pine_barrens");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GRAINY_COARSE_DIRT = EnvironmentalConfiguredFeatures.createKey("grainy_coarse_dirt");
    public static final ResourceKey<ConfiguredFeature<?, ?>> COARSE_DIRT_ON_STONE = EnvironmentalConfiguredFeatures.createKey("coarse_dirt_on_stone");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SMALL_COARSE_DIRT_ON_STONE = EnvironmentalConfiguredFeatures.createKey("small_coarse_dirt_on_stone");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FALLEN_PINE_TREE = EnvironmentalConfiguredFeatures.createKey("fallen_pine_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FALLEN_TALL_PINE_TREE = EnvironmentalConfiguredFeatures.createKey("fallen_tall_pine_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DWARF_SPRUCE = EnvironmentalConfiguredFeatures.createKey("dwarf_spruce");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DWARF_SPRUCE_THICKET = EnvironmentalConfiguredFeatures.createKey("dwarf_spruce_thicket");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DWARF_SPRUCE_SPARSE = EnvironmentalConfiguredFeatures.createKey("dwarf_spruce_sparse");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_CUP_LICHEN = EnvironmentalConfiguredFeatures.createKey("patch_cup_lichen");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_CUP_LICHEN_SMALL = EnvironmentalConfiguredFeatures.createKey("patch_cup_lichen_small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FLOWER_BLUE_ORCHID = EnvironmentalConfiguredFeatures.createKey("flower_blue_orchid");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FLOWER_CORNFLOWER = EnvironmentalConfiguredFeatures.createKey("flower_cornflower");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FLOWER_DIANTHUS = EnvironmentalConfiguredFeatures.createKey("flower_dianthus");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FLOWER_BLUEBELL = EnvironmentalConfiguredFeatures.createKey("flower_bluebell");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FLOWER_BLUEBELL_LARGE = EnvironmentalConfiguredFeatures.createKey("flower_bluebell_large");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FLOWER_VIOLET = EnvironmentalConfiguredFeatures.createKey("flower_violet");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FLOWER_RED_LOTUS = EnvironmentalConfiguredFeatures.createKey("flower_red_lotus");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FLOWER_WHITE_LOTUS = EnvironmentalConfiguredFeatures.createKey("flower_white_lotus");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FLOWER_CARTWHEEL = EnvironmentalConfiguredFeatures.createKey("flower_cartwheel");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FLOWER_BIRD_OF_PARADISE = EnvironmentalConfiguredFeatures.createKey("flower_bird_of_paradise");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_TULIPS = EnvironmentalConfiguredFeatures.createKey("patch_tulips");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_TASSELFLOWER = EnvironmentalConfiguredFeatures.createKey("patch_tasselflower");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_DELPHINIUMS = EnvironmentalConfiguredFeatures.createKey("patch_delphiniums");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ZEBRA_DAZZLE = EnvironmentalConfiguredFeatures.createKey("zebra_dazzle");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HIBISCUS_BUSH = EnvironmentalConfiguredFeatures.createKey("hibiscus_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CATTAILS = EnvironmentalConfiguredFeatures.createKey("cattails");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CATTAILS_DENSE = EnvironmentalConfiguredFeatures.createKey("cattails_dense");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_DUCKWEED = EnvironmentalConfiguredFeatures.createKey("patch_duckweed");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_GIANT_TALL_GRASS = EnvironmentalConfiguredFeatures.createKey("patch_giant_tall_grass");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HUGE_BROWN_MUSHROOM = EnvironmentalConfiguredFeatures.createKey("huge_brown_mushroom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_MUD = EnvironmentalConfiguredFeatures.createKey("ore_mud");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BAMBOO_SHORT = EnvironmentalConfiguredFeatures.createKey("bamboo_short");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BAMBOO_SHORT_PODZOL = EnvironmentalConfiguredFeatures.createKey("bamboo_short_podzol");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FALLEN_PLUM_LEAVES = EnvironmentalConfiguredFeatures.createKey("fallen_plum_leaves");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FALLEN_CHEERFUL_PLUM_LEAVES = EnvironmentalConfiguredFeatures.createKey("fallen_cheerful_plum_leaves");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FALLEN_MOODY_PLUM_LEAVES = EnvironmentalConfiguredFeatures.createKey("fallen_moody_plum_leaves");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_MYCELIUM_SPROUTS = EnvironmentalConfiguredFeatures.createKey("patch_mycelium_sprouts");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_PINE_BARRENS_GRASS = EnvironmentalConfiguredFeatures.createKey("patch_pine_barrens_grass");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_JUNGLE_LARGE_FERN = EnvironmentalConfiguredFeatures.createKey("patch_jungle_large_fern");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_WATERLILY = EnvironmentalConfiguredFeatures.createKey("patch_waterlily");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_SUGAR_CANE = EnvironmentalConfiguredFeatures.createKey("patch_sugar_cane");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_GRASS = EnvironmentalConfiguredFeatures.createKey("patch_grass");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FOREST_FLOWERS = EnvironmentalConfiguredFeatures.createKey("forest_flowers");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SEAGRASS_MID = EnvironmentalConfiguredFeatures.createKey("seagrass_mid");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        HolderGetter placedFeatures = context.lookup(Registries.PLACED_FEATURE);
        HolderGetter noises = context.lookup(Registries.NOISE);
        EnvironmentalConfiguredFeatures.register(context, WILLOW, Feature.TREE, Configs.WILLOW);
        EnvironmentalConfiguredFeatures.register(context, WEEPING_WILLOW, (Feature)EnvironmentalFeatures.WEEPING_WILLOW_TREE.get(), Configs.WEEPING_WILLOW);
        EnvironmentalConfiguredFeatures.register(context, TREES_WILLOW, (Feature)EnvironmentalFeatures.WILLOW_TREE_PLACER.get(), NoneFeatureConfiguration.NONE);
        EnvironmentalConfiguredFeatures.register(context, TREES_SWAMP, Feature.RANDOM_SELECTOR, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)placedFeatures.getOrThrow(EnvironmentalPlacedFeatures.SWAMP_OAK), 0.1f)), (Holder)placedFeatures.getOrThrow(EnvironmentalPlacedFeatures.TREES_WILLOW)));
        EnvironmentalConfiguredFeatures.register(context, SWAMP_OAK, Feature.TREE, Configs.SWAMP_OAK);
        EnvironmentalConfiguredFeatures.register(context, MARSH_OAK, Feature.RANDOM_SELECTOR, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)placedFeatures.getOrThrow(TreePlacements.FANCY_OAK_CHECKED), 0.33333334f)), (Holder)placedFeatures.getOrThrow(TreePlacements.OAK_CHECKED)));
        EnvironmentalConfiguredFeatures.register(context, STONE_ROCK, Feature.FOREST_ROCK, new BlockStateConfiguration(Blocks.STONE.defaultBlockState()));
        EnvironmentalConfiguredFeatures.register(context, PINE_SLOPES_BOULDER, (Feature)EnvironmentalFeatures.PINE_SLOPES_BOULDER.get(), new BlockStateConfiguration(Blocks.STONE.defaultBlockState()));
        EnvironmentalConfiguredFeatures.register(context, PLUM, (Feature)EnvironmentalFeatures.PLUM_TREE.get(), Configs.PLUM);
        EnvironmentalConfiguredFeatures.register(context, PLUM_BEES_0002, (Feature)EnvironmentalFeatures.PLUM_TREE.get(), Configs.PLUM_BEES_0002);
        EnvironmentalConfiguredFeatures.register(context, PLUM_BEES_005, (Feature)EnvironmentalFeatures.PLUM_TREE.get(), Configs.PLUM_BEES_005);
        EnvironmentalConfiguredFeatures.register(context, PLUM_BEES_005_FALLEN_LEAVES, (Feature)EnvironmentalFeatures.PLUM_TREE.get(), Configs.PLUM_BEES_005_FALLEN_LEAVES);
        EnvironmentalConfiguredFeatures.register(context, CHEERFUL_PLUM, (Feature)EnvironmentalFeatures.PLUM_TREE.get(), Configs.CHEERFUL_PLUM);
        EnvironmentalConfiguredFeatures.register(context, CHEERFUL_PLUM_BEES_0002, (Feature)EnvironmentalFeatures.PLUM_TREE.get(), Configs.CHEERFUL_PLUM_BEES_0002);
        EnvironmentalConfiguredFeatures.register(context, CHEERFUL_PLUM_BEES_005, (Feature)EnvironmentalFeatures.PLUM_TREE.get(), Configs.CHEERFUL_PLUM_BEES_005);
        EnvironmentalConfiguredFeatures.register(context, CHEERFUL_PLUM_BEES_005_FALLEN_LEAVES, (Feature)EnvironmentalFeatures.PLUM_TREE.get(), Configs.CHEERFUL_PLUM_BEES_005_FALLEN_LEAVES);
        EnvironmentalConfiguredFeatures.register(context, MOODY_PLUM, (Feature)EnvironmentalFeatures.PLUM_TREE.get(), Configs.MOODY_PLUM);
        EnvironmentalConfiguredFeatures.register(context, MOODY_PLUM_BEES_0002, (Feature)EnvironmentalFeatures.PLUM_TREE.get(), Configs.MOODY_PLUM_BEES_0002);
        EnvironmentalConfiguredFeatures.register(context, MOODY_PLUM_BEES_005, (Feature)EnvironmentalFeatures.PLUM_TREE.get(), Configs.MOODY_PLUM_BEES_005);
        EnvironmentalConfiguredFeatures.register(context, MOODY_PLUM_BEES_005_FALLEN_LEAVES, (Feature)EnvironmentalFeatures.PLUM_TREE.get(), Configs.MOODY_PLUM_BEES_005_FALLEN_LEAVES);
        EnvironmentalConfiguredFeatures.register(context, TREES_BLOSSOM_WOODS, Feature.RANDOM_SELECTOR, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)placedFeatures.getOrThrow(TreePlacements.OAK_BEES_0002), 0.05f), new WeightedPlacedFeature((Holder)placedFeatures.getOrThrow(EnvironmentalPlacedFeatures.CHEERFUL_PLUM_BEES_0002), 0.3f), new WeightedPlacedFeature((Holder)placedFeatures.getOrThrow(EnvironmentalPlacedFeatures.MOODY_PLUM_BEES_0002), 0.3f)), (Holder)placedFeatures.getOrThrow(EnvironmentalPlacedFeatures.PLUM_BEES_0002)));
        EnvironmentalConfiguredFeatures.register(context, TREES_BLOSSOM_VALLEYS, Feature.RANDOM_SELECTOR, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)placedFeatures.getOrThrow(TreePlacements.OAK_BEES_002), 0.05f), new WeightedPlacedFeature((Holder)placedFeatures.getOrThrow(EnvironmentalPlacedFeatures.CHEERFUL_PLUM_BEES_005), 0.3f), new WeightedPlacedFeature((Holder)placedFeatures.getOrThrow(EnvironmentalPlacedFeatures.MOODY_PLUM_BEES_005), 0.3f)), (Holder)placedFeatures.getOrThrow(EnvironmentalPlacedFeatures.PLUM_BEES_005)));
        EnvironmentalConfiguredFeatures.register(context, FALLEN_PLUM_LEAVES, (Feature)EnvironmentalFeatures.FALLEN_LEAVES.get(), EnvironmentalConfiguredFeatures.fallenLeaves(((Block)EnvironmentalBlocks.PLUM_LEAF_PILE.get()).defaultBlockState(), 4, 3));
        EnvironmentalConfiguredFeatures.register(context, FALLEN_MOODY_PLUM_LEAVES, (Feature)EnvironmentalFeatures.FALLEN_LEAVES.get(), EnvironmentalConfiguredFeatures.fallenLeaves(((Block)EnvironmentalBlocks.MOODY_PLUM_LEAF_PILE.get()).defaultBlockState(), 4, 3));
        EnvironmentalConfiguredFeatures.register(context, FALLEN_CHEERFUL_PLUM_LEAVES, (Feature)EnvironmentalFeatures.FALLEN_LEAVES.get(), EnvironmentalConfiguredFeatures.fallenLeaves(((Block)EnvironmentalBlocks.CHEERFUL_PLUM_LEAF_PILE.get()).defaultBlockState(), 4, 3));
        EnvironmentalConfiguredFeatures.register(context, FALLEN_LEAVES_BLOSSOM_WOODS, Feature.RANDOM_SELECTOR, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)placedFeatures.getOrThrow(EnvironmentalPlacedFeatures.FALLEN_CHEERFUL_PLUM_LEAVES), 0.33f), new WeightedPlacedFeature((Holder)placedFeatures.getOrThrow(EnvironmentalPlacedFeatures.FALLEN_MOODY_PLUM_LEAVES), 0.3f)), (Holder)placedFeatures.getOrThrow(EnvironmentalPlacedFeatures.FALLEN_PLUM_LEAVES)));
        EnvironmentalConfiguredFeatures.register(context, WHITE_WISTERIA, (Feature)EnvironmentalFeatures.WISTERIA_TREE.get(), Configs.WHITE_WISTERIA);
        EnvironmentalConfiguredFeatures.register(context, WHITE_WISTERIA_BEES_002, (Feature)EnvironmentalFeatures.WISTERIA_TREE.get(), Configs.WHITE_WISTERIA_BEES_002);
        EnvironmentalConfiguredFeatures.register(context, WHITE_WISTERIA_BEES_005, (Feature)EnvironmentalFeatures.WISTERIA_TREE.get(), Configs.WHITE_WISTERIA_BEES_005);
        EnvironmentalConfiguredFeatures.register(context, BLUE_WISTERIA, (Feature)EnvironmentalFeatures.WISTERIA_TREE.get(), Configs.BLUE_WISTERIA);
        EnvironmentalConfiguredFeatures.register(context, BLUE_WISTERIA_BEES_002, (Feature)EnvironmentalFeatures.WISTERIA_TREE.get(), Configs.BLUE_WISTERIA_BEES_002);
        EnvironmentalConfiguredFeatures.register(context, BLUE_WISTERIA_BEES_005, (Feature)EnvironmentalFeatures.WISTERIA_TREE.get(), Configs.BLUE_WISTERIA_BEES_005);
        EnvironmentalConfiguredFeatures.register(context, PURPLE_WISTERIA, (Feature)EnvironmentalFeatures.WISTERIA_TREE.get(), Configs.PURPLE_WISTERIA);
        EnvironmentalConfiguredFeatures.register(context, PURPLE_WISTERIA_BEES_002, (Feature)EnvironmentalFeatures.WISTERIA_TREE.get(), Configs.PURPLE_WISTERIA_BEES_002);
        EnvironmentalConfiguredFeatures.register(context, PURPLE_WISTERIA_BEES_005, (Feature)EnvironmentalFeatures.WISTERIA_TREE.get(), Configs.PURPLE_WISTERIA_BEES_005);
        EnvironmentalConfiguredFeatures.register(context, PINK_WISTERIA, (Feature)EnvironmentalFeatures.WISTERIA_TREE.get(), Configs.PINK_WISTERIA);
        EnvironmentalConfiguredFeatures.register(context, PINK_WISTERIA_BEES_002, (Feature)EnvironmentalFeatures.WISTERIA_TREE.get(), Configs.PINK_WISTERIA_BEES_002);
        EnvironmentalConfiguredFeatures.register(context, PINK_WISTERIA_BEES_005, (Feature)EnvironmentalFeatures.WISTERIA_TREE.get(), Configs.PINK_WISTERIA_BEES_005);
        EnvironmentalConfiguredFeatures.register(context, TREES_WISTERIA, (Feature)EnvironmentalFeatures.MULTI_NOISE_SELECTOR.get(), new BestNoisesSelectorFeatureConfiguration((Holder<NormalNoise.NoiseParameters>)noises.getOrThrow(EnvironmentalNoiseParameters.WISTERIA_COLOR), 0.6f, List.of(placedFeatures.getOrThrow(EnvironmentalPlacedFeatures.PINK_WISTERIA_BEES_002), placedFeatures.getOrThrow(EnvironmentalPlacedFeatures.BLUE_WISTERIA_BEES_002), placedFeatures.getOrThrow(EnvironmentalPlacedFeatures.PURPLE_WISTERIA_BEES_002), placedFeatures.getOrThrow(EnvironmentalPlacedFeatures.WHITE_WISTERIA_BEES_002))));
        EnvironmentalConfiguredFeatures.register(context, PINE, (Feature)EnvironmentalFeatures.PINE_TREE.get(), Configs.PINE);
        EnvironmentalConfiguredFeatures.register(context, PINE_BEES_0002, (Feature)EnvironmentalFeatures.PINE_TREE.get(), Configs.PINE_BEES_0002);
        EnvironmentalConfiguredFeatures.register(context, PINE_ON_STONE, (Feature)EnvironmentalFeatures.PINE_TREE_ON_STONE.get(), Configs.PINE);
        EnvironmentalConfiguredFeatures.register(context, TALL_PINE, (Feature)EnvironmentalFeatures.PINE_TREE.get(), Configs.TALL_PINE);
        EnvironmentalConfiguredFeatures.register(context, TALL_PINE_WITH_PODZOL, (Feature)EnvironmentalFeatures.PINE_TREE.get(), Configs.TALL_PINE_WITH_PODZOL);
        EnvironmentalConfiguredFeatures.register(context, TREES_PINE_BARRENS, Feature.RANDOM_SELECTOR, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)placedFeatures.getOrThrow(TreePlacements.SPRUCE_CHECKED), 0.2f)), (Holder)placedFeatures.getOrThrow(EnvironmentalPlacedFeatures.PINE)));
        EnvironmentalConfiguredFeatures.register(context, TREES_OLD_GROWTH_PINE_BARRENS, Feature.RANDOM_SELECTOR, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)placedFeatures.getOrThrow(TreePlacements.SPRUCE_CHECKED), 0.15f)), (Holder)placedFeatures.getOrThrow(EnvironmentalPlacedFeatures.TALL_PINE_WITH_PODZOL)));
        EnvironmentalConfiguredFeatures.register(context, GRAINY_COARSE_DIRT, (Feature)EnvironmentalFeatures.GRAINY_COARSE_DIRT.get(), new ProbabilityFeatureConfiguration(0.1f));
        EnvironmentalConfiguredFeatures.register(context, COARSE_DIRT_ON_STONE, (Feature)EnvironmentalFeatures.COARSE_DIRT_ON_STONE.get(), NoneFeatureConfiguration.NONE);
        EnvironmentalConfiguredFeatures.register(context, SMALL_COARSE_DIRT_ON_STONE, (Feature)EnvironmentalFeatures.SMALL_COARSE_DIRT_ON_STONE.get(), NoneFeatureConfiguration.NONE);
        EnvironmentalConfiguredFeatures.register(context, FALLEN_PINE_TREE, (Feature)EnvironmentalFeatures.FALLEN_PINE_TREE.get(), NoneFeatureConfiguration.INSTANCE);
        EnvironmentalConfiguredFeatures.register(context, FALLEN_TALL_PINE_TREE, (Feature)EnvironmentalFeatures.FALLEN_TALL_PINE_TREE.get(), NoneFeatureConfiguration.INSTANCE);
        EnvironmentalConfiguredFeatures.register(context, DWARF_SPRUCE, (Feature)EnvironmentalFeatures.DWARF_SPRUCE.get(), new DwarfSpruceConfiguration(5, 0.6f, true));
        EnvironmentalConfiguredFeatures.register(context, DWARF_SPRUCE_THICKET, (Feature)EnvironmentalFeatures.DWARF_SPRUCE.get(), new DwarfSpruceConfiguration(12, 0.0, false));
        EnvironmentalConfiguredFeatures.register(context, DWARF_SPRUCE_SPARSE, (Feature)EnvironmentalFeatures.DWARF_SPRUCE.get(), new DwarfSpruceConfiguration(3, 0.0, true));
        EnvironmentalConfiguredFeatures.register(context, PATCH_CUP_LICHEN, (Feature)EnvironmentalFeatures.CUP_LICHEN_PATCH.get(), new CupLichenPatchConfiguration(64, 3, 2));
        EnvironmentalConfiguredFeatures.register(context, PATCH_CUP_LICHEN_SMALL, (Feature)EnvironmentalFeatures.CUP_LICHEN_PATCH.get(), new CupLichenPatchConfiguration(32, 2, 2));
        EnvironmentalConfiguredFeatures.register(context, FLOWER_BLUE_ORCHID, Feature.FLOWER, new RandomPatchConfiguration(64, 6, 2, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.BLUE_ORCHID)))));
        EnvironmentalConfiguredFeatures.register(context, FLOWER_CORNFLOWER, Feature.FLOWER, new RandomPatchConfiguration(64, 6, 2, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.CORNFLOWER)))));
        EnvironmentalConfiguredFeatures.register(context, FLOWER_DIANTHUS, Feature.FLOWER, new RandomPatchConfiguration(64, 6, 2, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)EnvironmentalBlocks.DIANTHUS.get()))))));
        EnvironmentalConfiguredFeatures.register(context, FLOWER_BLUEBELL, Feature.FLOWER, new RandomPatchConfiguration(128, 6, 2, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)EnvironmentalBlocks.BLUEBELL.get()))))));
        EnvironmentalConfiguredFeatures.register(context, FLOWER_BLUEBELL_LARGE, (Feature)EnvironmentalFeatures.LARGE_BLUEBELL_PATCH.get(), NoneFeatureConfiguration.NONE);
        EnvironmentalConfiguredFeatures.register(context, FLOWER_VIOLET, Feature.FLOWER, new RandomPatchConfiguration(32, 6, 2, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)EnvironmentalBlocks.VIOLET.get()))))));
        EnvironmentalConfiguredFeatures.register(context, FLOWER_RED_LOTUS, Feature.FLOWER, new RandomPatchConfiguration(24, 6, 2, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)EnvironmentalBlocks.RED_LOTUS_FLOWER.get()))))));
        EnvironmentalConfiguredFeatures.register(context, FLOWER_WHITE_LOTUS, Feature.FLOWER, new RandomPatchConfiguration(24, 6, 2, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)EnvironmentalBlocks.WHITE_LOTUS_FLOWER.get()))))));
        EnvironmentalConfiguredFeatures.register(context, FLOWER_CARTWHEEL, (Feature)EnvironmentalFeatures.CARTWHEEL.get(), new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)((BlockState)((Block)EnvironmentalBlocks.CARTWHEEL.get()).defaultBlockState().setValue((Property)CartwheelBlock.FACING, (Comparable)Direction.NORTH)), 1).add((Object)((BlockState)((Block)EnvironmentalBlocks.CARTWHEEL.get()).defaultBlockState().setValue((Property)CartwheelBlock.FACING, (Comparable)Direction.SOUTH)), 1).add((Object)((BlockState)((Block)EnvironmentalBlocks.CARTWHEEL.get()).defaultBlockState().setValue((Property)CartwheelBlock.FACING, (Comparable)Direction.EAST)), 1).add((Object)((BlockState)((Block)EnvironmentalBlocks.CARTWHEEL.get()).defaultBlockState().setValue((Property)CartwheelBlock.FACING, (Comparable)Direction.WEST)), 1))));
        EnvironmentalConfiguredFeatures.register(context, FLOWER_BIRD_OF_PARADISE, Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)EnvironmentalBlocks.BIRD_OF_PARADISE.get()))), List.of(), (int)32));
        EnvironmentalConfiguredFeatures.register(context, PATCH_TULIPS, Feature.SIMPLE_RANDOM_SELECTOR, new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.direct((Holder[])new Holder[]{PlacementUtils.inlinePlaced((Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.WHITE_TULIP))), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.inlinePlaced((Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.RED_TULIP))), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.inlinePlaced((Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.PINK_TULIP))), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.inlinePlaced((Feature)Feature.FLOWER, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.ORANGE_TULIP))), (PlacementModifier[])new PlacementModifier[0])})));
        EnvironmentalConfiguredFeatures.register(context, PATCH_TASSELFLOWER, (Feature)EnvironmentalFeatures.TASSELFLOWER_PATCH.get(), NoneFeatureConfiguration.NONE);
        EnvironmentalConfiguredFeatures.register(context, PATCH_DELPHINIUMS, Feature.SIMPLE_RANDOM_SELECTOR, new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.direct((Holder[])new Holder[]{PlacementUtils.inlinePlaced((Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)EnvironmentalBlocks.PINK_DELPHINIUM.get())))), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.inlinePlaced((Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)EnvironmentalBlocks.PURPLE_DELPHINIUM.get())))), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.inlinePlaced((Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)EnvironmentalBlocks.BLUE_DELPHINIUM.get())))), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.inlinePlaced((Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)EnvironmentalBlocks.WHITE_DELPHINIUM.get())))), (PlacementModifier[])new PlacementModifier[0])})));
        EnvironmentalConfiguredFeatures.register(context, ZEBRA_DAZZLE, (Feature)EnvironmentalFeatures.ZEBRA_DAZZLE.get(), NoneFeatureConfiguration.NONE);
        EnvironmentalConfiguredFeatures.register(context, HIBISCUS_BUSH, (Feature)EnvironmentalFeatures.HIBISCUS_BUSH.get(), NoneFeatureConfiguration.NONE);
        EnvironmentalConfiguredFeatures.register(context, CATTAILS, (Feature)EnvironmentalFeatures.CATTAILS.get(), NoneFeatureConfiguration.NONE);
        EnvironmentalConfiguredFeatures.register(context, CATTAILS_DENSE, (Feature)EnvironmentalFeatures.DENSE_CATTAILS.get(), NoneFeatureConfiguration.NONE);
        EnvironmentalConfiguredFeatures.register(context, PATCH_DUCKWEED, Feature.RANDOM_PATCH, new RandomPatchConfiguration(1024, 8, 5, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)EnvironmentalBlocks.DUCKWEED.get()))))));
        EnvironmentalConfiguredFeatures.register(context, PATCH_GIANT_TALL_GRASS, Feature.RANDOM_PATCH, EnvironmentalConfiguredFeatures.grassPatch((BlockStateProvider)BlockStateProvider.simple((Block)((Block)EnvironmentalBlocks.GIANT_TALL_GRASS.get())), 64));
        EnvironmentalConfiguredFeatures.register(context, HUGE_BROWN_MUSHROOM, Feature.HUGE_BROWN_MUSHROOM, new HugeMushroomFeatureConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((BlockState)Blocks.BROWN_MUSHROOM_BLOCK.defaultBlockState().setValue((Property)HugeMushroomBlock.UP, (Comparable)Boolean.valueOf(true))).setValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.valueOf(false)))), (BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((BlockState)Blocks.MUSHROOM_STEM.defaultBlockState().setValue((Property)HugeMushroomBlock.UP, (Comparable)Boolean.valueOf(false))).setValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.valueOf(false)))), 3));
        EnvironmentalConfiguredFeatures.register(context, ORE_MUD, Feature.ORE, new OreConfiguration((RuleTest)new TagMatchTest(EnvironmentalBlockTags.MUD_REPLACEABLES), Blocks.MUD.defaultBlockState(), 64));
        EnvironmentalConfiguredFeatures.register(context, BAMBOO_SHORT, (Feature)EnvironmentalFeatures.SHORT_BAMBOO.get(), new ProbabilityFeatureConfiguration(0.0f));
        EnvironmentalConfiguredFeatures.register(context, BAMBOO_SHORT_PODZOL, (Feature)EnvironmentalFeatures.SHORT_BAMBOO.get(), new ProbabilityFeatureConfiguration(0.2f));
        EnvironmentalConfiguredFeatures.register(context, PATCH_MYCELIUM_SPROUTS, Feature.RANDOM_PATCH, EnvironmentalConfiguredFeatures.grassPatch((BlockStateProvider)BlockStateProvider.simple((Block)((Block)EnvironmentalBlocks.MYCELIUM_SPROUTS.get())), 32));
        EnvironmentalConfiguredFeatures.register(context, PATCH_PINE_BARRENS_GRASS, Feature.RANDOM_PATCH, EnvironmentalConfiguredFeatures.grassPatch((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)Blocks.SHORT_GRASS.defaultBlockState(), 3).add((Object)Blocks.FERN.defaultBlockState(), 2)), 32));
        EnvironmentalConfiguredFeatures.register(context, PATCH_JUNGLE_LARGE_FERN, Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.LARGE_FERN))));
        EnvironmentalConfiguredFeatures.register(context, PATCH_WATERLILY, Feature.RANDOM_PATCH, new RandomPatchConfiguration(10, 7, 3, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.LILY_PAD)))));
        EnvironmentalConfiguredFeatures.register(context, PATCH_SUGAR_CANE, Feature.RANDOM_PATCH, new RandomPatchConfiguration(20, 4, 0, PlacementUtils.inlinePlaced((Feature)Feature.BLOCK_COLUMN, (FeatureConfiguration)BlockColumnConfiguration.simple((IntProvider)BiasedToBottomInt.of((int)2, (int)4), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.SUGAR_CANE)), (PlacementModifier[])new PlacementModifier[]{BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.allOf((BlockPredicate[])new BlockPredicate[]{BlockPredicate.ONLY_IN_AIR_PREDICATE, BlockPredicate.wouldSurvive((BlockState)Blocks.SUGAR_CANE.defaultBlockState(), (Vec3i)BlockPos.ZERO), BlockPredicate.anyOf((BlockPredicate[])new BlockPredicate[]{BlockPredicate.matchesFluids((Vec3i)new BlockPos(1, -1, 0), (Fluid[])new Fluid[]{Fluids.WATER, Fluids.FLOWING_WATER}), BlockPredicate.matchesFluids((Vec3i)new BlockPos(-1, -1, 0), (Fluid[])new Fluid[]{Fluids.WATER, Fluids.FLOWING_WATER}), BlockPredicate.matchesFluids((Vec3i)new BlockPos(0, -1, 1), (Fluid[])new Fluid[]{Fluids.WATER, Fluids.FLOWING_WATER}), BlockPredicate.matchesFluids((Vec3i)new BlockPos(0, -1, -1), (Fluid[])new Fluid[]{Fluids.WATER, Fluids.FLOWING_WATER})})}))})));
        EnvironmentalConfiguredFeatures.register(context, PATCH_GRASS, Feature.RANDOM_PATCH, EnvironmentalConfiguredFeatures.grassPatch((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.SHORT_GRASS), 32));
        EnvironmentalConfiguredFeatures.register(context, FOREST_FLOWERS, Feature.SIMPLE_RANDOM_SELECTOR, new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.direct((Holder[])new Holder[]{PlacementUtils.inlinePlaced((Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.LILAC))), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.inlinePlaced((Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.ROSE_BUSH))), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.inlinePlaced((Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.PEONY))), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.inlinePlaced((Feature)Feature.NO_BONEMEAL_FLOWER, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.LILY_OF_THE_VALLEY))), (PlacementModifier[])new PlacementModifier[0])})));
        EnvironmentalConfiguredFeatures.register(context, SEAGRASS_MID, Feature.SEAGRASS, new ProbabilityFeatureConfiguration(0.6f));
    }

    private static RandomPatchConfiguration grassPatch(BlockStateProvider p_195203_, int p_195204_) {
        return FeatureUtils.simpleRandomPatchConfiguration((int)p_195204_, (Holder)PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration(p_195203_)));
    }

    private static FallenLeavesConfiguration fallenLeaves(BlockState leafPileState, int radius, int ySpread) {
        return new FallenLeavesConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)leafPileState.setValue((Property)PipeBlock.DOWN, (Comparable)Boolean.valueOf(true)))), radius, ySpread);
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)Environmental.location(name));
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC config) {
        context.register(key, (Object)new ConfiguredFeature(feature, config));
    }

    public static final class Configs {
        private static final BeehiveDecorator BEEHIVE_0002 = new BeehiveDecorator(0.002f);
        private static final BeehiveDecorator BEEHIVE_002 = new BeehiveDecorator(0.02f);
        private static final BeehiveDecorator BEEHIVE_005 = new BeehiveDecorator(0.05f);
        private static final HangingWisteriaDecorator HANGING_WHITE_WISTERIA = new HangingWisteriaDecorator(0.05f);
        private static final HangingWisteriaDecorator HANGING_BLUE_WISTERIA = new HangingWisteriaDecorator(0.25f);
        private static final HangingWisteriaDecorator HANGING_PURPLE_WISTERIA = new HangingWisteriaDecorator(0.5f);
        private static final HangingWisteriaDecorator HANGING_PINK_WISTERIA = new HangingWisteriaDecorator(0.75f);
        private static final PineconeDecorator PINECONE = new PineconeDecorator(0.05f);
        public static final TreeConfiguration SWAMP_OAK = Configs.createStraightBlobTree(Blocks.OAK_LOG, Blocks.OAK_LEAVES, 5, 3, 0, 2).decorators((List)ImmutableList.of((Object)new LeaveVineDecorator(0.25f))).build();
        public static final TreeConfiguration WILLOW = Configs.createStraightBlobTree((Block)EnvironmentalBlocks.WILLOW_LOG.get(), (Block)EnvironmentalBlocks.WILLOW_LEAVES.get(), 5, 3, 0, 3).decorators((List)ImmutableList.of((Object)new LeaveVineDecorator(0.25f), (Object)((Object)HangingWillowDecorator.INSTANCE))).build();
        public static final TreeConfiguration WEEPING_WILLOW = Configs.createCustomTree((Block)EnvironmentalBlocks.WILLOW_LOG.get(), (TrunkPlacer)new StraightTrunkPlacer(11, 1, 0), (Block)EnvironmentalBlocks.WILLOW_LEAVES.get()).decorators((List)ImmutableList.of((Object)new LeaveVineDecorator(0.35f), (Object)((Object)HangingWillowDecorator.INSTANCE))).build();
        public static final TreeConfiguration PLUM = Configs.createPlum().build();
        public static final TreeConfiguration PLUM_BEES_0002 = Configs.createPlum().decorators(List.of(BEEHIVE_0002, Configs.fallenLeavesDecorator(((Block)EnvironmentalBlocks.PLUM_LEAF_PILE.get()).defaultBlockState()))).build();
        public static final TreeConfiguration PLUM_BEES_005 = Configs.createPlum().decorators(List.of(BEEHIVE_005)).build();
        public static final TreeConfiguration PLUM_BEES_005_FALLEN_LEAVES = Configs.createPlum().decorators(List.of(BEEHIVE_005, Configs.fallenLeavesDecorator(((Block)EnvironmentalBlocks.PLUM_LEAF_PILE.get()).defaultBlockState()))).build();
        public static final TreeConfiguration CHEERFUL_PLUM = Configs.createCheerfulPlum().build();
        public static final TreeConfiguration CHEERFUL_PLUM_BEES_0002 = Configs.createCheerfulPlum().decorators(List.of(BEEHIVE_0002, Configs.fallenLeavesDecorator(((Block)EnvironmentalBlocks.CHEERFUL_PLUM_LEAF_PILE.get()).defaultBlockState()))).build();
        public static final TreeConfiguration CHEERFUL_PLUM_BEES_005 = Configs.createCheerfulPlum().decorators(List.of(BEEHIVE_005)).build();
        public static final TreeConfiguration CHEERFUL_PLUM_BEES_005_FALLEN_LEAVES = Configs.createCheerfulPlum().decorators(List.of(BEEHIVE_005, Configs.fallenLeavesDecorator(((Block)EnvironmentalBlocks.CHEERFUL_PLUM_LEAF_PILE.get()).defaultBlockState()))).build();
        public static final TreeConfiguration MOODY_PLUM = Configs.createMoodyPlum().build();
        public static final TreeConfiguration MOODY_PLUM_BEES_0002 = Configs.createMoodyPlum().decorators(List.of(BEEHIVE_0002, Configs.fallenLeavesDecorator(((Block)EnvironmentalBlocks.MOODY_PLUM_LEAF_PILE.get()).defaultBlockState()))).build();
        public static final TreeConfiguration MOODY_PLUM_BEES_005 = Configs.createMoodyPlum().decorators(List.of(BEEHIVE_005)).build();
        public static final TreeConfiguration MOODY_PLUM_BEES_005_FALLEN_LEAVES = Configs.createMoodyPlum().decorators(List.of(BEEHIVE_005, Configs.fallenLeavesDecorator(((Block)EnvironmentalBlocks.MOODY_PLUM_LEAF_PILE.get()).defaultBlockState()))).build();
        public static final TreeConfiguration WHITE_WISTERIA = Configs.createWhiteWisteria().build();
        public static final TreeConfiguration WHITE_WISTERIA_BEES_002 = Configs.createWhiteWisteria().decorators(List.of(HANGING_WHITE_WISTERIA, BEEHIVE_002)).build();
        public static final TreeConfiguration WHITE_WISTERIA_BEES_005 = Configs.createWhiteWisteria().decorators(List.of(HANGING_WHITE_WISTERIA, BEEHIVE_005)).build();
        public static final TreeConfiguration BLUE_WISTERIA = Configs.createBlueWisteria().build();
        public static final TreeConfiguration BLUE_WISTERIA_BEES_002 = Configs.createBlueWisteria().decorators(List.of(HANGING_BLUE_WISTERIA, BEEHIVE_002)).build();
        public static final TreeConfiguration BLUE_WISTERIA_BEES_005 = Configs.createBlueWisteria().decorators(List.of(HANGING_BLUE_WISTERIA, BEEHIVE_005)).build();
        public static final TreeConfiguration PURPLE_WISTERIA = Configs.createPurpleWisteria().build();
        public static final TreeConfiguration PURPLE_WISTERIA_BEES_002 = Configs.createPurpleWisteria().decorators(List.of(HANGING_PURPLE_WISTERIA, BEEHIVE_002)).build();
        public static final TreeConfiguration PURPLE_WISTERIA_BEES_005 = Configs.createPurpleWisteria().decorators(List.of(HANGING_PURPLE_WISTERIA, BEEHIVE_005)).build();
        public static final TreeConfiguration PINK_WISTERIA = Configs.createPinkWisteria().build();
        public static final TreeConfiguration PINK_WISTERIA_BEES_002 = Configs.createPinkWisteria().decorators(List.of(HANGING_PINK_WISTERIA, BEEHIVE_002)).build();
        public static final TreeConfiguration PINK_WISTERIA_BEES_005 = Configs.createPinkWisteria().decorators(List.of(HANGING_PINK_WISTERIA, BEEHIVE_005)).build();
        public static final TreeConfiguration PINE = Configs.createPine().decorators(List.of(PINECONE)).build();
        public static final TreeConfiguration PINE_BEES_0002 = Configs.createPine().decorators(List.of(PINECONE, BEEHIVE_0002)).build();
        public static final TreeConfiguration TALL_PINE = Configs.createTallPine().decorators(List.of(PINECONE)).build();
        public static final TreeConfiguration TALL_PINE_WITH_PODZOL = Configs.createTallPine().decorators(List.of(PINECONE, PinePodzolDecorator.INSTANCE)).build();

        private static TreeConfiguration.TreeConfigurationBuilder createPlum() {
            return Configs.createCustomTree((Block)EnvironmentalBlocks.PLUM_LOG.get(), (TrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (Block)EnvironmentalBlocks.PLUM_LEAVES.get());
        }

        private static TreeConfiguration.TreeConfigurationBuilder createCheerfulPlum() {
            return Configs.createCustomTree((Block)EnvironmentalBlocks.PLUM_LOG.get(), (TrunkPlacer)new StraightTrunkPlacer(4, 1, 0), (Block)EnvironmentalBlocks.CHEERFUL_PLUM_LEAVES.get());
        }

        private static TreeConfiguration.TreeConfigurationBuilder createMoodyPlum() {
            return Configs.createCustomTree((Block)EnvironmentalBlocks.PLUM_LOG.get(), (TrunkPlacer)new StraightTrunkPlacer(3, 1, 0), (Block)EnvironmentalBlocks.MOODY_PLUM_LEAVES.get());
        }

        private static TreeConfiguration.TreeConfigurationBuilder createPine() {
            return Configs.createCustomTree((Block)EnvironmentalBlocks.PINE_LOG.get(), (TrunkPlacer)new StraightTrunkPlacer(11, 3, 1), (Block)EnvironmentalBlocks.PINE_LEAVES.get());
        }

        private static TreeConfiguration.TreeConfigurationBuilder createTallPine() {
            return Configs.createCustomTree((Block)EnvironmentalBlocks.PINE_LOG.get(), (TrunkPlacer)new StraightTrunkPlacer(16, 3, 1), (Block)EnvironmentalBlocks.PINE_LEAVES.get());
        }

        private static TreeConfiguration.TreeConfigurationBuilder createWhiteWisteria() {
            return Configs.createWisteriaTree((Block)EnvironmentalBlocks.WHITE_WISTERIA_LEAVES.get(), HANGING_WHITE_WISTERIA);
        }

        private static TreeConfiguration.TreeConfigurationBuilder createBlueWisteria() {
            return Configs.createWisteriaTree((Block)EnvironmentalBlocks.BLUE_WISTERIA_LEAVES.get(), HANGING_BLUE_WISTERIA);
        }

        private static TreeConfiguration.TreeConfigurationBuilder createPurpleWisteria() {
            return Configs.createWisteriaTree((Block)EnvironmentalBlocks.PURPLE_WISTERIA_LEAVES.get(), HANGING_PURPLE_WISTERIA);
        }

        private static TreeConfiguration.TreeConfigurationBuilder createPinkWisteria() {
            return Configs.createWisteriaTree((Block)EnvironmentalBlocks.PINK_WISTERIA_LEAVES.get(), HANGING_PINK_WISTERIA);
        }

        private static TreeConfiguration.TreeConfigurationBuilder createCustomTree(BlockStateProvider logProvider, TrunkPlacer trunkPlacer, BlockStateProvider leavesProvider) {
            return new TreeConfiguration.TreeConfigurationBuilder(logProvider, trunkPlacer, leavesProvider, (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)0), 0), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0)).ignoreVines();
        }

        private static TreeConfiguration.TreeConfigurationBuilder createCustomTree(Block log, TrunkPlacer trunkPlacer, Block leaves) {
            return Configs.createCustomTree((BlockStateProvider)BlockStateProvider.simple((Block)log), trunkPlacer, (BlockStateProvider)BlockStateProvider.simple((Block)leaves));
        }

        private static TreeConfiguration.TreeConfigurationBuilder createCustomTree(BlockStateProvider logProvider, BlockStateProvider leavesProvider) {
            return Configs.createCustomTree(logProvider, (TrunkPlacer)new StraightTrunkPlacer(0, 0, 0), leavesProvider);
        }

        private static TreeConfiguration.TreeConfigurationBuilder createWisteriaTree(Block leaves, TreeDecorator ... decorators) {
            return Configs.createCustomTree((Block)EnvironmentalBlocks.WISTERIA_LOG.get(), (TrunkPlacer)new StraightTrunkPlacer(2, 1, 0), leaves).decorators(List.of(decorators));
        }

        private static TreeConfiguration.TreeConfigurationBuilder createCustomTree(Block log, Block leaves) {
            return Configs.createCustomTree((BlockStateProvider)BlockStateProvider.simple((Block)log), (BlockStateProvider)BlockStateProvider.simple((Block)leaves));
        }

        private static TreeDecorator fallenLeavesDecorator(BlockState leafPileState) {
            return new FallenLeavesDecorator((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)leafPileState.setValue((Property)PipeBlock.DOWN, (Comparable)Boolean.valueOf(true)))), 4, 3);
        }

        private static TreeConfiguration.TreeConfigurationBuilder createStraightBlobTree(Block p_195147_, Block p_195148_, int p_195149_, int p_195150_, int p_195151_, int p_195152_) {
            return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)p_195147_), (TrunkPlacer)new StraightTrunkPlacer(p_195149_, p_195150_, p_195151_), (BlockStateProvider)BlockStateProvider.simple((Block)p_195148_), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)p_195152_), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1));
        }
    }
}

