/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.registry.datapack;

import com.teamabnormals.environmental.core.Environmental;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.decoration.PaintingVariant;

public class EnvironmentalPaintingVariants {
    public static final ResourceKey<PaintingVariant> SLABFISH = EnvironmentalPaintingVariants.create("slabfish");
    public static final ResourceKey<PaintingVariant> SNAKE_BLOCK = EnvironmentalPaintingVariants.create("snake_block");
    public static final ResourceKey<PaintingVariant> ARCHIVE = EnvironmentalPaintingVariants.create("archive");
    public static final ResourceKey<PaintingVariant> OPTIMAL_AERODYNAMICS = EnvironmentalPaintingVariants.create("optimal_aerodynamics");
    public static final ResourceKey<PaintingVariant> IN_PLAINS_SIGHT = EnvironmentalPaintingVariants.create("in_plains_sight");
    public static final ResourceKey<PaintingVariant> THE_PLACE_WITHIN_THE_PINES = EnvironmentalPaintingVariants.create("the_place_within_the_pines");
    public static final ResourceKey<PaintingVariant> BOUQUET = EnvironmentalPaintingVariants.create("bouquet");
    public static final ResourceKey<PaintingVariant> BOUQUET2 = EnvironmentalPaintingVariants.create("bouquet2");
    public static final ResourceKey<PaintingVariant> LONE_PLUM = EnvironmentalPaintingVariants.create("lone_plum");
    public static final ResourceKey<PaintingVariant> MARSHPATH = EnvironmentalPaintingVariants.create("marshpath");

    public static void bootstrap(BootstrapContext<PaintingVariant> context) {
        EnvironmentalPaintingVariants.register(context, SLABFISH, 2, 2);
        EnvironmentalPaintingVariants.register(context, SNAKE_BLOCK, 2, 2);
        EnvironmentalPaintingVariants.register(context, ARCHIVE, 4, 3);
        EnvironmentalPaintingVariants.register(context, OPTIMAL_AERODYNAMICS, 2, 3);
        EnvironmentalPaintingVariants.register(context, IN_PLAINS_SIGHT, 2, 1);
        EnvironmentalPaintingVariants.register(context, THE_PLACE_WITHIN_THE_PINES, 3, 1);
        EnvironmentalPaintingVariants.register(context, BOUQUET, 1, 2);
        EnvironmentalPaintingVariants.register(context, BOUQUET2, 1, 1);
        EnvironmentalPaintingVariants.register(context, LONE_PLUM, 3, 2);
        EnvironmentalPaintingVariants.register(context, MARSHPATH, 2, 3);
    }

    private static ResourceKey<PaintingVariant> create(String name) {
        return ResourceKey.create((ResourceKey)Registries.PAINTING_VARIANT, (ResourceLocation)Environmental.location(name));
    }

    private static void register(BootstrapContext<PaintingVariant> context, ResourceKey<PaintingVariant> key, int width, int height) {
        context.register(key, (Object)new PaintingVariant(width, height, key.location()));
    }
}

