/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.registry.datapack;

import com.google.common.collect.ImmutableList;
import com.teamabnormals.environmental.common.levelgen.feature.placement.NoiseDensityPlacement;
import com.teamabnormals.environmental.core.Environmental;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.teamabnormals.environmental.core.registry.datapack.EnvironmentalConfiguredFeatures;
import com.teamabnormals.environmental.core.registry.datapack.EnvironmentalNoiseParameters;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.ClampedInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseBasedCountPlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class EnvironmentalPlacedFeatures {
    private static final PlacementFilter ON_STONE_PLACEMENT_FILTER = BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesTag((Vec3i)Direction.DOWN.getNormal(), (TagKey)BlockTags.BASE_STONE_OVERWORLD));
    public static final ResourceKey<PlacedFeature> ORE_MUD = EnvironmentalPlacedFeatures.createKey("ore_mud");
    public static final ResourceKey<PlacedFeature> SEAGRASS_MARSH = EnvironmentalPlacedFeatures.createKey("seagrass_marsh");
    public static final ResourceKey<PlacedFeature> PATCH_WATERLILY_MARSH = EnvironmentalPlacedFeatures.createKey("patch_waterlily");
    public static final ResourceKey<PlacedFeature> PATCH_DUCKWEED = EnvironmentalPlacedFeatures.createKey("patch_duckweed");
    public static final ResourceKey<PlacedFeature> PATCH_DUCKWEED_SWAMP = EnvironmentalPlacedFeatures.createKey("patch_duckweed_swamp");
    public static final ResourceKey<PlacedFeature> FLOWER_BLUE_ORCHID = EnvironmentalPlacedFeatures.createKey("flower_blue_orchid");
    public static final ResourceKey<PlacedFeature> FLOWER_CORNFLOWER = EnvironmentalPlacedFeatures.createKey("flower_cornflower");
    public static final ResourceKey<PlacedFeature> FLOWER_DIANTHUS = EnvironmentalPlacedFeatures.createKey("flower_dianthus");
    public static final ResourceKey<PlacedFeature> FLOWER_BLUEBELL = EnvironmentalPlacedFeatures.createKey("flower_bluebell");
    public static final ResourceKey<PlacedFeature> FLOWER_BLUEBELL_LARGE = EnvironmentalPlacedFeatures.createKey("flower_bluebell_large");
    public static final ResourceKey<PlacedFeature> FLOWER_VIOLET = EnvironmentalPlacedFeatures.createKey("flower_violet");
    public static final ResourceKey<PlacedFeature> FLOWER_RED_LOTUS = EnvironmentalPlacedFeatures.createKey("flower_red_lotus");
    public static final ResourceKey<PlacedFeature> FLOWER_WHITE_LOTUS = EnvironmentalPlacedFeatures.createKey("flower_white_lotus");
    public static final ResourceKey<PlacedFeature> FLOWER_BIRD_OF_PARADISE = EnvironmentalPlacedFeatures.createKey("flower_bird_of_paradise");
    public static final ResourceKey<PlacedFeature> PATCH_TULIPS = EnvironmentalPlacedFeatures.createKey("patch_tulips");
    public static final ResourceKey<PlacedFeature> FOREST_FLOWERS = EnvironmentalPlacedFeatures.createKey("forest_flowers");
    public static final ResourceKey<PlacedFeature> PATCH_TASSELFLOWER = EnvironmentalPlacedFeatures.createKey("patch_tasselflower");
    public static final ResourceKey<PlacedFeature> PATCH_DELPHINIUMS = EnvironmentalPlacedFeatures.createKey("patch_delphiniums");
    public static final ResourceKey<PlacedFeature> FLOWER_CARTWHEEL = EnvironmentalPlacedFeatures.createKey("flower_cartwheel");
    public static final ResourceKey<PlacedFeature> ZEBRA_DAZZLE = EnvironmentalPlacedFeatures.createKey("zebra_dazzle");
    public static final ResourceKey<PlacedFeature> HIBISCUS_BUSH = EnvironmentalPlacedFeatures.createKey("hibiscus_bush");
    public static final ResourceKey<PlacedFeature> WHITE_WISTERIA_BEES_002 = EnvironmentalPlacedFeatures.createKey("white_wisteria_bees_002");
    public static final ResourceKey<PlacedFeature> PINK_WISTERIA_BEES_002 = EnvironmentalPlacedFeatures.createKey("pink_wisteria_bees_002");
    public static final ResourceKey<PlacedFeature> PURPLE_WISTERIA_BEES_002 = EnvironmentalPlacedFeatures.createKey("purple_wisteria_bees_002");
    public static final ResourceKey<PlacedFeature> BLUE_WISTERIA_BEES_002 = EnvironmentalPlacedFeatures.createKey("blue_wisteria_bees_002");
    public static final ResourceKey<PlacedFeature> TREES_WISTERIA = EnvironmentalPlacedFeatures.createKey("trees_wisteria");
    public static final ResourceKey<PlacedFeature> TREES_WILLOW = EnvironmentalPlacedFeatures.createKey("trees_willow");
    public static final ResourceKey<PlacedFeature> SWAMP_OAK = EnvironmentalPlacedFeatures.createKey("swamp_oak");
    public static final ResourceKey<PlacedFeature> TREES_MARSH = EnvironmentalPlacedFeatures.createKey("trees_marsh");
    public static final ResourceKey<PlacedFeature> TREES_SWAMP = EnvironmentalPlacedFeatures.createKey("trees_swamp");
    public static final ResourceKey<PlacedFeature> HUGE_BROWN_MUSHROOM_MARSH = EnvironmentalPlacedFeatures.createKey("huge_brown_mushroom_marsh");
    public static final ResourceKey<PlacedFeature> PLUM_BEES_0002 = EnvironmentalPlacedFeatures.createKey("plum_bees_0002");
    public static final ResourceKey<PlacedFeature> CHEERFUL_PLUM_BEES_0002 = EnvironmentalPlacedFeatures.createKey("cheerful_plum_bees_0002");
    public static final ResourceKey<PlacedFeature> MOODY_PLUM_BEES_0002 = EnvironmentalPlacedFeatures.createKey("moody_plum_bees_0002");
    public static final ResourceKey<PlacedFeature> PLUM_BEES_005 = EnvironmentalPlacedFeatures.createKey("plum_bees_005");
    public static final ResourceKey<PlacedFeature> CHEERFUL_PLUM_BEES_005 = EnvironmentalPlacedFeatures.createKey("cheerful_plum_bees_005");
    public static final ResourceKey<PlacedFeature> MOODY_PLUM_BEES_005 = EnvironmentalPlacedFeatures.createKey("moody_plum_bees_005");
    public static final ResourceKey<PlacedFeature> PLUM_TREES_BLOSSOM_WOODS = EnvironmentalPlacedFeatures.createKey("plum_tree_blossom_woods");
    public static final ResourceKey<PlacedFeature> PLUM_TREES_BLOSSOM_VALLEYS = EnvironmentalPlacedFeatures.createKey("plum_tree_blossom_valleys");
    public static final ResourceKey<PlacedFeature> PINE_TREES_BLOSSOM_WOODS = EnvironmentalPlacedFeatures.createKey("pine_trees_blossom_woods");
    public static final ResourceKey<PlacedFeature> PINE_TREES_BLOSSOM_VALLEYS = EnvironmentalPlacedFeatures.createKey("pine_trees_blossom_valleys");
    public static final ResourceKey<PlacedFeature> FALLEN_PLUM_LEAVES = EnvironmentalPlacedFeatures.createKey("fallen_plum_leaves");
    public static final ResourceKey<PlacedFeature> FALLEN_CHEERFUL_PLUM_LEAVES = EnvironmentalPlacedFeatures.createKey("fallen_cheerful_plum_leaves");
    public static final ResourceKey<PlacedFeature> FALLEN_MOODY_PLUM_LEAVES = EnvironmentalPlacedFeatures.createKey("fallen_moody_plum_leaves");
    public static final ResourceKey<PlacedFeature> FALLEN_PLUM_LEAVES_BLOSSOM_WOODS = EnvironmentalPlacedFeatures.createKey("fallen_plum_leaves_blossom_woods");
    public static final ResourceKey<PlacedFeature> FALLEN_PLUM_LEAVES_BLOSSOM_VALLEYS = EnvironmentalPlacedFeatures.createKey("fallen_plum_leaves_blossom_valleys");
    public static final ResourceKey<PlacedFeature> BLOSSOM_WOODS_ROCK = EnvironmentalPlacedFeatures.createKey("blossom_woods_rock");
    public static final ResourceKey<PlacedFeature> PINE = EnvironmentalPlacedFeatures.createKey("pine");
    public static final ResourceKey<PlacedFeature> TALL_PINE_WITH_PODZOL = EnvironmentalPlacedFeatures.createKey("tall_pine_with_podzol");
    public static final ResourceKey<PlacedFeature> TREES_PINE_BARRENS = EnvironmentalPlacedFeatures.createKey("trees_pine_barrens");
    public static final ResourceKey<PlacedFeature> TREES_OLD_GROWTH_PINE_BARRENS = EnvironmentalPlacedFeatures.createKey("trees_old_growth_pine_barrens");
    public static final ResourceKey<PlacedFeature> TREES_PINE_BARRENS_ON_STONE = EnvironmentalPlacedFeatures.createKey("trees_pine_barrens_on_stone");
    public static final ResourceKey<PlacedFeature> TREES_PINE_SLOPES = EnvironmentalPlacedFeatures.createKey("trees_pine_slopes");
    public static final ResourceKey<PlacedFeature> GRAINY_COARSE_DIRT = EnvironmentalPlacedFeatures.createKey("grainy_coarse_dirt");
    public static final ResourceKey<PlacedFeature> COARSE_DIRT_ON_STONE = EnvironmentalPlacedFeatures.createKey("coarse_dirt_on_stone");
    public static final ResourceKey<PlacedFeature> SMALL_COARSE_DIRT_ON_STONE = EnvironmentalPlacedFeatures.createKey("small_coarse_dirt_on_stone");
    public static final ResourceKey<PlacedFeature> FALLEN_PINE_TREE = EnvironmentalPlacedFeatures.createKey("fallen_pine_tree");
    public static final ResourceKey<PlacedFeature> FALLEN_TALL_PINE_TREE = EnvironmentalPlacedFeatures.createKey("fallen_tall_pine_tree");
    public static final ResourceKey<PlacedFeature> DWARF_SPRUCE = EnvironmentalPlacedFeatures.createKey("dwarf_spruce");
    public static final ResourceKey<PlacedFeature> DWARF_SPRUCE_THICKET = EnvironmentalPlacedFeatures.createKey("dwarf_spruce_thicket");
    public static final ResourceKey<PlacedFeature> DWARF_SPRUCE_SPARSE = EnvironmentalPlacedFeatures.createKey("dwarf_spruce_sparse");
    public static final ResourceKey<PlacedFeature> PATCH_CUP_LICHEN = EnvironmentalPlacedFeatures.createKey("patch_cup_lichen");
    public static final ResourceKey<PlacedFeature> PATCH_CUP_LICHEN_TAIGA = EnvironmentalPlacedFeatures.createKey("patch_cup_lichen_taiga");
    public static final ResourceKey<PlacedFeature> PATCH_CUP_LICHEN_SMALL = EnvironmentalPlacedFeatures.createKey("patch_cup_lichen_small");
    public static final ResourceKey<PlacedFeature> PINE_SLOPES_ROCK = EnvironmentalPlacedFeatures.createKey("pine_slopes_rock");
    public static final ResourceKey<PlacedFeature> PINE_SLOPES_BOULDER = EnvironmentalPlacedFeatures.createKey("pine_slopes_boulder");
    public static final ResourceKey<PlacedFeature> BAMBOO_BLOSSOM_WOODS = EnvironmentalPlacedFeatures.createKey("bamboo_blossom_woods");
    public static final ResourceKey<PlacedFeature> BAMBOO_LIGHT_BLOSSOM_WOODS = EnvironmentalPlacedFeatures.createKey("bamboo_light_blossom_woods");
    public static final ResourceKey<PlacedFeature> BAMBOO_BLOSSOM_VALLEYS = EnvironmentalPlacedFeatures.createKey("bamboo_blossom_valleys");
    public static final ResourceKey<PlacedFeature> BAMBOO_LIGHT_BLOSSOM_VALLEYS = EnvironmentalPlacedFeatures.createKey("bamboo_light_blossom_valleys");
    public static final ResourceKey<PlacedFeature> PATCH_GRASS_MARSH = EnvironmentalPlacedFeatures.createKey("patch_grass_marsh");
    public static final ResourceKey<PlacedFeature> PATCH_GRASS_BLOSSOM_WOODS = EnvironmentalPlacedFeatures.createKey("patch_grass_blossom_woods");
    public static final ResourceKey<PlacedFeature> PATCH_MYCELIUM_SPROUTS = EnvironmentalPlacedFeatures.createKey("patch_mycelium_sprouts");
    public static final ResourceKey<PlacedFeature> PATCH_GRASS_PINE_BARRENS = EnvironmentalPlacedFeatures.createKey("patch_grass_pine_barrens");
    public static final ResourceKey<PlacedFeature> PATCH_GRASS_SNOWY_PINE_BARRENS = EnvironmentalPlacedFeatures.createKey("patch_grass_snowy_pine_barrens");
    public static final ResourceKey<PlacedFeature> PATCH_GRASS_OLD_GROWTH_PINE_BARRENS = EnvironmentalPlacedFeatures.createKey("patch_grass_old_growth_pine_barrens");
    public static final ResourceKey<PlacedFeature> PATCH_GRASS_PINE_SLOPES = EnvironmentalPlacedFeatures.createKey("patch_grass_pine_slopes");
    public static final ResourceKey<PlacedFeature> PATCH_LARGE_FERN_JUNGLE = EnvironmentalPlacedFeatures.createKey("patch_large_fern_jungle");
    public static final ResourceKey<PlacedFeature> PATCH_LARGE_FERN_PINE_BARRENS = EnvironmentalPlacedFeatures.createKey("patch_large_fern_pine_barrens");
    public static final ResourceKey<PlacedFeature> PATCH_GIANT_TALL_GRASS_PLAINS = EnvironmentalPlacedFeatures.createKey("patch_giant_tall_grass_plains");
    public static final ResourceKey<PlacedFeature> PATCH_GIANT_TALL_GRASS_SAVANNA = EnvironmentalPlacedFeatures.createKey("patch_giant_tall_grass_savanna");
    public static final ResourceKey<PlacedFeature> PATCH_GIANT_TALL_GRASS_JUNGLE = EnvironmentalPlacedFeatures.createKey("patch_giant_tall_grass_jungle");
    public static final ResourceKey<PlacedFeature> PATCH_GIANT_TALL_GRASS_MARSH = EnvironmentalPlacedFeatures.createKey("patch_giant_tall_grass_marsh");
    public static final ResourceKey<PlacedFeature> CATTAILS = EnvironmentalPlacedFeatures.createKey("cattails");
    public static final ResourceKey<PlacedFeature> CATTAILS_DENSE = EnvironmentalPlacedFeatures.createKey("cattails_dense");
    public static final ResourceKey<PlacedFeature> PATCH_SUGAR_CANE_BLOSSOM = EnvironmentalPlacedFeatures.createKey("patch_sugar_cane_blossom");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter noises = context.lookup(Registries.NOISE);
        EnvironmentalPlacedFeatures.register(context, ORE_MUD, EnvironmentalConfiguredFeatures.ORE_MUD, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)3), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_TOP_SOLID, BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesFluids((Fluid[])new Fluid[]{Fluids.WATER})), BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, SEAGRASS_MARSH, EnvironmentalConfiguredFeatures.SEAGRASS_MID, new PlacementModifier[]{InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_TOP_SOLID, CountPlacement.of((int)128), BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, PATCH_WATERLILY_MARSH, EnvironmentalConfiguredFeatures.PATCH_WATERLILY, VegetationPlacements.worldSurfaceSquaredWithCount((int)1));
        EnvironmentalPlacedFeatures.register(context, PATCH_DUCKWEED, EnvironmentalConfiguredFeatures.PATCH_DUCKWEED, new PlacementModifier[]{PlacementUtils.countExtra((int)0, (float)0.25f, (int)1), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, PATCH_DUCKWEED_SWAMP, EnvironmentalConfiguredFeatures.PATCH_DUCKWEED, new PlacementModifier[]{PlacementUtils.countExtra((int)0, (float)0.25f, (int)1), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, FLOWER_BLUE_ORCHID, EnvironmentalConfiguredFeatures.FLOWER_BLUE_ORCHID, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)32), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, FLOWER_CORNFLOWER, EnvironmentalConfiguredFeatures.FLOWER_CORNFLOWER, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)32), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, FLOWER_DIANTHUS, EnvironmentalConfiguredFeatures.FLOWER_DIANTHUS, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)32), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, FLOWER_BLUEBELL, EnvironmentalConfiguredFeatures.FLOWER_BLUEBELL, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)32), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, FLOWER_BLUEBELL_LARGE, EnvironmentalConfiguredFeatures.FLOWER_BLUEBELL_LARGE, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)256), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, FLOWER_VIOLET, EnvironmentalConfiguredFeatures.FLOWER_VIOLET, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)32), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, FLOWER_RED_LOTUS, EnvironmentalConfiguredFeatures.FLOWER_RED_LOTUS, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)16), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, FLOWER_WHITE_LOTUS, EnvironmentalConfiguredFeatures.FLOWER_WHITE_LOTUS, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)16), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, FLOWER_BIRD_OF_PARADISE, EnvironmentalConfiguredFeatures.FLOWER_BIRD_OF_PARADISE, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)16), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, PATCH_TULIPS, EnvironmentalConfiguredFeatures.PATCH_TULIPS, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)4), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, FOREST_FLOWERS, EnvironmentalConfiguredFeatures.FOREST_FLOWERS, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)16), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, CountPlacement.of((IntProvider)ClampedInt.of((IntProvider)UniformInt.of((int)-3, (int)1), (int)0, (int)1)), BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, PATCH_TASSELFLOWER, EnvironmentalConfiguredFeatures.PATCH_TASSELFLOWER, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)16), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, PATCH_DELPHINIUMS, EnvironmentalConfiguredFeatures.PATCH_DELPHINIUMS, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)8), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, CountPlacement.of((IntProvider)ClampedInt.of((IntProvider)UniformInt.of((int)-3, (int)2), (int)0, (int)2)), BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, FLOWER_CARTWHEEL, EnvironmentalConfiguredFeatures.FLOWER_CARTWHEEL, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)12), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, ZEBRA_DAZZLE, EnvironmentalConfiguredFeatures.ZEBRA_DAZZLE, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)256), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, HIBISCUS_BUSH, EnvironmentalConfiguredFeatures.HIBISCUS_BUSH, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)256), CountPlacement.of((int)6), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, WHITE_WISTERIA_BEES_002, EnvironmentalConfiguredFeatures.WHITE_WISTERIA_BEES_002, new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)EnvironmentalBlocks.WHITE_WISTERIA_SAPLING.get()))});
        EnvironmentalPlacedFeatures.register(context, PINK_WISTERIA_BEES_002, EnvironmentalConfiguredFeatures.PINK_WISTERIA_BEES_002, new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)EnvironmentalBlocks.PINK_WISTERIA_SAPLING.get()))});
        EnvironmentalPlacedFeatures.register(context, PURPLE_WISTERIA_BEES_002, EnvironmentalConfiguredFeatures.PURPLE_WISTERIA_BEES_002, new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)EnvironmentalBlocks.PURPLE_WISTERIA_SAPLING.get()))});
        EnvironmentalPlacedFeatures.register(context, BLUE_WISTERIA_BEES_002, EnvironmentalConfiguredFeatures.BLUE_WISTERIA_BEES_002, new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)EnvironmentalBlocks.BLUE_WISTERIA_SAPLING.get()))});
        EnvironmentalPlacedFeatures.register(context, TREES_WISTERIA, EnvironmentalConfiguredFeatures.TREES_WISTERIA, VegetationPlacements.treePlacement((PlacementModifier)new NoiseDensityPlacement((Holder<NormalNoise.NoiseParameters>)noises.getOrThrow(EnvironmentalNoiseParameters.WISTERIA_DENSITY), 1.25, 0.5)));
        EnvironmentalPlacedFeatures.register(context, TREES_WILLOW, EnvironmentalConfiguredFeatures.TREES_WILLOW, new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)EnvironmentalBlocks.WILLOW_SAPLING.get()))});
        EnvironmentalPlacedFeatures.register(context, SWAMP_OAK, EnvironmentalConfiguredFeatures.SWAMP_OAK, new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)Blocks.OAK_SAPLING)});
        EnvironmentalPlacedFeatures.register(context, TREES_MARSH, EnvironmentalConfiguredFeatures.MARSH_OAK, VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)0, (float)0.25f, (int)1)));
        EnvironmentalPlacedFeatures.register(context, TREES_SWAMP, EnvironmentalConfiguredFeatures.TREES_SWAMP, new PlacementModifier[]{PlacementUtils.countExtra((int)2, (float)0.1f, (int)1), InSquarePlacement.spread(), SurfaceWaterDepthFilter.forMaxDepth((int)2), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BiomeFilter.biome(), BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.wouldSurvive((BlockState)Blocks.OAK_SAPLING.defaultBlockState(), (Vec3i)BlockPos.ZERO))});
        EnvironmentalPlacedFeatures.register(context, HUGE_BROWN_MUSHROOM_MARSH, EnvironmentalConfiguredFeatures.HUGE_BROWN_MUSHROOM, VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)0, (float)0.025f, (int)1)));
        EnvironmentalPlacedFeatures.register(context, PLUM_BEES_0002, EnvironmentalConfiguredFeatures.PLUM_BEES_0002, new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)EnvironmentalBlocks.PLUM_SAPLING.get()))});
        EnvironmentalPlacedFeatures.register(context, CHEERFUL_PLUM_BEES_0002, EnvironmentalConfiguredFeatures.CHEERFUL_PLUM_BEES_0002, new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)EnvironmentalBlocks.CHEERFUL_PLUM_SAPLING.get()))});
        EnvironmentalPlacedFeatures.register(context, MOODY_PLUM_BEES_0002, EnvironmentalConfiguredFeatures.MOODY_PLUM_BEES_0002, new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)EnvironmentalBlocks.MOODY_PLUM_SAPLING.get()))});
        EnvironmentalPlacedFeatures.register(context, PLUM_BEES_005, EnvironmentalConfiguredFeatures.PLUM_BEES_005_FALLEN_LEAVES, new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)EnvironmentalBlocks.PLUM_SAPLING.get()))});
        EnvironmentalPlacedFeatures.register(context, CHEERFUL_PLUM_BEES_005, EnvironmentalConfiguredFeatures.CHEERFUL_PLUM_BEES_005_FALLEN_LEAVES, new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)EnvironmentalBlocks.CHEERFUL_PLUM_SAPLING.get()))});
        EnvironmentalPlacedFeatures.register(context, MOODY_PLUM_BEES_005, EnvironmentalConfiguredFeatures.MOODY_PLUM_BEES_005_FALLEN_LEAVES, new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)EnvironmentalBlocks.MOODY_PLUM_SAPLING.get()))});
        EnvironmentalPlacedFeatures.register(context, PLUM_TREES_BLOSSOM_WOODS, EnvironmentalConfiguredFeatures.TREES_BLOSSOM_WOODS, VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)12, (float)0.1f, (int)1), (Block)((Block)EnvironmentalBlocks.PLUM_SAPLING.get())));
        EnvironmentalPlacedFeatures.register(context, PLUM_TREES_BLOSSOM_VALLEYS, EnvironmentalConfiguredFeatures.TREES_BLOSSOM_VALLEYS, VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)1, (float)0.2f, (int)2), (Block)((Block)EnvironmentalBlocks.PLUM_SAPLING.get())));
        EnvironmentalPlacedFeatures.register(context, PINE_TREES_BLOSSOM_WOODS, EnvironmentalConfiguredFeatures.PINE_BEES_0002, VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)1, (float)0.05f, (int)7), (Block)((Block)EnvironmentalBlocks.PLUM_SAPLING.get())));
        EnvironmentalPlacedFeatures.register(context, PINE_TREES_BLOSSOM_VALLEYS, EnvironmentalConfiguredFeatures.PINE_BEES_0002, VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)0, (float)0.05f, (int)3), (Block)((Block)EnvironmentalBlocks.PLUM_SAPLING.get())));
        EnvironmentalPlacedFeatures.register(context, FALLEN_PLUM_LEAVES, EnvironmentalConfiguredFeatures.FALLEN_PLUM_LEAVES, new PlacementModifier[0]);
        EnvironmentalPlacedFeatures.register(context, FALLEN_CHEERFUL_PLUM_LEAVES, EnvironmentalConfiguredFeatures.FALLEN_CHEERFUL_PLUM_LEAVES, new PlacementModifier[0]);
        EnvironmentalPlacedFeatures.register(context, FALLEN_MOODY_PLUM_LEAVES, EnvironmentalConfiguredFeatures.FALLEN_MOODY_PLUM_LEAVES, new PlacementModifier[0]);
        EnvironmentalPlacedFeatures.register(context, FALLEN_PLUM_LEAVES_BLOSSOM_WOODS, EnvironmentalConfiguredFeatures.FALLEN_LEAVES_BLOSSOM_WOODS, new PlacementModifier[]{CountPlacement.of((int)1), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, FALLEN_PLUM_LEAVES_BLOSSOM_VALLEYS, EnvironmentalConfiguredFeatures.FALLEN_LEAVES_BLOSSOM_WOODS, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, BLOSSOM_WOODS_ROCK, EnvironmentalConfiguredFeatures.STONE_ROCK, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)3), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, PINE, EnvironmentalConfiguredFeatures.PINE, new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)EnvironmentalBlocks.PINE_SAPLING.get()))});
        EnvironmentalPlacedFeatures.register(context, TALL_PINE_WITH_PODZOL, EnvironmentalConfiguredFeatures.TALL_PINE_WITH_PODZOL, new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)((Block)EnvironmentalBlocks.PINE_SAPLING.get()))});
        EnvironmentalPlacedFeatures.register(context, TREES_PINE_BARRENS, EnvironmentalConfiguredFeatures.TREES_PINE_BARRENS, EnvironmentalPlacedFeatures.treePlacement(PlacementUtils.countExtra((int)14, (float)0.1f, (int)1), new PlacementModifier[0]));
        EnvironmentalPlacedFeatures.register(context, TREES_OLD_GROWTH_PINE_BARRENS, EnvironmentalConfiguredFeatures.TREES_OLD_GROWTH_PINE_BARRENS, EnvironmentalPlacedFeatures.treePlacement(PlacementUtils.countExtra((int)22, (float)0.1f, (int)1), new PlacementModifier[0]));
        EnvironmentalPlacedFeatures.register(context, TREES_PINE_BARRENS_ON_STONE, EnvironmentalConfiguredFeatures.PINE_ON_STONE, EnvironmentalPlacedFeatures.treePlacement(PlacementUtils.countExtra((int)3, (float)0.1f, (int)1), new PlacementModifier[]{ON_STONE_PLACEMENT_FILTER}));
        EnvironmentalPlacedFeatures.register(context, TREES_PINE_SLOPES, EnvironmentalConfiguredFeatures.PINE_ON_STONE, EnvironmentalPlacedFeatures.treePlacement(PlacementUtils.countExtra((int)6, (float)0.1f, (int)1), new PlacementModifier[]{ON_STONE_PLACEMENT_FILTER}));
        EnvironmentalPlacedFeatures.register(context, GRAINY_COARSE_DIRT, EnvironmentalConfiguredFeatures.GRAINY_COARSE_DIRT, new PlacementModifier[]{CountPlacement.of((int)56), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, COARSE_DIRT_ON_STONE, EnvironmentalConfiguredFeatures.COARSE_DIRT_ON_STONE, new PlacementModifier[]{CountPlacement.of((int)3), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, SMALL_COARSE_DIRT_ON_STONE, EnvironmentalConfiguredFeatures.SMALL_COARSE_DIRT_ON_STONE, new PlacementModifier[]{CountPlacement.of((int)4), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, FALLEN_PINE_TREE, EnvironmentalConfiguredFeatures.FALLEN_PINE_TREE, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)10), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, FALLEN_TALL_PINE_TREE, EnvironmentalConfiguredFeatures.FALLEN_TALL_PINE_TREE, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)5), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, DWARF_SPRUCE, EnvironmentalConfiguredFeatures.DWARF_SPRUCE, new PlacementModifier[]{PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, DWARF_SPRUCE_THICKET, EnvironmentalConfiguredFeatures.DWARF_SPRUCE_THICKET, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)128), CountPlacement.of((int)4), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, DWARF_SPRUCE_SPARSE, EnvironmentalConfiguredFeatures.DWARF_SPRUCE_SPARSE, new PlacementModifier[]{PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, PATCH_CUP_LICHEN, EnvironmentalConfiguredFeatures.PATCH_CUP_LICHEN, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)22), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, PATCH_CUP_LICHEN_TAIGA, EnvironmentalConfiguredFeatures.PATCH_CUP_LICHEN, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)22), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, PATCH_CUP_LICHEN_SMALL, EnvironmentalConfiguredFeatures.PATCH_CUP_LICHEN_SMALL, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)8), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, PINE_SLOPES_ROCK, EnvironmentalConfiguredFeatures.STONE_ROCK, new PlacementModifier[]{CountPlacement.of((int)2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, PINE_SLOPES_BOULDER, EnvironmentalConfiguredFeatures.PINE_SLOPES_BOULDER, new PlacementModifier[]{CountPlacement.of((int)1), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, BAMBOO_BLOSSOM_WOODS, EnvironmentalConfiguredFeatures.BAMBOO_SHORT_PODZOL, new PlacementModifier[]{NoiseBasedCountPlacement.of((int)11, (double)5.0, (double)0.2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, BAMBOO_LIGHT_BLOSSOM_WOODS, EnvironmentalConfiguredFeatures.BAMBOO_SHORT_PODZOL, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)1), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, BAMBOO_BLOSSOM_VALLEYS, EnvironmentalConfiguredFeatures.BAMBOO_SHORT, new PlacementModifier[]{NoiseBasedCountPlacement.of((int)5, (double)5.0, (double)0.2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, BAMBOO_LIGHT_BLOSSOM_VALLEYS, EnvironmentalConfiguredFeatures.BAMBOO_SHORT, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)5), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, PATCH_GRASS_MARSH, EnvironmentalConfiguredFeatures.PATCH_GRASS, VegetationPlacements.worldSurfaceSquaredWithCount((int)5));
        EnvironmentalPlacedFeatures.register(context, PATCH_GRASS_BLOSSOM_WOODS, EnvironmentalConfiguredFeatures.PATCH_GRASS, VegetationPlacements.worldSurfaceSquaredWithCount((int)12));
        EnvironmentalPlacedFeatures.register(context, PATCH_MYCELIUM_SPROUTS, EnvironmentalConfiguredFeatures.PATCH_MYCELIUM_SPROUTS, new PlacementModifier[]{NoiseThresholdCountPlacement.of((double)-0.8, (int)5, (int)10), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, PATCH_GRASS_PINE_BARRENS, EnvironmentalConfiguredFeatures.PATCH_PINE_BARRENS_GRASS, VegetationPlacements.worldSurfaceSquaredWithCount((int)2));
        EnvironmentalPlacedFeatures.register(context, PATCH_GRASS_SNOWY_PINE_BARRENS, EnvironmentalConfiguredFeatures.PATCH_PINE_BARRENS_GRASS, new PlacementModifier[]{InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, PATCH_GRASS_OLD_GROWTH_PINE_BARRENS, EnvironmentalConfiguredFeatures.PATCH_PINE_BARRENS_GRASS, VegetationPlacements.worldSurfaceSquaredWithCount((int)8));
        EnvironmentalPlacedFeatures.register(context, PATCH_GRASS_PINE_SLOPES, EnvironmentalConfiguredFeatures.PATCH_GRASS, VegetationPlacements.worldSurfaceSquaredWithCount((int)26));
        EnvironmentalPlacedFeatures.register(context, PATCH_LARGE_FERN_JUNGLE, EnvironmentalConfiguredFeatures.PATCH_JUNGLE_LARGE_FERN, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)6), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, PATCH_LARGE_FERN_PINE_BARRENS, EnvironmentalConfiguredFeatures.PATCH_JUNGLE_LARGE_FERN, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)8), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, PATCH_GIANT_TALL_GRASS_PLAINS, EnvironmentalConfiguredFeatures.PATCH_GIANT_TALL_GRASS, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)16), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, PATCH_GIANT_TALL_GRASS_SAVANNA, EnvironmentalConfiguredFeatures.PATCH_GIANT_TALL_GRASS, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)8), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, PATCH_GIANT_TALL_GRASS_JUNGLE, EnvironmentalConfiguredFeatures.PATCH_GIANT_TALL_GRASS, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)4), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, PATCH_GIANT_TALL_GRASS_MARSH, EnvironmentalConfiguredFeatures.PATCH_GIANT_TALL_GRASS, new PlacementModifier[]{CountPlacement.of((int)8), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, CATTAILS, EnvironmentalConfiguredFeatures.CATTAILS, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, CATTAILS_DENSE, EnvironmentalConfiguredFeatures.CATTAILS_DENSE, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)5), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        EnvironmentalPlacedFeatures.register(context, PATCH_SUGAR_CANE_BLOSSOM, EnvironmentalConfiguredFeatures.PATCH_SUGAR_CANE, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
    }

    private static ImmutableList<PlacementModifier> treePlacement(PlacementModifier modifier, PlacementModifier ... extraModifiers) {
        return ImmutableList.builder().add((Object)modifier).add((Object)InSquarePlacement.spread()).add((Object)SurfaceWaterDepthFilter.forMaxDepth((int)0)).add((Object)PlacementUtils.HEIGHTMAP_OCEAN_FLOOR).add((Object)BiomeFilter.biome()).add((Object[])extraModifiers).build();
    }

    public static ResourceKey<PlacedFeature> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)Environmental.location(name));
    }

    public static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, ResourceKey<ConfiguredFeature<?, ?>> feature, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature((Holder)context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(feature), modifiers));
    }

    public static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, ResourceKey<ConfiguredFeature<?, ?>> feature, PlacementModifier ... modifiers) {
        EnvironmentalPlacedFeatures.register(context, key, feature, List.of(modifiers));
    }
}

