/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.registry.datapack.slabfish;

import com.teamabnormals.environmental.common.slabfish.SlabfishBackpack;
import com.teamabnormals.environmental.core.Environmental;
import com.teamabnormals.environmental.core.registry.EnvironmentalRegistries;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;

public class EnvironmentalSlabfishBackpacks {
    public static final ResourceKey<SlabfishBackpack> BROWN = EnvironmentalSlabfishBackpacks.create("brown");
    public static final ResourceKey<SlabfishBackpack> SNAKE_BLOCK = EnvironmentalSlabfishBackpacks.create("snake_block");

    public static void bootstrap(BootstrapContext<SlabfishBackpack> context) {
        for (DyeColor color : DyeColor.values()) {
            ResourceKey<SlabfishBackpack> key = EnvironmentalSlabfishBackpacks.create(color.getName());
            context.register(key, (Object)SlabfishBackpack.create((Component)Component.translatable((String)Util.makeDescriptionId((String)"slabfish_backpack", (ResourceLocation)key.location())), ResourceLocation.fromNamespaceAndPath((String)key.location().getNamespace(), (String)("backpack/" + key.location().getPath())), (TagKey<Item>)color.getTag()));
        }
        context.register(SNAKE_BLOCK, (Object)new SlabfishBackpack((Component)Component.translatable((String)Util.makeDescriptionId((String)"slabfish_backpack", (ResourceLocation)SNAKE_BLOCK.location())), Environmental.location("backpack/snake_block"), Optional.empty(), Optional.empty()));
    }

    public static ResourceKey<SlabfishBackpack> create(String name) {
        return ResourceKey.create(EnvironmentalRegistries.SLABFISH_BACKPACK, (ResourceLocation)Environmental.location(name));
    }
}

