/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.element;

import fr.frinn.custommachinery.api.guielement.IMachineScreen;
import fr.frinn.custommachinery.client.ClientHandler;
import fr.frinn.custommachinery.client.render.FluidRenderer;
import fr.frinn.custommachinery.common.guielement.FluidGuiElement;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.impl.guielement.TexturedGuiElementWidget;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class FluidGuiElementWidget
extends TexturedGuiElementWidget<FluidGuiElement> {
    public FluidGuiElementWidget(FluidGuiElement element, IMachineScreen screen) {
        super(element, screen, (Component)Component.literal((String)"Fluid"));
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        this.getScreen().getTile().getComponentManager().getComponentHandler(Registration.FLUID_MACHINE_COMPONENT.get()).flatMap(fluidHandler -> fluidHandler.getComponentForID(((FluidGuiElement)this.getElement()).getComponentId())).ifPresent(component -> FluidRenderer.renderFluid(graphics.pose(), this.getX() + 1, this.getY() + 1, this.width - 2, this.height - 2, component.getFluid(), component.getCapacity(), ((FluidGuiElement)this.getElement()).orientation()));
        if (this.isHovered() && ((FluidGuiElement)this.getElement()).highlight()) {
            ClientHandler.renderSlotHighlight(graphics, this.getX() + 1, this.getY() + 1, this.width - 2, this.height - 2);
        }
    }

    @Override
    public List<Component> getTooltips() {
        if (!((FluidGuiElement)this.getElement()).getTooltips().isEmpty()) {
            return ((FluidGuiElement)this.getElement()).getTooltips();
        }
        return this.getScreen().getTile().getComponentManager().getComponentHandler(Registration.FLUID_MACHINE_COMPONENT.get()).flatMap(fluidHandler -> fluidHandler.getComponentForID(((FluidGuiElement)this.getElement()).getComponentId())).map(component -> {
            long amount = component.getFluid().getAmount();
            long capacity = component.getCapacity();
            MutableComponent tooltip = !component.getFluid().isEmpty() && amount > 0L ? Component.empty().append(component.getFluid().getHoverName()).append((Component)Component.translatable((String)"custommachinery.gui.element.fluid.tooltip", (Object[])new Object[]{Utils.format(amount), Utils.format(capacity)})) : Component.translatable((String)"custommachinery.gui.element.fluid.empty", (Object[])new Object[]{0, Utils.format(capacity)});
            return Collections.singletonList(tooltip);
        }).orElse(Collections.emptyList());
    }
}

