/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.element;

import fr.frinn.custommachinery.api.guielement.IMachineScreen;
import fr.frinn.custommachinery.common.config.CMConfig;
import fr.frinn.custommachinery.common.guielement.SlotGuiElement;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.CycleTimer;
import fr.frinn.custommachinery.common.util.GhostItem;
import fr.frinn.custommachinery.impl.guielement.TexturedGuiElementWidget;
import fr.frinn.custommachinery.impl.util.FakeItemRenderer;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class SlotGuiElementWidget
extends TexturedGuiElementWidget<SlotGuiElement> {
    private static final CycleTimer timer = new CycleTimer((Supplier<Integer>)CMConfig.CONFIG.itemSlotCycleTime);

    public SlotGuiElementWidget(SlotGuiElement element, IMachineScreen screen) {
        super(element, screen, (Component)Component.literal((String)"Slot"));
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        GhostItem ghost = ((SlotGuiElement)this.getElement()).getGhost();
        if (ghost != GhostItem.EMPTY && ghost.ingredient().getItems().length != 0 && (ghost.alwaysRender() || this.isSlotEmpty())) {
            timer.onDraw();
            List<Item> items = Arrays.stream(ghost.ingredient().getItems()).map(ItemStack::getItem).toList();
            FakeItemRenderer.render(graphics, timer.getOrDefault(items, Items.AIR).getDefaultInstance(), this.getX() + 1, this.getY() + 1, ghost.color().getARGB());
        }
    }

    protected boolean clicked(double mouseX, double mouseY) {
        return false;
    }

    private boolean isSlotEmpty() {
        return this.getScreen().getTile().getComponentManager().getComponentHandler(Registration.ITEM_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(((SlotGuiElement)this.getElement()).getComponentId())).map(component -> component.getItemStack().isEmpty()).orElse(true);
    }
}

