/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.element;

import fr.frinn.custommachinery.api.crafting.IProcessor;
import fr.frinn.custommachinery.api.guielement.IMachineScreen;
import fr.frinn.custommachinery.api.machine.MachineStatus;
import fr.frinn.custommachinery.client.ClientHandler;
import fr.frinn.custommachinery.common.crafting.machine.MachineProcessor;
import fr.frinn.custommachinery.common.guielement.StatusGuiElement;
import fr.frinn.custommachinery.impl.guielement.AbstractGuiElementWidget;
import fr.frinn.custommachinery.impl.util.TextureInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class StatusGuiElementWidget
extends AbstractGuiElementWidget<StatusGuiElement> {
    public StatusGuiElementWidget(StatusGuiElement element, IMachineScreen screen) {
        super(element, screen, (Component)Component.literal((String)"Status"));
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        MachineStatus status = MachineStatus.IDLE;
        if (((StatusGuiElement)this.getElement()).getCore() == 0) {
            status = this.getScreen().getTile().getStatus();
        } else {
            MachineProcessor processor;
            IProcessor iProcessor = this.getScreen().getTile().getProcessor();
            if (iProcessor instanceof MachineProcessor && (processor = (MachineProcessor)iProcessor).getCores().size() >= ((StatusGuiElement)this.getElement()).getCore()) {
                status = processor.getCores().get(((StatusGuiElement)this.getElement()).getCore() - 1).getStatus();
            }
        }
        TextureInfo texture = switch (status) {
            case MachineStatus.RUNNING -> ((StatusGuiElement)this.getElement()).getRunningTexture();
            case MachineStatus.ERRORED -> ((StatusGuiElement)this.getElement()).getErroredTexture();
            default -> ((StatusGuiElement)this.getElement()).getIdleTexture();
        };
        ClientHandler.blit(graphics, texture, this.getX(), this.getY(), this.width, this.height);
    }

    @Override
    public List<Component> getTooltips() {
        if (!((StatusGuiElement)this.getElement()).getTooltips().isEmpty()) {
            return ((StatusGuiElement)this.getElement()).getTooltips();
        }
        ArrayList<Component> tooltips = new ArrayList<Component>();
        tooltips.add((Component)Component.translatable((String)("custommachinery.craftingstatus." + this.getScreen().getTile().getStatus().toString().toLowerCase(Locale.ENGLISH))));
        if (this.getScreen().getTile().getStatus() == MachineStatus.ERRORED) {
            tooltips.add(this.getScreen().getTile().getMessage());
        }
        return tooltips;
    }

    protected boolean clicked(double mouseX, double mouseY) {
        return false;
    }
}

