/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation;

import com.google.common.collect.ImmutableList;
import fr.frinn.custommachinery.client.screen.creation.tabs.EditTabButton;
import fr.frinn.custommachinery.client.screen.creation.tabs.MachineEditTab;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.TabButton;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class MachineEditTabNavigationBar
extends AbstractWidget
implements ContainerEventHandler {
    private static final int NO_TAB = -1;
    private static final int MAX_WIDTH = 400;
    private static final int HEIGHT = 24;
    private static final int MARGIN = 14;
    private static final Component USAGE_NARRATION = Component.translatable((String)"narration.tab_navigation.usage");
    private final GridLayout layout;
    private final TabManager tabManager;
    private final ImmutableList<MachineEditTab> tabs;
    private final ImmutableList<TabButton> tabButtons;
    @Nullable
    private GuiEventListener focused;
    private boolean isDragging;

    public MachineEditTabNavigationBar(int width, TabManager tabManager, Iterable<MachineEditTab> tabs, boolean inverted) {
        super(0, 0, width, 24, (Component)Component.empty());
        this.width = width;
        this.tabManager = tabManager;
        this.tabs = ImmutableList.copyOf(tabs);
        this.layout = new GridLayout(0, 0);
        this.layout.defaultCellSetting().alignHorizontallyCenter();
        ImmutableList.Builder builder = ImmutableList.builder();
        int i = 0;
        for (MachineEditTab tab : tabs) {
            builder.add((Object)((TabButton)this.layout.addChild((LayoutElement)new EditTabButton(tabManager, tab, 0, 24, inverted), 0, i++)));
        }
        this.tabButtons = builder.build();
    }

    public void setFocused(@Nullable GuiEventListener focused) {
        if (this.focused != null) {
            this.focused.setFocused(false);
        }
        if (focused != null) {
            focused.setFocused(true);
        }
        this.focused = focused;
        if (focused instanceof TabButton) {
            TabButton tabButton = (TabButton)focused;
            this.tabManager.setCurrentTab(tabButton.tab(), true);
        }
    }

    public void onClick(double mouseX, double mouseY, int button) {
        for (GuiEventListener guiEventListener : this.children()) {
            if (!guiEventListener.mouseClicked(mouseX, mouseY, button)) continue;
            this.setFocused(guiEventListener);
        }
    }

    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent event) {
        TabButton tabButton;
        if (!this.isFocused() && (tabButton = this.currentTabButton()) != null) {
            return ComponentPath.path((ContainerEventHandler)this, (ComponentPath)ComponentPath.leaf((GuiEventListener)tabButton));
        }
        return event instanceof FocusNavigationEvent.TabNavigation ? null : super.nextFocusPath(event);
    }

    public List<TabButton> children() {
        return this.tabButtons;
    }

    public void setDragging(boolean dragging) {
        this.isDragging = dragging;
    }

    public boolean isDragging() {
        return this.isDragging;
    }

    @Nullable
    public GuiEventListener getFocused() {
        return this.focused;
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return this.tabButtons.stream().map(AbstractWidget::narrationPriority).max(Comparator.naturalOrder()).orElse(NarratableEntry.NarrationPriority.NONE);
    }

    public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        Optional<TabButton> optional = this.tabButtons.stream().filter(AbstractWidget::isHovered).findFirst().or(() -> Optional.ofNullable(this.currentTabButton()));
        optional.ifPresent(tabButton -> {
            this.narrateListElementPosition(narrationElementOutput.nest(), (TabButton)tabButton);
            tabButton.updateNarration(narrationElementOutput);
        });
        if (this.isFocused()) {
            narrationElementOutput.add(NarratedElementType.USAGE, USAGE_NARRATION);
        }
    }

    protected void narrateListElementPosition(NarrationElementOutput narrationElementOutput, TabButton tabButton) {
        int i;
        if (this.tabs.size() > 1 && (i = this.tabButtons.indexOf((Object)tabButton)) != -1) {
            narrationElementOutput.add(NarratedElementType.POSITION, (Component)Component.translatable((String)"narrator.position.tab", (Object[])new Object[]{i + 1, this.tabs.size()}));
        }
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (TabButton tabButton : this.tabButtons) {
            tabButton.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public void setX(int x) {
        super.setX(x);
        this.arrangeElements();
    }

    public void setY(int y) {
        super.setY(y);
        this.arrangeElements();
    }

    public void arrangeElements() {
        int i = Math.min(400, this.width);
        int j = Mth.roundToward((int)(i / this.tabs.size()), (int)2);
        for (TabButton tabButton : this.tabButtons) {
            tabButton.setWidth(j);
        }
        this.layout.arrangeElements();
        this.layout.setX(this.getX());
        this.layout.setY(this.getY());
    }

    public void selectTab(int index, boolean playClickSound) {
        if (this.isFocused()) {
            this.setFocused((GuiEventListener)this.tabButtons.get(index));
        } else {
            this.tabManager.setCurrentTab((Tab)this.tabs.get(index), playClickSound);
        }
    }

    private int getNextTabIndex(int keycode) {
        int i;
        if (keycode >= 49 && keycode <= 57) {
            return keycode - 49;
        }
        if (keycode == 258 && (i = this.currentTabIndex()) != -1) {
            int j = Screen.hasShiftDown() ? i - 1 : i + 1;
            return Math.floorMod(j, this.tabs.size());
        }
        return -1;
    }

    private int currentTabIndex() {
        Tab tab = this.tabManager.getCurrentTab();
        int i = this.tabs.indexOf((Object)tab);
        return i != -1 ? i : -1;
    }

    @Nullable
    private TabButton currentTabButton() {
        int i = this.currentTabIndex();
        return i != -1 ? (TabButton)this.tabButtons.get(i) : null;
    }
}

