/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.client.screen.creation.tabs.MachineEditTab;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ImageWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class MachineTabManager
extends TabManager {
    private final MachineEditScreen parent;
    private GridLayout toolboxLayout;
    private ImageWidget toolboxBackground;

    public MachineTabManager(MachineEditScreen parent) {
        super(parent::addRenderableWidget, parent::removeWidget);
        this.parent = parent;
    }

    public void setTabArea(ScreenRectangle tabArea) {
        super.setTabArea(tabArea);
        if (this.toolboxLayout != null) {
            this.setToolboxPos();
        }
    }

    public void setCurrentTab(Tab tab, boolean playClickSound) {
        MachineEditTab editTab;
        Tab tab2 = this.getCurrentTab();
        if (tab2 instanceof MachineEditTab) {
            editTab = (MachineEditTab)tab2;
            editTab.closed();
            if (this.toolboxLayout != null) {
                this.toolboxLayout.visitWidgets(this.parent::removeWidget);
            }
            if (this.toolboxBackground != null) {
                this.parent.removeWidget((GuiEventListener)this.toolboxBackground);
            }
        }
        super.setCurrentTab(tab, playClickSound);
        if (tab instanceof MachineEditTab) {
            editTab = (MachineEditTab)tab;
            editTab.opened();
            if (!editTab.getToolButtons().isEmpty()) {
                this.setupToolbox(editTab.getToolButtons());
            }
        }
    }

    private void setupToolbox(List<AbstractWidget> toolButtons) {
        int columns = (int)Math.ceil((double)toolButtons.size() / 5.0);
        this.toolboxLayout = new GridLayout();
        GridLayout.RowHelper row = this.toolboxLayout.spacing(0).createRowHelper(columns);
        row.defaultCellSetting().paddingBottom(1).paddingRight(1).alignHorizontallyCenter().alignVerticallyMiddle();
        row.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.gui.toolbox"), Minecraft.getInstance().font), columns, row.newCellSettings().paddingBottom(5));
        toolButtons.forEach(arg_0 -> ((GridLayout.RowHelper)row).addChild(arg_0));
        this.toolboxLayout.arrangeElements();
        this.toolboxBackground = this.parent.addRenderableWidget(ImageWidget.sprite((int)(this.toolboxLayout.getWidth() + 10), (int)(this.toolboxLayout.getHeight() + 10), (ResourceLocation)CustomMachinery.rl("background")));
        this.toolboxBackground.active = false;
        this.toolboxLayout.visitWidgets(this.parent::addRenderableWidget);
        this.setToolboxPos();
    }

    private void setToolboxPos() {
        this.toolboxLayout.setPosition(this.parent.x - this.toolboxLayout.getWidth() - 8, this.parent.y + 85);
        this.toolboxBackground.setPosition(this.parent.x - this.toolboxLayout.getWidth() - 13, this.parent.y + 80);
    }
}

