/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.gui;

import fr.frinn.custommachinery.api.guielement.GuiElementType;
import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.guielement.IMachineScreen;
import fr.frinn.custommachinery.api.machine.ICustomMachine;
import fr.frinn.custommachinery.api.machine.MachineTile;
import fr.frinn.custommachinery.client.ClientHandler;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.client.screen.creation.gui.ElementConfigWidget;
import fr.frinn.custommachinery.client.screen.creation.gui.GuiElementBuilderRegistry;
import fr.frinn.custommachinery.client.screen.creation.gui.IGuiElementBuilder;
import fr.frinn.custommachinery.client.screen.creation.gui.MutableProperties;
import fr.frinn.custommachinery.client.screen.creation.gui.WidgetCompactor;
import fr.frinn.custommachinery.client.screen.creation.tabs.GuiTab;
import fr.frinn.custommachinery.client.screen.popup.ConfirmPopup;
import fr.frinn.custommachinery.common.guielement.BackgroundGuiElement;
import fr.frinn.custommachinery.common.init.CustomMachineBlock;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Comparators;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.impl.guielement.AbstractGuiElementWidget;
import fr.frinn.custommachinery.impl.guielement.GuiElementWidgetSupplierRegistry;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.lwjgl.glfw.GLFW;

public class GuiEditorWidget
extends AbstractWidget
implements ContainerEventHandler {
    private final MachineEditScreen parent;
    private final IMachineScreen dummyScreen = new DummyScreen();
    private final List<WidgetEditorWidget<?>> widgets = new ArrayList();
    private final Deque<Change> changes = new ArrayDeque<Change>();
    private final List<WidgetEditorWidget<?>> selected = new ArrayList();
    private final List<WidgetEditorWidget<?>> copied = new ArrayList();
    private final ElementConfigWidget configWidget;
    private boolean dragging = false;
    private boolean pasting = false;
    private Vector2d selectionBoxStart;
    private GuiEventListener focused;
    private static GridSettings gridSettings = new GridSettings(false, 10, 10, 0.5f);
    private static boolean showBackground = true;

    public GuiEditorWidget(MachineEditScreen parent, int x, int y, int width, int height, List<IGuiElement> baseElements) {
        super(x, y, width, height, (Component)Component.empty());
        this.parent = parent;
        baseElements.stream().sorted(Comparators.GUI_ELEMENTS_COMPARATOR.reversed()).forEach(this::addElement);
        this.configWidget = new ElementConfigWidget(this.getX() + this.getWidth(), this.getY(), 90, this.parent.ySize, this);
        this.configWidget.hide();
    }

    public void addElement(IGuiElement element) {
        if (!GuiElementWidgetSupplierRegistry.hasWidgetSupplier(element.getType()) || !GuiElementBuilderRegistry.hasBuilder(element.getType())) {
            return;
        }
        this.widgets.add(this.getWidget(element));
    }

    public void addCreatedElement(IGuiElement element) {
        if (!GuiElementWidgetSupplierRegistry.hasWidgetSupplier(element.getType()) || !GuiElementBuilderRegistry.hasBuilder(element.getType())) {
            return;
        }
        WidgetEditorWidget<IGuiElement> widget = this.getWidget(element);
        widget.setPosition(this.getX() + (this.getWidth() + widget.getWidth()) / 2, this.getY() + (this.getHeight() + widget.getHeight()) / 2);
        this.widgets.add(widget);
        this.setFocused((GuiEventListener)widget);
    }

    public <T extends IGuiElement> void config(WidgetEditorWidget<T> widget) {
        this.parent.openPopup(widget.builder.makeConfigPopup(this.parent, widget.properties, (IGuiElement)widget.widget.getElement(), widget::refreshWidget));
    }

    public void setChanged() {
        this.parent.setChanged();
    }

    public <T extends IGuiElement> List<WidgetEditorWidget<T>> getWidgets(GuiElementType<T> type, @Nullable String id) {
        return this.widgets.stream().filter(widget -> widget.builder.type() == type && (id == null || id.equals(widget.properties.getId()))).map(widget -> widget).toList();
    }

    public GridSettings getGridSettings() {
        return gridSettings;
    }

    public void setGridSettings(GridSettings settings) {
        gridSettings = settings;
    }

    public boolean shouldShowBackground() {
        return showBackground;
    }

    public void setShowBackground(boolean show) {
        showBackground = show;
    }

    public void changePriority(int delta) {
        GuiEventListener guiEventListener = this.getFocused();
        if (guiEventListener instanceof WidgetEditorWidget) {
            WidgetEditorWidget widget = (WidgetEditorWidget)guiEventListener;
            widget.properties.setPriority(widget.properties.getPriority() + delta);
            widget.refreshWidget(null);
            List<WidgetEditorWidget> sorted = this.widgets.stream().sorted(Comparator.comparingInt(w -> w.properties.getPriority())).toList();
            this.widgets.clear();
            this.widgets.addAll(sorted);
            this.setChanged();
        }
    }

    public void delete() {
        GuiEventListener guiEventListener = this.getFocused();
        if (guiEventListener instanceof WidgetEditorWidget) {
            WidgetEditorWidget widget = (WidgetEditorWidget)guiEventListener;
            ConfirmPopup popup = new ConfirmPopup(this.parent, 128, 96, () -> {
                this.memorizeChange(widget);
                this.copied.remove((Object)widget);
                this.widgets.remove((Object)widget);
                this.setFocused(null);
                this.parent.getBuilder().getGuiElements().remove(widget.widget.getElement());
                this.setChanged();
            });
            popup.title((Component)Component.translatable((String)"custommachinery.gui.popup.warning").withStyle(ChatFormatting.DARK_RED));
            popup.text(new Component[]{Component.translatable((String)"custommachinery.gui.creation.gui.delete.popup")});
            popup.cancelCallback(() -> this.parent.setFocused((GuiEventListener)this));
            this.parent.openPopup(popup);
        }
        if (!this.selected.isEmpty()) {
            ConfirmPopup popup = new ConfirmPopup(this.parent, 128, 96, () -> {
                GroupWidgetChange change = this.memorizeChange(new GroupWidgetChange());
                Iterator<WidgetEditorWidget<?>> iterator = this.selected.iterator();
                while (iterator.hasNext()) {
                    WidgetEditorWidget<?> widget = iterator.next();
                    change.add(widget);
                    this.copied.remove(widget);
                    this.widgets.remove(widget);
                    this.parent.getBuilder().getGuiElements().remove(widget.widget.getElement());
                    iterator.remove();
                }
                this.setChanged();
            });
            popup.title((Component)Component.translatable((String)"custommachinery.gui.popup.warning").withStyle(ChatFormatting.DARK_RED));
            popup.text(new Component[]{Component.translatable((String)"custommachinery.gui.creation.gui.delete.popup")});
            popup.cancelCallback(() -> this.parent.setFocused((GuiEventListener)this));
            this.parent.openPopup(popup);
        }
    }

    private <T extends IGuiElement> WidgetEditorWidget<T> getWidget(T element) {
        AbstractGuiElementWidget<? extends IGuiElement> widget = GuiElementWidgetSupplierRegistry.getWidgetSupplier(element.getType()).get(element, this.dummyScreen);
        IGuiElementBuilder<? extends IGuiElement> builder = GuiElementBuilderRegistry.getBuilder(element.getType());
        return new WidgetEditorWidget<IGuiElement>(widget, builder);
    }

    public <C extends Change> C memorizeChange(C change) {
        this.changes.addFirst(change);
        Tab tab = this.parent.getTabManager().getCurrentTab();
        if (tab instanceof GuiTab) {
            GuiTab guiTab = (GuiTab)tab;
            if (guiTab.revert != null) {
                guiTab.revert.active = true;
            }
        }
        return change;
    }

    public void memorizeChange(WidgetEditorWidget<?> widget) {
        this.memorizeChange(new SingleWidgetChange(widget));
    }

    public void revertChange() {
        if (this.changes.isEmpty()) {
            return;
        }
        this.changes.getFirst().revert();
        this.changes.removeFirst();
        Tab tab = this.parent.getTabManager().getCurrentTab();
        if (tab instanceof GuiTab) {
            GuiTab guiTab = (GuiTab)tab;
            if (guiTab.revert != null) {
                guiTab.revert.active = !this.changes.isEmpty();
            }
        }
    }

    public void copy() {
        this.copied.clear();
        GuiEventListener guiEventListener = this.focused;
        if (guiEventListener instanceof WidgetEditorWidget) {
            WidgetEditorWidget widget = (WidgetEditorWidget)guiEventListener;
            this.copied.add(widget);
        } else if (!this.selected.isEmpty()) {
            this.copied.addAll(this.selected);
        }
        guiEventListener = this.parent.getTabManager().getCurrentTab();
        if (guiEventListener instanceof GuiTab) {
            GuiTab guiTab = (GuiTab)guiEventListener;
            if (guiTab.paste != null) {
                guiTab.paste.active = !this.copied.isEmpty();
            }
        }
    }

    public void paste() {
        if (!this.copied.isEmpty()) {
            this.pasting = true;
        }
    }

    public void selectAll() {
        this.selected.clear();
        this.selected.addAll(this.widgets);
    }

    public void alignTop() {
        if (this.selected.isEmpty()) {
            return;
        }
        int y = this.selected.stream().mapToInt(AbstractWidget::getY).min().orElse(0);
        GroupWidgetChange change = this.memorizeChange(new GroupWidgetChange());
        this.selected.forEach(widget -> {
            change.add((WidgetEditorWidget<?>)((Object)widget));
            widget.setY(y);
        });
    }

    public void alignCenter() {
        if (this.selected.isEmpty()) {
            return;
        }
        int y = (int)this.selected.stream().mapToDouble(widget -> (double)widget.getY() + (double)widget.getHeight() / 2.0).average().orElse(0.0);
        GroupWidgetChange change = this.memorizeChange(new GroupWidgetChange());
        this.selected.forEach(widget -> {
            change.add((WidgetEditorWidget<?>)((Object)widget));
            widget.setY(y - (int)((double)widget.getHeight() / 2.0));
        });
    }

    public void alignBottom() {
        if (this.selected.isEmpty()) {
            return;
        }
        int y = this.selected.stream().mapToInt(widget -> widget.getY() + widget.getHeight()).max().orElse(0);
        GroupWidgetChange change = this.memorizeChange(new GroupWidgetChange());
        this.selected.forEach(widget -> {
            change.add((WidgetEditorWidget<?>)((Object)widget));
            widget.setY(y - widget.getHeight());
        });
    }

    public void alignLeft() {
        if (this.selected.isEmpty()) {
            return;
        }
        int x = this.selected.stream().mapToInt(AbstractWidget::getX).min().orElse(0);
        GroupWidgetChange change = this.memorizeChange(new GroupWidgetChange());
        this.selected.forEach(widget -> {
            change.add((WidgetEditorWidget<?>)((Object)widget));
            widget.setX(x);
        });
    }

    public void alignMiddle() {
        if (this.selected.isEmpty()) {
            return;
        }
        int x = (int)this.selected.stream().mapToDouble(widget -> (double)widget.getX() + (double)widget.getWidth() / 2.0).min().orElse(0.0);
        GroupWidgetChange change = this.memorizeChange(new GroupWidgetChange());
        this.selected.forEach(widget -> {
            change.add((WidgetEditorWidget<?>)((Object)widget));
            widget.setX(x - (int)((double)widget.getWidth() / 2.0));
        });
    }

    public void alignRight() {
        if (this.selected.isEmpty()) {
            return;
        }
        int x = this.selected.stream().mapToInt(widget -> widget.getX() + widget.getWidth()).max().orElse(0);
        GroupWidgetChange change = this.memorizeChange(new GroupWidgetChange());
        this.selected.forEach(widget -> {
            change.add((WidgetEditorWidget<?>)((Object)widget));
            widget.setX(x - widget.getWidth());
        });
    }

    public void centerHorizontally() {
        GuiEventListener guiEventListener = this.focused;
        if (guiEventListener instanceof WidgetEditorWidget) {
            WidgetEditorWidget widget2 = (WidgetEditorWidget)guiEventListener;
            this.memorizeChange(widget2);
            widget2.setX(this.getX() + this.getWidth() / 2 - widget2.getWidth() / 2);
        } else if (!this.selected.isEmpty()) {
            GroupWidgetChange change = this.memorizeChange(new GroupWidgetChange());
            int minX = this.selected.stream().mapToInt(AbstractWidget::getX).min().orElse(0);
            int maxX = this.selected.stream().mapToInt(widget -> widget.getX() + widget.getWidth()).max().orElse(0);
            this.selected.forEach(widget -> {
                change.add((WidgetEditorWidget<?>)((Object)widget));
                widget.setX(this.getX() + this.getWidth() / 2 - (maxX - minX) / 2 + widget.getX() - minX);
            });
        }
    }

    public void centerVertically() {
        GuiEventListener guiEventListener = this.focused;
        if (guiEventListener instanceof WidgetEditorWidget) {
            WidgetEditorWidget widget2 = (WidgetEditorWidget)guiEventListener;
            this.memorizeChange(widget2);
            widget2.setY(this.getY() + this.getHeight() / 2 - widget2.getHeight() / 2);
        } else if (!this.selected.isEmpty()) {
            GroupWidgetChange change = this.memorizeChange(new GroupWidgetChange());
            int minY = this.selected.stream().mapToInt(AbstractWidget::getY).min().orElse(0);
            int maxY = this.selected.stream().mapToInt(widget -> widget.getY() + widget.getHeight()).max().orElse(0);
            this.selected.forEach(widget -> {
                change.add((WidgetEditorWidget<?>)((Object)widget));
                widget.setY(this.getY() + this.getHeight() / 2 - (maxY - minY) / 2 + widget.getY() - minY);
            });
        }
    }

    public void compact() {
        if (this.selected.isEmpty()) {
            return;
        }
        GroupWidgetChange change = this.memorizeChange(new GroupWidgetChange());
        WidgetCompactor.compact(new ArrayList(this.selected), change::add, 15, 1);
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        Tab tab;
        BackgroundGuiElement background;
        graphics.fill(this.getX() - 2, this.getY() - 2, this.getX() + this.getWidth() + 2, this.getY() + this.getHeight() + 2, FastColor.ARGB32.color((int)255, (int)0, (int)0, (int)0));
        graphics.fill(this.getX() - 1, this.getY() - 1, this.getX() + this.getWidth() + 1, this.getY() + this.getHeight() + 1, FastColor.ARGB32.color((int)255, (int)198, (int)198, (int)198));
        if (this.shouldShowBackground() && (background = (BackgroundGuiElement)this.parent.getBuilder().getGuiElements().stream().filter(element -> element instanceof BackgroundGuiElement).map(element -> (BackgroundGuiElement)element).findFirst().orElse(null)) != null && background.getTexture() != null) {
            ClientHandler.blit(graphics, background.getTexture(), this.getX(), this.getY(), this.width, this.height);
        }
        if (this.getGridSettings() != null && this.getGridSettings().enabled()) {
            for (int x = this.getX() + this.getGridSettings().xSpacing(); x < this.getX() + this.getWidth(); x += this.getGridSettings().xSpacing()) {
                graphics.fill(x, this.getY(), x + 1, this.getY() + this.getHeight(), FastColor.ARGB32.color((int)((int)(255.0f * this.getGridSettings().opacity())), (int)85, (int)85, (int)85));
            }
            for (int y = this.getY() + this.getGridSettings().ySpacing(); y < this.getY() + this.getHeight(); y += this.getGridSettings().ySpacing()) {
                graphics.fill(this.getX(), y, this.getX() + this.getWidth(), y + 1, FastColor.ARGB32.color((int)((int)(255.0f * this.getGridSettings().opacity())), (int)85, (int)85, (int)85));
            }
        }
        if (this.selectionBoxStart != null && this.isDragging()) {
            graphics.renderOutline((int)Math.min(this.selectionBoxStart.x(), (double)mouseX), (int)Math.min(this.selectionBoxStart.y(), (double)mouseY), (int)Math.abs(this.selectionBoxStart.x() - (double)mouseX), (int)Math.abs(this.selectionBoxStart.y() - (double)mouseY), FastColor.ARGB32.color((int)255, (int)0, (int)0, (int)255));
        }
        if ((tab = this.parent.getTabManager().getCurrentTab()) instanceof GuiTab) {
            GuiTab guiTab = (GuiTab)tab;
            guiTab.enableAlignButtons(!this.selected.isEmpty());
            if (guiTab.copy != null) {
                boolean bl = guiTab.copy.active = this.focused != null || !this.selected.isEmpty();
            }
            if (guiTab.centerHorizontally != null) {
                boolean bl = guiTab.centerHorizontally.active = this.focused != null || !this.selected.isEmpty();
            }
            if (guiTab.centerVertically != null) {
                guiTab.centerVertically.active = this.focused != null || !this.selected.isEmpty();
            }
        }
        this.widgets.forEach(widget -> widget.render(graphics, mouseX, mouseY, partialTick));
        this.configWidget.renderWidget(graphics, mouseX, mouseY, partialTick);
        if (this.pasting && this.isMouseOver(mouseX, mouseY)) {
            GLFW.glfwSetCursor((long)Minecraft.getInstance().getWindow().getWindow(), (long)GLFW.glfwCreateStandardCursor((int)221188));
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public void setX(int x) {
        super.setX(x);
        this.widgets.forEach(widget -> widget.setX(x + widget.widget.getElement().getX()));
        this.configWidget.setX(this.getX() + this.getWidth() + 20);
    }

    public void setY(int y) {
        super.setY(y);
        this.widgets.forEach(widget -> widget.setY(y + widget.widget.getElement().getY()));
        this.configWidget.setY(this.getY() - 5);
    }

    public List<? extends GuiEventListener> children() {
        return this.widgets;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setDragging(boolean isDragging) {
        this.dragging = isDragging;
    }

    @Nullable
    public GuiEventListener getFocused() {
        return this.focused;
    }

    public void setFocused(@Nullable GuiEventListener focused) {
        if (Screen.hasControlDown() && focused instanceof WidgetEditorWidget) {
            WidgetEditorWidget widget = (WidgetEditorWidget)focused;
            this.selected.add(widget);
            if (this.focused != null) {
                this.focused.setFocused(false);
                GuiEventListener guiEventListener = this.focused;
                if (guiEventListener instanceof WidgetEditorWidget) {
                    WidgetEditorWidget focusedWidget = (WidgetEditorWidget)guiEventListener;
                    this.selected.add(focusedWidget);
                }
            }
            this.focused = null;
            return;
        }
        if (this.focused != null) {
            this.focused.setFocused(false);
        }
        this.focused = focused;
        if (focused != null) {
            focused.setFocused(true);
        }
        if (focused instanceof WidgetEditorWidget) {
            WidgetEditorWidget widget = (WidgetEditorWidget)focused;
            this.configWidget.show(widget);
        } else {
            this.configWidget.hide();
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.configWidget.isMouseOver(mouseX, mouseY)) {
            this.configWidget.mouseClicked(mouseX, mouseY, button);
            return true;
        }
        if (!this.isMouseOver(mouseX, mouseY) || button != 0) {
            return false;
        }
        if (this.pasting && !this.copied.isEmpty()) {
            this.pasting = false;
            int minX = this.copied.stream().mapToInt(AbstractWidget::getX).min().orElse(0);
            int minY = this.copied.stream().mapToInt(AbstractWidget::getY).min().orElse(0);
            GroupWidgetChange change = this.memorizeChange(new GroupWidgetChange());
            this.copied.forEach(widget -> {
                WidgetEditorWidget copy = widget.copy();
                copy.setPosition((int)(mouseX + (double)widget.getX() - (double)minX), (int)(mouseY + (double)widget.getY() - (double)minY));
                this.widgets.add(copy);
                change.add(new AddedWidgetChange(copy));
            });
            this.copied.clear();
            Tab tab = this.parent.getTabManager().getCurrentTab();
            if (tab instanceof GuiTab) {
                GuiTab guiTab = (GuiTab)tab;
                if (guiTab.paste != null) {
                    guiTab.paste.active = false;
                }
            }
            this.selected.clear();
            this.setFocused(null);
            GLFW.glfwSetCursor((long)Minecraft.getInstance().getWindow().getWindow(), (long)GLFW.glfwCreateStandardCursor((int)221185));
            return true;
        }
        for (GuiEventListener guiEventListener : this.widgets.reversed()) {
            WidgetEditorWidget widget2;
            if (!guiEventListener.mouseClicked(mouseX, mouseY, button)) continue;
            if (guiEventListener instanceof WidgetEditorWidget && this.selected.contains((Object)(widget2 = (WidgetEditorWidget)guiEventListener))) {
                this.setDragging(true);
                return true;
            }
            this.setFocused(guiEventListener);
            this.setDragging(true);
            this.selected.clear();
            return true;
        }
        this.setFocused(null);
        this.setDragging(true);
        this.selected.clear();
        this.selectionBoxStart = new Vector2d(mouseX, mouseY);
        return true;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.setDragging(false);
        if (this.configWidget.isMouseOver(mouseX, mouseY)) {
            this.configWidget.mouseReleased(mouseX, mouseY, button);
            return true;
        }
        if (this.selectionBoxStart != null) {
            Rect2i selectionBox = new Rect2i((int)Math.min(this.selectionBoxStart.x(), mouseX), (int)Math.min(this.selectionBoxStart.y(), mouseY), (int)Math.abs(this.selectionBoxStart.x() - mouseX), (int)Math.abs(this.selectionBoxStart.y() - mouseY));
            this.widgets.stream().filter(widget -> ClientHandler.isOverlapping(selectionBox, new Rect2i(widget.getX(), widget.getY(), widget.getWidth(), widget.getHeight()))).sorted(Comparator.comparingInt(widget -> widget.getX() * 1000 + widget.getY())).forEach(this.selected::add);
            this.selectionBoxStart = null;
        }
        if (this.getFocused() != null) {
            return this.getFocused().mouseReleased(mouseX, mouseY, button);
        }
        if (!this.selected.isEmpty()) {
            GroupWidgetChange change = new GroupWidgetChange();
            this.selected.forEach(widget -> {
                Change patt0$temp;
                widget.mouseReleased(mouseX, mouseY, button);
                if (!this.changes.isEmpty() && (patt0$temp = this.changes.getFirst()) instanceof SingleWidgetChange) {
                    SingleWidgetChange singleChange = (SingleWidgetChange)patt0$temp;
                    if (singleChange.widget == widget) {
                        change.add(this.changes.removeFirst());
                    }
                }
            });
            if (change.hasChanges()) {
                this.memorizeChange(change);
            }
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.configWidget.isMouseOver(mouseX, mouseY)) {
            this.configWidget.mouseDragged(mouseX, mouseY, button, dragX, dragY);
            return true;
        }
        if (this.isDragging() && button == 0) {
            if (this.getFocused() != null) {
                return this.getFocused().mouseDragged(mouseX, mouseY, button, dragX, dragY);
            }
            if (!this.selected.isEmpty()) {
                this.selected.forEach(widget -> {
                    widget.dragType = DragType.DEFAULT;
                    widget.mouseDragged(mouseX, mouseY, button, dragX, dragY);
                });
                return true;
            }
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        String key = GLFW.glfwGetKeyName((int)keyCode, (int)scanCode);
        if (key != null && (modifiers & 2) != 0) {
            switch (key) {
                case "z": {
                    this.revertChange();
                    break;
                }
                case "c": {
                    this.copy();
                    break;
                }
                case "v": {
                    this.paste();
                    break;
                }
                case "a": {
                    this.selectAll();
                }
            }
            return true;
        }
        if (!this.selected.isEmpty()) {
            int move = Screen.hasShiftDown() ? 5 : (Screen.hasControlDown() ? 10 : 1);
            GroupWidgetChange change = new GroupWidgetChange();
            for (WidgetEditorWidget<?> widget : this.selected) {
                boolean moved;
                if (!(moved = (switch (keyCode) {
                    case 263 -> {
                        change.add(widget);
                        widget.setX(Math.max(widget.getX() - move, this.getX()));
                        yield true;
                    }
                    case 262 -> {
                        change.add(widget);
                        widget.setX(Math.min(widget.getX() + move, this.getX() + this.getWidth()));
                        yield true;
                    }
                    case 265 -> {
                        change.add(widget);
                        widget.setY(Math.max(widget.getY() - move, this.getY()));
                        yield true;
                    }
                    case 264 -> {
                        change.add(widget);
                        widget.setY(Math.min(widget.getY() + move, this.getY() + this.getHeight()));
                        yield true;
                    }
                    default -> false;
                }))) continue;
                this.setChanged();
            }
            if (keyCode == 261) {
                this.delete();
            }
            if (change.hasChanges()) {
                this.memorizeChange(change);
            }
            return true;
        }
        if (this.getFocused() != null && this.getFocused().keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        return this.configWidget.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (this.getFocused() != null && this.getFocused().keyReleased(keyCode, scanCode, modifiers)) {
            return true;
        }
        return this.configWidget.keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (this.getFocused() != null && this.getFocused().charTyped(codePoint, modifiers)) {
            return true;
        }
        return this.configWidget.charTyped(codePoint, modifiers);
    }

    private class DummyScreen
    implements IMachineScreen {
        private final MachineTile dummy = new CustomMachineTile(BlockPos.ZERO, ((CustomMachineBlock)((Object)Registration.CUSTOM_MACHINE_BLOCK.get())).defaultBlockState());

        private DummyScreen() {
        }

        @Override
        public int getX() {
            return GuiEditorWidget.this.getX();
        }

        @Override
        public int getY() {
            return GuiEditorWidget.this.getY();
        }

        @Override
        public int getWidth() {
            return GuiEditorWidget.this.getWidth();
        }

        @Override
        public int getHeight() {
            return GuiEditorWidget.this.getHeight();
        }

        @Override
        public MachineTile getTile() {
            return this.dummy;
        }

        @Override
        public ICustomMachine getMachine() {
            return this.dummy.getMachine();
        }
    }

    public class WidgetEditorWidget<T extends IGuiElement>
    extends AbstractWidget {
        private final IGuiElementBuilder<T> builder;
        private final MutableProperties properties;
        private AbstractGuiElementWidget<T> widget;
        private DragType dragType;
        private double dragX;
        private double dragY;

        public WidgetEditorWidget(AbstractGuiElementWidget<T> widget, IGuiElementBuilder<T> builder) {
            super(widget.getX(), widget.getY(), widget.getWidth(), widget.getHeight(), widget.getMessage());
            this.dragType = DragType.NONE;
            this.dragX = 0.0;
            this.dragY = 0.0;
            this.widget = widget;
            this.builder = builder;
            this.properties = new MutableProperties(widget.getElement().getProperties());
        }

        public IGuiElementBuilder<T> getBuilder() {
            return this.builder;
        }

        public MutableProperties getProperties() {
            return this.properties;
        }

        public void refreshWidget(@Nullable T from) {
            T element = this.widget.getElement();
            T newElement = from != null ? from : this.builder.make(this.properties.build(), element);
            this.widget = GuiElementWidgetSupplierRegistry.getWidgetSupplier(element.getType()).get((IGuiElement)newElement, GuiEditorWidget.this.dummyScreen);
            this.widget.setPosition(this.getX(), this.getY());
            this.width = this.widget.getWidth();
            this.height = this.widget.getHeight();
            GuiEditorWidget.this.parent.getBuilder().getGuiElements().remove(element);
            GuiEditorWidget.this.parent.getBuilder().getGuiElements().add((IGuiElement)newElement);
        }

        public WidgetEditorWidget<T> copy() {
            MutableProperties copyProperties = new MutableProperties(this.properties.build());
            String id = this.properties.getId();
            AtomicReference<String> copyId = new AtomicReference<String>(Utils.incrementLastNumber(id));
            while (GuiEditorWidget.this.widgets.stream().anyMatch(widget -> {
                if (widget == this || widget.builder.type() != this.builder.type()) {
                    return false;
                }
                return widget.properties.getId().equals(copyId.get());
            })) {
                copyId.set(Utils.incrementLastNumber(copyId.get()));
            }
            copyProperties.setId(copyId.get());
            T element = this.builder.make(copyProperties.build(), this.widget.getElement());
            return GuiEditorWidget.this.getWidget(element);
        }

        private DragType getDragType(double mouseX, double mouseY) {
            if (GuiEditorWidget.this.selected.stream().anyMatch(widget -> widget.isMouseOver(mouseX, mouseY))) {
                return DragType.DEFAULT;
            }
            if (!this.isMouseOver(mouseX, mouseY)) {
                return DragType.NONE;
            }
            if (mouseX >= (double)this.getX() && mouseX <= (double)(this.getX() + 1) && mouseY >= (double)this.getY() && mouseY <= (double)(this.getY() + this.getHeight())) {
                return DragType.LEFT_RESIZE;
            }
            if (mouseX >= (double)(this.getX() + this.getWidth() - 1) && mouseX <= (double)(this.getX() + this.getWidth()) && mouseY >= (double)this.getY() && mouseY <= (double)(this.getY() + this.getHeight())) {
                return DragType.RIGHT_RESIZE;
            }
            if (mouseX >= (double)this.getX() && mouseX <= (double)(this.getX() + this.getWidth()) && mouseY >= (double)this.getY() && mouseY <= (double)(this.getY() + 1)) {
                return DragType.UP_RESIZE;
            }
            if (mouseX >= (double)this.getX() && mouseX <= (double)(this.getX() + this.getWidth()) && mouseY >= (double)(this.getY() + this.getHeight() - 1) && mouseY <= (double)(this.getY() + this.getHeight())) {
                return DragType.DOWN_RESIZE;
            }
            return DragType.DEFAULT;
        }

        private void checkCursorShape(int mouseX, int mouseY) {
            if (this.dragType != DragType.NONE) {
                return;
            }
            switch (this.getDragType(mouseX, mouseY).ordinal()) {
                case 4: 
                case 5: {
                    GLFW.glfwSetCursor((long)Minecraft.getInstance().getWindow().getWindow(), (long)GLFW.glfwCreateStandardCursor((int)221189));
                    break;
                }
                case 2: 
                case 3: {
                    GLFW.glfwSetCursor((long)Minecraft.getInstance().getWindow().getWindow(), (long)GLFW.glfwCreateStandardCursor((int)221190));
                    break;
                }
                case 1: {
                    GLFW.glfwSetCursor((long)Minecraft.getInstance().getWindow().getWindow(), (long)GLFW.glfwCreateStandardCursor((int)221193));
                    break;
                }
                default: {
                    GLFW.glfwSetCursor((long)Minecraft.getInstance().getWindow().getWindow(), (long)GLFW.glfwCreateStandardCursor((int)221185));
                }
            }
        }

        protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            graphics.pose().pushPose();
            switch (this.dragType.ordinal()) {
                case 1: {
                    graphics.pose().translate(this.dragX, this.dragY, 0.0);
                    break;
                }
                case 4: {
                    graphics.pose().translate((double)(-this.getX()) * -this.dragX / (double)this.getWidth() + this.dragX, 0.0, 0.0);
                    graphics.pose().scale((float)(-this.dragX / (double)this.getWidth()) + 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 5: {
                    graphics.pose().translate((double)(-this.getX()) * this.dragX / (double)this.getWidth(), 0.0, 0.0);
                    graphics.pose().scale((float)(this.dragX / (double)this.getWidth()) + 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 2: {
                    graphics.pose().translate(0.0, (double)(-this.getY()) * -this.dragY / (double)this.getHeight() + this.dragY, 0.0);
                    graphics.pose().scale(1.0f, (float)(-this.dragY / (double)this.getHeight()) + 1.0f, 1.0f);
                    break;
                }
                case 3: {
                    graphics.pose().translate(0.0, (double)(-this.getY()) * this.dragY / (double)this.getHeight(), 0.0);
                    graphics.pose().scale(1.0f, (float)(this.dragY / (double)this.getHeight()) + 1.0f, 1.0f);
                }
            }
            boolean highlighted = false;
            if (this.isFocused()) {
                graphics.fill(this.getX() - 1, this.getY() - 1, this.getX() + this.getWidth() + 1, this.getY() + this.getHeight() + 1, FastColor.ARGB32.color((int)255, (int)255, (int)0, (int)0));
                graphics.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), FastColor.ARGB32.color((int)255, (int)198, (int)198, (int)198));
                this.checkCursorShape(mouseX, mouseY);
                highlighted = true;
            } else if (GuiEditorWidget.this.selected.contains((Object)this)) {
                graphics.fill(this.getX() - 1, this.getY() - 1, this.getX() + this.getWidth() + 1, this.getY() + this.getHeight() + 1, FastColor.ARGB32.color((int)255, (int)0, (int)0, (int)255));
                graphics.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), FastColor.ARGB32.color((int)255, (int)198, (int)198, (int)198));
                this.checkCursorShape(mouseX, mouseY);
                highlighted = true;
            }
            this.widget.render(graphics, Integer.MAX_VALUE, Integer.MAX_VALUE, partialTick);
            if (GuiEditorWidget.this.copied.contains((Object)this)) {
                int offset = (int)(System.currentTimeMillis() / 100L % 100L);
                if (highlighted) {
                    ClientHandler.drawDottedRect(graphics, this.getX() - 2, this.getY() - 2, this.getWidth() + 3, this.getHeight() + 3, FastColor.ARGB32.color((int)255, (int)0, (int)255, (int)0), 4, 4, offset);
                } else {
                    ClientHandler.drawDottedRect(graphics, this.getX() - 1, this.getY() - 1, this.getWidth() + 1, this.getHeight() + 1, FastColor.ARGB32.color((int)255, (int)0, (int)255, (int)0), 4, 4, offset);
                }
            }
            graphics.pose().popPose();
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }

        public void setX(int x) {
            super.setX(x);
            this.properties.setX(x - GuiEditorWidget.this.getX());
            this.refreshWidget(null);
            if (GuiEditorWidget.this.focused == this) {
                GuiEditorWidget.this.configWidget.show(this);
            }
        }

        public void setY(int y) {
            super.setY(y);
            this.properties.setY(y - GuiEditorWidget.this.getY());
            this.refreshWidget(null);
            if (GuiEditorWidget.this.focused == this) {
                GuiEditorWidget.this.configWidget.show(this);
            }
        }

        public void setWidth(int width) {
            super.setWidth(width);
            this.properties.setWidth(width);
            this.refreshWidget(null);
            if (GuiEditorWidget.this.focused == this) {
                GuiEditorWidget.this.configWidget.show(this);
            }
        }

        public void setHeight(int height) {
            this.height = height;
            this.properties.setHeight(height);
            this.refreshWidget(null);
            if (GuiEditorWidget.this.focused == this) {
                GuiEditorWidget.this.configWidget.show(this);
            }
        }

        public void onClick(double mouseX, double mouseY, int button) {
            this.dragType = this.getDragType(mouseX, mouseY);
            this.checkCursorShape((int)mouseX, (int)mouseY);
        }

        protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
            switch (this.dragType.ordinal()) {
                case 1: {
                    if (GuiEditorWidget.this.focused == this) {
                        this.dragX = Mth.clamp((double)(this.dragX + dragX), (double)(GuiEditorWidget.this.getX() - this.getX()), (double)(GuiEditorWidget.this.getX() + GuiEditorWidget.this.getWidth() - this.getX() - this.getWidth()));
                        this.dragY = Mth.clamp((double)(this.dragY + dragY), (double)(GuiEditorWidget.this.getY() - this.getY()), (double)(GuiEditorWidget.this.getY() + GuiEditorWidget.this.getHeight() - this.getY() - this.getHeight()));
                        break;
                    }
                    if (!GuiEditorWidget.this.selected.contains((Object)this)) break;
                    double minDragX = GuiEditorWidget.this.selected.stream().mapToDouble(AbstractWidget::getX).min().orElse(0.0);
                    double minDragY = GuiEditorWidget.this.selected.stream().mapToDouble(AbstractWidget::getY).min().orElse(0.0);
                    double maxDragX = GuiEditorWidget.this.selected.stream().mapToDouble(widget -> widget.getX() + widget.getWidth()).max().orElse(0.0);
                    double maxDragY = GuiEditorWidget.this.selected.stream().mapToDouble(widget -> widget.getY() + widget.getHeight()).max().orElse(0.0);
                    this.dragX = Mth.clamp((double)(this.dragX + dragX), (double)((double)GuiEditorWidget.this.getX() - minDragX), (double)((double)(GuiEditorWidget.this.getX() + GuiEditorWidget.this.getWidth()) - maxDragX));
                    this.dragY = Mth.clamp((double)(this.dragY + dragY), (double)((double)GuiEditorWidget.this.getY() - minDragY), (double)((double)(GuiEditorWidget.this.getY() + GuiEditorWidget.this.getHeight()) - maxDragY));
                    break;
                }
                case 2: 
                case 4: {
                    this.dragX = Mth.clamp((double)(this.dragX + dragX), (double)(GuiEditorWidget.this.getX() - this.getX()), (double)(GuiEditorWidget.this.getX() + GuiEditorWidget.this.getWidth() - this.getX() - this.getWidth()));
                    this.dragY = Mth.clamp((double)(this.dragY + dragY), (double)(GuiEditorWidget.this.getY() - this.getY()), (double)(GuiEditorWidget.this.getY() + GuiEditorWidget.this.getHeight() - this.getY() - this.getHeight()));
                    break;
                }
                case 5: {
                    this.dragX = Mth.clamp((double)(this.dragX + dragX), (double)(-this.getWidth()), (double)(GuiEditorWidget.this.getX() + GuiEditorWidget.this.getWidth() - this.getX() - this.getWidth()));
                    break;
                }
                case 3: {
                    this.dragY = Mth.clamp((double)(this.dragY + dragY), (double)(-this.getHeight()), (double)(GuiEditorWidget.this.getY() + GuiEditorWidget.this.getHeight() - this.getY() - this.getHeight()));
                }
            }
        }

        public void onRelease(double mouseX, double mouseY) {
            if (this.dragX == 0.0 && this.dragY == 0.0) {
                this.dragType = DragType.NONE;
                return;
            }
            switch (this.dragType.ordinal()) {
                case 1: {
                    GuiEditorWidget.this.memorizeChange(this);
                    this.setX(this.getX() + (int)this.dragX);
                    this.setY(this.getY() + (int)this.dragY);
                    break;
                }
                case 4: {
                    GuiEditorWidget.this.memorizeChange(this);
                    this.setX(this.getX() + (int)this.dragX);
                    this.setWidth(this.getWidth() - (int)this.dragX);
                    break;
                }
                case 5: {
                    GuiEditorWidget.this.memorizeChange(this);
                    this.setWidth(this.getWidth() + (int)this.dragX);
                    break;
                }
                case 2: {
                    GuiEditorWidget.this.memorizeChange(this);
                    this.setY(this.getY() + (int)this.dragY);
                    this.setHeight(this.getHeight() - (int)this.dragY);
                    break;
                }
                case 3: {
                    GuiEditorWidget.this.memorizeChange(this);
                    this.setHeight(this.getHeight() + (int)this.dragY);
                }
            }
            GuiEditorWidget.this.setChanged();
            this.dragType = DragType.NONE;
            this.dragX = 0.0;
            this.dragY = 0.0;
            GLFW.glfwSetCursor((long)Minecraft.getInstance().getWindow().getWindow(), (long)GLFW.glfwCreateStandardCursor((int)221185));
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            boolean moved;
            int move = Screen.hasShiftDown() ? 5 : (Screen.hasControlDown() ? 10 : 1);
            switch (keyCode) {
                case 263: {
                    GuiEditorWidget.this.memorizeChange(this);
                    this.setX(Math.max(this.getX() - move, GuiEditorWidget.this.getX()));
                    boolean bl = true;
                    break;
                }
                case 262: {
                    GuiEditorWidget.this.memorizeChange(this);
                    this.setX(Math.min(this.getX() + move, GuiEditorWidget.this.getX() + GuiEditorWidget.this.getWidth()));
                    boolean bl = true;
                    break;
                }
                case 265: {
                    GuiEditorWidget.this.memorizeChange(this);
                    this.setY(Math.max(this.getY() - move, GuiEditorWidget.this.getY()));
                    boolean bl = true;
                    break;
                }
                case 264: {
                    GuiEditorWidget.this.memorizeChange(this);
                    this.setY(Math.min(this.getY() + move, GuiEditorWidget.this.getY() + GuiEditorWidget.this.getHeight()));
                    boolean bl = true;
                    break;
                }
                case 261: {
                    GuiEditorWidget.this.delete();
                    boolean bl = true;
                    break;
                }
                default: {
                    boolean bl = moved = false;
                }
            }
            if (moved) {
                GuiEditorWidget.this.setChanged();
            }
            return moved;
        }
    }

    public record GridSettings(boolean enabled, int xSpacing, int ySpacing, float opacity) {
    }

    public class SingleWidgetChange
    implements Change {
        private final WidgetEditorWidget<?> widget;
        private final int x;
        private final int y;
        private final int width;
        private final int height;

        public SingleWidgetChange(WidgetEditorWidget<?> widget) {
            this.widget = widget;
            this.x = widget.getX();
            this.y = widget.getY();
            this.width = widget.getWidth();
            this.height = widget.getHeight();
        }

        public SingleWidgetChange(WidgetEditorWidget<?> widget, int x, int y, int width, int height) {
            this.widget = widget;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        @Override
        public void revert() {
            if (!GuiEditorWidget.this.widgets.contains(this.widget)) {
                GuiEditorWidget.this.widgets.add(this.widget);
                this.widget.refreshWidget(null);
            } else {
                if (this.widget.getX() != this.x) {
                    this.widget.setX(this.x);
                }
                if (this.widget.getY() != this.y) {
                    this.widget.setY(this.y);
                }
                if (this.widget.getWidth() != this.width) {
                    this.widget.setWidth(this.width);
                }
                if (this.widget.getHeight() != this.height) {
                    this.widget.setHeight(this.height);
                }
            }
        }
    }

    public static interface Change {
        public void revert();
    }

    public class GroupWidgetChange
    implements Change {
        private final List<Change> changes;

        public GroupWidgetChange(List<Change> changes) {
            this.changes = changes;
        }

        public GroupWidgetChange() {
            this.changes = new ArrayList<Change>();
        }

        public void add(Change change) {
            this.changes.add(change);
        }

        public void add(WidgetEditorWidget<?> widget) {
            this.changes.add(new SingleWidgetChange(widget));
        }

        public boolean hasChanges() {
            return !this.changes.isEmpty();
        }

        @Override
        public void revert() {
            this.changes.forEach(Change::revert);
            GuiEditorWidget.this.setFocused(null);
        }
    }

    private static enum DragType {
        NONE,
        DEFAULT,
        UP_RESIZE,
        DOWN_RESIZE,
        LEFT_RESIZE,
        RIGHT_RESIZE;

    }

    public class AddedWidgetChange
    implements Change {
        private final WidgetEditorWidget<?> widget;

        private AddedWidgetChange(WidgetEditorWidget<?> widget) {
            this.widget = widget;
        }

        @Override
        public void revert() {
            GuiEditorWidget.this.copied.remove(this.widget);
            GuiEditorWidget.this.widgets.remove(this.widget);
            GuiEditorWidget.this.parent.getBuilder().getGuiElements().remove(this.widget.widget.getElement());
            GuiEditorWidget.this.setChanged();
        }
    }
}

