/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.gui;

import fr.frinn.custommachinery.client.screen.creation.gui.GuiEditorWidget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractWidget;

public class WidgetCompactor {
    public static void compact(List<GuiEditorWidget.WidgetEditorWidget<?>> widgets, Consumer<GuiEditorWidget.WidgetEditorWidget<?>> change, int tolerance, int padding) {
        int r;
        widgets.sort(Comparator.comparingInt(AbstractWidget::getY).thenComparingInt(AbstractWidget::getX));
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        for (GuiEditorWidget.WidgetEditorWidget<?> widget : widgets) {
            minX = Math.min(minX, widget.getX());
            minY = Math.min(minY, widget.getY());
        }
        List<Integer> columns = WidgetCompactor.clusterValues(WidgetCompactor.extract(widgets, true), tolerance);
        List<Integer> rows = WidgetCompactor.clusterValues(WidgetCompactor.extract(widgets, false), tolerance);
        int numCols = columns.size();
        int numRows = rows.size();
        GuiEditorWidget.WidgetEditorWidget[][] grid = new GuiEditorWidget.WidgetEditorWidget[numRows][numCols];
        for (GuiEditorWidget.WidgetEditorWidget<?> widget : widgets) {
            int row = WidgetCompactor.nearestIndex(rows, widget.getY());
            int col = WidgetCompactor.nearestIndex(columns, widget.getX());
            grid[row][col] = widget;
        }
        int[] colWidths = new int[numCols];
        int[] rowHeights = new int[numRows];
        for (int r2 = 0; r2 < numRows; ++r2) {
            for (int c = 0; c < numCols; ++c) {
                GuiEditorWidget.WidgetEditorWidget widget = grid[r2][c];
                if (widget == null) continue;
                colWidths[c] = Math.max(colWidths[c], widget.getWidth());
                rowHeights[r2] = Math.max(rowHeights[r2], widget.getHeight());
            }
        }
        int[] xOffsets = new int[numCols];
        int[] yOffsets = new int[numRows];
        for (int c = 1; c < numCols; ++c) {
            xOffsets[c] = xOffsets[c - 1] + colWidths[c - 1] + padding;
        }
        for (r = 1; r < numRows; ++r) {
            yOffsets[r] = yOffsets[r - 1] + rowHeights[r - 1] + padding;
        }
        for (r = 0; r < numRows; ++r) {
            for (int c = 0; c < numCols; ++c) {
                GuiEditorWidget.WidgetEditorWidget widget = grid[r][c];
                if (widget == null) continue;
                change.accept(widget);
                widget.setPosition(minX + xOffsets[c], minY + yOffsets[r]);
            }
        }
    }

    private static List<Integer> extract(List<GuiEditorWidget.WidgetEditorWidget<?>> widgets, boolean isX) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (GuiEditorWidget.WidgetEditorWidget<?> widget : widgets) {
            values.add(isX ? widget.getX() : widget.getY());
        }
        Collections.sort(values);
        return values;
    }

    private static List<Integer> clusterValues(List<Integer> values, int tolerance) {
        ArrayList<Integer> clustered = new ArrayList<Integer>();
        for (int v : values) {
            if (!clustered.isEmpty() && Math.abs((Integer)clustered.getLast() - v) <= tolerance) continue;
            clustered.add(v);
        }
        return clustered;
    }

    private static int nearestIndex(List<Integer> values, int val) {
        int bestIdx = 0;
        int bestDist = Integer.MAX_VALUE;
        for (int i = 0; i < values.size(); ++i) {
            int dist = Math.abs(values.get(i) - val);
            if (dist >= bestDist) continue;
            bestDist = dist;
            bestIdx = i;
        }
        return bestIdx;
    }
}

