/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.tabs;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.machine.MachineStatus;
import fr.frinn.custommachinery.client.screen.creation.AppearanceListWidget;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.client.screen.creation.MachineEditTabNavigationBar;
import fr.frinn.custommachinery.client.screen.creation.MachineTabManager;
import fr.frinn.custommachinery.client.screen.creation.tabs.MachineEditTab;
import fr.frinn.custommachinery.client.screen.popup.ConfirmPopup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class AppearanceTab
extends MachineEditTab {
    public static final WidgetSprites RESET_SPRITE = new WidgetSprites(CustomMachinery.rl("creation/reset_button"), CustomMachinery.rl("creation/reset_button_hovered"));
    private final TabManager tabManager;
    private final MachineEditTabNavigationBar bar;

    public AppearanceTab(MachineEditScreen parent) {
        super((Component)Component.translatable((String)"custommachinery.gui.creation.tab.appearance"), parent);
        GridLayout.RowHelper row = this.layout.createRowHelper(1);
        row.defaultCellSetting().paddingHorizontal(0);
        this.tabManager = new MachineTabManager(parent);
        ArrayList<MachineEditTab> tabs = new ArrayList<MachineEditTab>();
        tabs.add(new SpecificAppearanceTab(this, (Component)Component.translatable((String)"custommachinery.craftingstatus.default"), parent, null));
        Arrays.stream(MachineStatus.values()).forEach(status -> tabs.add(new SpecificAppearanceTab(this, (Component)Component.translatable((String)("custommachinery.craftingstatus." + status.getSerializedName())), parent, (MachineStatus)((Object)status))));
        this.bar = (MachineEditTabNavigationBar)row.addChild((LayoutElement)new MachineEditTabNavigationBar(parent.xSize, this.tabManager, tabs, false), row.newCellSettings().alignVerticallyTop().alignHorizontallyCenter().paddingTop(5));
        this.bar.setRectangle(parent.xSize - 10, 20, 0, 0);
        row.addChild((LayoutElement)new SeparationWidget(this, parent.xSize, 5), row.newCellSettings().paddingBottom(parent.ySize - 30).alignVerticallyTop());
    }

    @Override
    public void opened() {
        if (this.tabManager.getCurrentTab() == null) {
            this.bar.selectTab(0, false);
        } else {
            this.tabManager.getCurrentTab().visitChildren(this.parent::addRenderableWidget);
        }
    }

    @Override
    public void closed() {
        if (this.tabManager.getCurrentTab() != null) {
            this.tabManager.getCurrentTab().visitChildren(this.parent::removeWidget);
        }
    }

    public void doLayout(ScreenRectangle rectangle) {
        super.doLayout(rectangle);
        this.tabManager.setTabArea(new ScreenRectangle(this.parent.x + 5, this.parent.y + 30, this.parent.xSize - 10, this.parent.ySize - 35));
    }

    @Override
    public List<AbstractWidget> getToolButtons() {
        ImageButton reset = new ImageButton(20, 20, RESET_SPRITE, button -> this.resetAppearance(), (Component)Component.empty());
        reset.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.appearance.reset.tooltip")));
        return List.of(reset);
    }

    public void resetAppearance() {
        Tab tab = this.tabManager.getCurrentTab();
        if (tab instanceof SpecificAppearanceTab) {
            SpecificAppearanceTab appearanceTab = (SpecificAppearanceTab)tab;
            MutableComponent status = Component.translatable((String)("custommachinery.craftingstatus." + (appearanceTab.status == null ? "default" : appearanceTab.status.getSerializedName()))).withStyle(ChatFormatting.GOLD);
            this.parent.openPopup(new ConfirmPopup(this.parent, 116, 96, () -> {
                this.parent.getBuilder().getAppearance(appearanceTab.status).reset();
                appearanceTab.appearanceList.init();
            }).title((Component)Component.translatable((String)"custommachinery.gui.creation.appearance.reset.title")).text(new Component[]{Component.translatable((String)"custommachinery.gui.creation.appearance.reset.text", (Object[])new Object[]{status})}));
        }
    }

    private class SpecificAppearanceTab
    extends MachineEditTab {
        @Nullable
        private final MachineStatus status;
        private final AppearanceListWidget appearanceList;

        public SpecificAppearanceTab(AppearanceTab appearanceTab, Component title, @Nullable MachineEditScreen parent, MachineStatus status) {
            super(title, parent);
            this.status = status;
            GridLayout.RowHelper row = this.layout.createRowHelper(1);
            this.appearanceList = (AppearanceListWidget)row.addChild((LayoutElement)new AppearanceListWidget(0, 0, parent.xSize - 20, parent.ySize - 40, 30, () -> parent.getBuilder().getAppearance(status), this.parent));
        }
    }

    private class SeparationWidget
    extends AbstractWidget {
        private final ResourceLocation texture = CustomMachinery.rl("creation/separation");

        public SeparationWidget(AppearanceTab appearanceTab, int width, int height) {
            super(0, 0, width, height, (Component)Component.empty());
        }

        protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            graphics.blitSprite(this.texture, this.getX(), this.getY(), -1, this.getWidth(), this.getHeight());
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }
    }
}

