/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.tabs;

import com.google.common.collect.ImmutableList;
import fr.frinn.custommachinery.api.crafting.IProcessorTemplate;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.client.screen.creation.tabs.MachineEditTab;
import fr.frinn.custommachinery.client.screen.widget.ComponentEditBox;
import fr.frinn.custommachinery.client.screen.widget.IntegerSlider;
import fr.frinn.custommachinery.common.crafting.craft.CraftProcessor;
import fr.frinn.custommachinery.common.crafting.machine.MachineProcessor;
import fr.frinn.custommachinery.common.init.Registration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.toasts.TutorialToast;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.network.chat.Component;

public class BaseInfoTab
extends MachineEditTab {
    private final List<AbstractWidget> processorWidgets = new ArrayList<AbstractWidget>();
    private int coresAmount = 1;
    private int recipeCheckCooldown = 20;

    public BaseInfoTab(MachineEditScreen parent) {
        super((Component)Component.translatable((String)"custommachinery.gui.creation.tab.base_info"), parent);
        Font font = this.parent.mc.font;
        IProcessorTemplate<?> iProcessorTemplate = this.parent.getBuilder().getProcessor();
        if (iProcessorTemplate instanceof MachineProcessor.Template) {
            MachineProcessor.Template template = (MachineProcessor.Template)iProcessorTemplate;
            this.coresAmount = template.amount();
            this.recipeCheckCooldown = template.recipeCheckCooldown();
        }
        GridLayout.RowHelper row = this.layout.rowSpacing(8).createRowHelper(2);
        row.defaultCellSetting().paddingHorizontal(0);
        LayoutSettings middle = row.newCellSettings().alignVerticallyMiddle();
        LayoutSettings right = row.newCellSettings().alignHorizontallyRight();
        row.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.base_info.id"), Minecraft.getInstance().font), middle);
        row.addChild((LayoutElement)new MachineIdWidget(150, 9, (Component)Component.literal((String)this.parent.getBuilder().getLocation().getId().toString()), Minecraft.getInstance().font));
        row.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.base_info.name"), font), middle);
        ComponentEditBox nameEdit = new ComponentEditBox(0, 0, 100, 20, (Component)Component.literal((String)"name"));
        nameEdit.setHint((Component)Component.literal((String)"name"));
        nameEdit.setComponent(this.parent.getBuilder().getName());
        nameEdit.setComponentResponder(name -> {
            this.parent.setChanged();
            this.parent.getBuilder().setName((Component)name);
        });
        row.addChild((LayoutElement)nameEdit, right);
        row.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.base_info.processor"), font), middle);
        row.addChild((LayoutElement)CycleButton.builder(processor -> Component.literal((String)processor.getId().getPath())).withValues((Collection)ImmutableList.copyOf(Registration.PROCESSOR_REGISTRY)).withInitialValue(Registration.MACHINE_PROCESSOR.get()).displayOnlyValue().create(0, 0, 100, 20, (Component)Component.literal((String)"Machine processor"), (button, processor) -> {
            if (processor == this.parent.getBuilder().getProcessor().getType()) {
                return;
            }
            if (processor == Registration.MACHINE_PROCESSOR.get()) {
                this.parent.getBuilder().setProcessor(new MachineProcessor.Template(this.coresAmount, this.recipeCheckCooldown));
            } else if (processor == Registration.CRAFT_PROCESSOR.get()) {
                this.parent.getBuilder().setProcessor(CraftProcessor.Template.DEFAULT);
            }
            this.parent.setChanged();
            boolean visible = processor == Registration.MACHINE_PROCESSOR.get();
            this.processorWidgets.forEach(widget -> {
                widget.visible = visible;
            });
        }), right);
        this.processorWidgets.add((AbstractWidget)row.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.base_info.cores"), font), middle));
        IntegerSlider cores = (IntegerSlider)row.addChild((LayoutElement)IntegerSlider.builder().bounds(1, 16).defaultValue(this.coresAmount).setResponder(amount -> {
            IProcessorTemplate<?> patt0$temp = this.parent.getBuilder().getProcessor();
            if (patt0$temp instanceof MachineProcessor.Template) {
                MachineProcessor.Template template = (MachineProcessor.Template)patt0$temp;
                this.coresAmount = amount;
                this.parent.getBuilder().setProcessor(new MachineProcessor.Template((int)amount, template.recipeCheckCooldown()));
                this.parent.setChanged();
            }
        }).displayOnlyValue().create(0, 0, 100, 20, (Component)Component.empty()), right);
        cores.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.base_info.cores.tooltip")));
        this.processorWidgets.add((AbstractWidget)cores);
        this.processorWidgets.add((AbstractWidget)row.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.base_info.cooldown"), font), middle));
        IntegerSlider cooldown = (IntegerSlider)row.addChild((LayoutElement)IntegerSlider.builder().bounds(0, 200).defaultValue(this.recipeCheckCooldown).setResponder(recipeCheckCooldown -> {
            IProcessorTemplate<?> patt0$temp = this.parent.getBuilder().getProcessor();
            if (patt0$temp instanceof MachineProcessor.Template) {
                MachineProcessor.Template template = (MachineProcessor.Template)patt0$temp;
                this.recipeCheckCooldown = recipeCheckCooldown;
                this.parent.getBuilder().setProcessor(new MachineProcessor.Template(template.amount(), (int)recipeCheckCooldown));
                this.parent.setChanged();
            }
        }).displayOnlyValue().create(0, 0, 100, 20, (Component)Component.empty()), right);
        cooldown.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.base_info.cooldown.tooltip")));
        this.processorWidgets.add((AbstractWidget)cooldown);
    }

    private static class MachineIdWidget
    extends StringWidget {
        public MachineIdWidget(int width, int height, Component message, Font font) {
            super(width, height, message, font);
            this.active = true;
            this.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.base_info.id.tooltip")));
        }

        public void onClick(double mouseX, double mouseY, int button) {
            Minecraft.getInstance().keyboardHandler.setClipboard(this.getMessage().getString());
            Minecraft.getInstance().getTutorial().addTimedToast(new TutorialToast(TutorialToast.Icons.MOUSE, (Component)Component.translatable((String)"custommachinery.gui.creation.base_info.id.copied"), null, false), 50);
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            guiGraphics.drawScrollingString(this.getFont(), this.getMessage(), this.getX(), this.getX() + this.getWidth(), this.getY(), this.getColor());
        }
    }
}

