/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.widget.config;

import com.mojang.blaze3d.systems.RenderSystem;
import fr.frinn.custommachinery.CustomMachinery;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FastColor;

public class AutoIOModeButton
extends ImageButton {
    private static final WidgetSprites SPRITES = new WidgetSprites(CustomMachinery.rl("config/auto_io_button"), CustomMachinery.rl("config/auto_io_button_hovered"));
    private static final MutableComponent INPUT = Component.translatable((String)"custommachinery.gui.config.auto_input");
    private static final MutableComponent OUTPUT = Component.translatable((String)"custommachinery.gui.config.auto_output");
    private static final MutableComponent ENABLED = Component.translatable((String)"custommachinery.gui.config.enabled").withStyle(ChatFormatting.GREEN);
    private static final MutableComponent DISABLED = Component.translatable((String)"custommachinery.gui.config.disabled").withStyle(ChatFormatting.RED);
    private final Supplier<Boolean> enabled;
    private final boolean input;

    public AutoIOModeButton(int x, int y, Supplier<Boolean> enabled, boolean input, Button.OnPress onPress) {
        super(x, y, 28, 14, SPRITES, onPress, (Component)(input ? INPUT : OUTPUT));
        this.enabled = enabled;
        this.input = input;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int color = FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255);
        if (this.input && this.enabled.get().booleanValue()) {
            color = FastColor.ARGB32.color((int)255, (int)255, (int)85, (int)85);
        } else if (!this.input && this.enabled.get().booleanValue()) {
            color = FastColor.ARGB32.color((int)255, (int)85, (int)85, (int)255);
        }
        float r = (float)FastColor.ARGB32.red((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.green((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.updateTooltip();
    }

    private void updateTooltip() {
        MutableComponent tooltip = (this.input ? INPUT : OUTPUT).copy();
        tooltip.append("\n");
        if (this.enabled.get().booleanValue()) {
            tooltip.append((Component)ENABLED);
        } else {
            tooltip.append((Component)DISABLED);
        }
        this.setTooltip(Tooltip.create((Component)tooltip));
    }
}

