/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.component;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IComparatorInputComponent;
import fr.frinn.custommachinery.api.component.IDumpComponent;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.component.ISerializableComponent;
import fr.frinn.custommachinery.api.component.ISideConfigComponent;
import fr.frinn.custommachinery.api.component.ITickableComponent;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.network.ISyncable;
import fr.frinn.custommachinery.api.network.ISyncableStuff;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.network.syncable.IOSideConfigSyncable;
import fr.frinn.custommachinery.common.network.syncable.LongSyncable;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.common.util.transfer.SidedEnergyStorage;
import fr.frinn.custommachinery.impl.component.AbstractMachineComponent;
import fr.frinn.custommachinery.impl.component.config.IOSideConfig;
import fr.frinn.custommachinery.impl.component.config.IOSideMode;
import fr.frinn.custommachinery.impl.component.config.RelativeSide;
import fr.frinn.custommachinery.impl.integration.jei.Energy;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class EnergyMachineComponent
extends AbstractMachineComponent
implements ITickableComponent,
ISerializableComponent,
ISyncableStuff,
IComparatorInputComponent,
ISideConfigComponent,
IDumpComponent,
IEnergyStorage {
    private long energy = 0L;
    private final long capacity;
    private final long maxInput;
    private final long minInput;
    private final long maxOutput;
    private final long minOutput;
    private final IOSideConfig config;
    private final Map<Direction, SidedEnergyStorage> sidedStorages = Maps.newEnumMap(Direction.class);
    private final Map<Direction, BlockCapabilityCache<IEnergyStorage, Direction>> neighbourStorages = Maps.newEnumMap(Direction.class);

    public EnergyMachineComponent(IMachineComponentManager manager, long capacity, long maxInput, long minInput, long maxOutput, long minOutput, IOSideConfig.Template configTemplate) {
        super(manager, ComponentIOMode.BOTH);
        this.capacity = capacity;
        this.maxInput = maxInput;
        this.minInput = minInput;
        this.maxOutput = maxOutput;
        this.minOutput = minOutput;
        this.config = configTemplate.build(this);
        this.config.setCallback(this::configChanged);
        for (Direction side : Direction.values()) {
            this.sidedStorages.put(side, new SidedEnergyStorage(side, this));
        }
    }

    public long getMaxInput() {
        return this.maxInput;
    }

    public long getMinInput() {
        return this.minInput;
    }

    public long getMaxOutput() {
        return this.maxOutput;
    }

    public long getMinOutput() {
        return this.minOutput;
    }

    public double getFillPercent() {
        return (double)this.energy / (double)this.capacity;
    }

    public long getEnergy() {
        return this.energy;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public void setEnergy(long energy) {
        this.energy = energy;
        this.getManager().markDirty();
    }

    public void configChanged(RelativeSide side, IOSideMode oldMode, IOSideMode newMode) {
        if (oldMode.isNone() != newMode.isNone()) {
            this.getManager().getTile().invalidateCapabilities();
        }
    }

    @Nullable
    public IEnergyStorage getEnergyStorage(@Nullable Direction side) {
        if (side == null) {
            return this;
        }
        if (!((IOSideMode)this.config.getDirectionMode(side)).isNone()) {
            return this.sidedStorages.get(side);
        }
        return null;
    }

    public IOSideConfig getConfig() {
        return this.config;
    }

    @Override
    public String getId() {
        return "energy";
    }

    public MachineComponentType<EnergyMachineComponent> getType() {
        return Registration.ENERGY_MACHINE_COMPONENT.get();
    }

    @Override
    public void serverTick() {
        for (Direction side : Direction.values()) {
            IEnergyStorage neighbour;
            if (!this.getConfig().canAutoIO(side)) continue;
            if (this.neighbourStorages.get(side) == null) {
                this.neighbourStorages.put(side, (BlockCapabilityCache<IEnergyStorage, Direction>)BlockCapabilityCache.create((BlockCapability)Capabilities.EnergyStorage.BLOCK, (ServerLevel)((ServerLevel)this.getManager().getLevel()), (BlockPos)this.getManager().getTile().getBlockPos().relative(side), (Object)side.getOpposite(), () -> !this.getManager().getTile().isRemoved(), () -> this.neighbourStorages.remove(side)));
            }
            if ((neighbour = (IEnergyStorage)this.neighbourStorages.get(side).getCapability()) == null) continue;
            if (this.getConfig().isAutoInput() && ((IOSideMode)this.getConfig().getDirectionMode(side)).isInput() && this.getEnergy() < this.getCapacity()) {
                this.move(neighbour, this.sidedStorages.get(side), Integer.MAX_VALUE);
            }
            if (!this.getConfig().isAutoOutput() || !((IOSideMode)this.getConfig().getDirectionMode(side)).isOutput() || this.getEnergy() <= 0L) continue;
            this.move(this.sidedStorages.get(side), neighbour, Integer.MAX_VALUE);
        }
    }

    private void move(IEnergyStorage from, IEnergyStorage to, int maxAmount) {
        int maxExtracted = from.extractEnergy(maxAmount, true);
        if (maxExtracted > 0) {
            int maxInserted;
            int toTransfer = maxInserted = to.receiveEnergy(maxExtracted, true);
            if (maxInserted != maxExtracted) {
                toTransfer = from.extractEnergy(maxInserted, true);
            }
            if (toTransfer != maxInserted) {
                toTransfer = to.receiveEnergy(toTransfer, true);
            }
            if (toTransfer > 0) {
                from.extractEnergy(toTransfer, false);
                to.receiveEnergy(toTransfer, false);
            }
        }
    }

    @Override
    public void serialize(CompoundTag nbt, HolderLookup.Provider registries) {
        nbt.putLong("energy", this.energy);
        nbt.put("config", (Tag)this.config.serialize());
    }

    @Override
    public void deserialize(CompoundTag nbt, HolderLookup.Provider registries) {
        if (nbt.contains("energy", 4)) {
            this.energy = Math.min(nbt.getLong("energy"), this.capacity);
        }
        if (nbt.contains("config")) {
            this.config.deserialize(nbt.getCompound("config"));
        }
    }

    @Override
    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        container.accept(LongSyncable.create(() -> this.energy, energy -> {
            this.energy = energy;
        }));
        container.accept(IOSideConfigSyncable.create(this::getConfig, this.config::set));
    }

    @Override
    public int getComparatorInput() {
        return (int)(15.0 * ((double)this.energy / (double)this.capacity));
    }

    @Override
    public void dump(List<String> ids) {
        this.setEnergy(0L);
    }

    public int receiveRecipeEnergy(int maxReceive, boolean simulate) {
        int energyReceived = Math.min(Utils.toInt(this.capacity - this.energy), maxReceive);
        if (!simulate) {
            this.energy += (long)energyReceived;
            this.getManager().markDirty();
        }
        return energyReceived;
    }

    public int extractRecipeEnergy(int maxExtract, boolean simulate) {
        int energyExtracted = Math.min(Utils.toInt(this.energy), maxExtract);
        if (!simulate) {
            this.energy -= (long)energyExtracted;
            this.getManager().markDirty();
        }
        return energyExtracted;
    }

    public int receiveEnergy(int toReceive, boolean simulate) {
        if (this.getMaxInput() <= 0L || (long)toReceive < this.getMinInput()) {
            return 0;
        }
        int energyReceived = (int)Math.min(this.getCapacity() - this.getEnergy(), Math.min(this.getMaxInput(), (long)toReceive));
        if (!simulate && energyReceived > 0) {
            this.setEnergy(this.getEnergy() + (long)energyReceived);
            this.getManager().markDirty();
        }
        return energyReceived;
    }

    public int extractEnergy(int toExtract, boolean simulate) {
        if (this.getMaxOutput() <= 0L || (long)toExtract < this.getMinOutput()) {
            return 0;
        }
        long energyExtracted = Math.min(this.getEnergy(), Math.min(this.getMaxOutput(), (long)toExtract));
        if (!simulate && energyExtracted > 0L) {
            this.setEnergy(this.getEnergy() - energyExtracted);
            this.getManager().markDirty();
        }
        return (int)energyExtracted;
    }

    public int getEnergyStored() {
        return (int)this.getEnergy();
    }

    public int getMaxEnergyStored() {
        return (int)this.getCapacity();
    }

    public boolean canExtract() {
        return this.getEnergy() > 0L && this.getMaxOutput() > 0L;
    }

    public boolean canReceive() {
        return this.getCapacity() - this.getEnergy() > 0L && this.getMaxInput() > 0L;
    }

    public record Template(long capacity, long maxInput, long minInput, long maxOutput, long minOutput, IOSideConfig.Template config) implements IMachineComponentTemplate<EnergyMachineComponent>
    {
        public static final NamedCodec<Template> CODEC = NamedCodec.record(templateInstance -> templateInstance.group(NamedCodec.longRange(1L, Long.MAX_VALUE).fieldOf("capacity").forGetter(template -> template.capacity), NamedCodec.longRange(0L, Long.MAX_VALUE).optionalFieldOf("maxInput").forGetter(template -> template.maxInput == template.capacity ? Optional.empty() : Optional.of(template.maxInput)), NamedCodec.longRange(0L, Long.MAX_VALUE).optionalFieldOf("minInput", 0L).forGetter(template -> template.minInput), NamedCodec.longRange(0L, Long.MAX_VALUE).optionalFieldOf("maxOutput").forGetter(template -> template.maxOutput == template.capacity ? Optional.empty() : Optional.of(template.maxOutput)), NamedCodec.longRange(0L, Long.MAX_VALUE).optionalFieldOf("minOutput", 0L).forGetter(template -> template.minOutput), IOSideConfig.Template.CODEC.optionalFieldOf("config", IOSideConfig.Template.DEFAULT_ALL_INPUT).forGetter(template -> template.config)).apply((Applicative)templateInstance, (capacity, maxInput, minInput, maxOutput, minOutput, config) -> new Template((long)capacity, maxInput.orElse(capacity), (long)minInput, maxOutput.orElse(capacity), (long)minOutput, (IOSideConfig.Template)config)), "Energy machine component");

        @Override
        public MachineComponentType<EnergyMachineComponent> getType() {
            return Registration.ENERGY_MACHINE_COMPONENT.get();
        }

        @Override
        public String getId() {
            return "";
        }

        @Override
        public boolean canAccept(Object ingredient, boolean isInput, IMachineComponentManager manager) {
            return ingredient instanceof Energy;
        }

        @Override
        public EnergyMachineComponent build(IMachineComponentManager manager) {
            return new EnergyMachineComponent(manager, this.capacity, this.maxInput, this.minInput, this.maxOutput, this.minOutput, this.config);
        }
    }
}

