/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.crafting.craft;

import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.requirement.RecipeRequirement;
import fr.frinn.custommachinery.common.crafting.craft.CustomCraftRecipe;
import fr.frinn.custommachinery.impl.codec.DefaultCodecs;
import fr.frinn.custommachinery.impl.codec.NamedMapCodec;
import fr.frinn.custommachinery.impl.crafting.AbstractRecipeBuilder;
import java.util.Collections;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class CustomCraftRecipeBuilder
extends AbstractRecipeBuilder<CustomCraftRecipe> {
    public static final NamedMapCodec<CustomCraftRecipeBuilder> CODEC = NamedCodec.record(builderInstance -> builderInstance.group(DefaultCodecs.RESOURCE_LOCATION.fieldOf("machine").forGetter(AbstractRecipeBuilder::getMachine), DefaultCodecs.ITEM_OR_STACK.fieldOf("output").forGetter(builder -> builder.output), RecipeRequirement.CODEC.listOf().optionalFieldOf("requirements", Collections.emptyList()).forGetter(AbstractRecipeBuilder::getRequirements), RecipeRequirement.CODEC.listOf().optionalFieldOf("jei", Collections.emptyList()).forGetter(AbstractRecipeBuilder::getJeiRequirements), NamedCodec.INT.optionalFieldOf("priority", 0).forGetter(AbstractRecipeBuilder::getPriority), NamedCodec.INT.optionalFieldOf("jeiPriority", 0).forGetter(AbstractRecipeBuilder::getJeiPriority), NamedCodec.BOOL.optionalFieldOf("hidden", false).forGetter(AbstractRecipeBuilder::isHidden)).apply((Applicative)builderInstance, (machine, output, requirements, jeiRequirements, priority, jeiPriority, hidden) -> {
        CustomCraftRecipeBuilder builder = new CustomCraftRecipeBuilder((ResourceLocation)machine, (ItemStack)output);
        requirements.forEach(builder::withRequirement);
        jeiRequirements.forEach(builder::withJeiRequirement);
        builder.withPriority((int)priority);
        builder.withJeiPriority((int)jeiPriority);
        if (hidden.booleanValue()) {
            builder.hide();
        }
        return builder;
    }), "Craft recipe builder");
    private final ItemStack output;

    public CustomCraftRecipeBuilder(ResourceLocation machine, ItemStack output) {
        super(machine);
        this.output = output;
    }

    public CustomCraftRecipeBuilder(CustomCraftRecipe recipe) {
        super(recipe);
        this.output = recipe.getOutput();
    }

    @Override
    public CustomCraftRecipe build() {
        return new CustomCraftRecipe(this.getMachine(), this.output, this.getRequirements(), this.getJeiRequirements(), this.getPriority(), this.getJeiPriority(), this.isHidden());
    }
}

