/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.guielement;

import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.guielement.GuiElementType;
import fr.frinn.custommachinery.api.guielement.IComponentGuiElement;
import fr.frinn.custommachinery.common.component.EnergyMachineComponent;
import fr.frinn.custommachinery.common.guielement.ProgressBarGuiElement;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.impl.guielement.AbstractGuiElement;
import fr.frinn.custommachinery.impl.guielement.AbstractTexturedGuiElement;
import fr.frinn.custommachinery.impl.util.TextureInfo;

public class EnergyGuiElement
extends AbstractTexturedGuiElement
implements IComponentGuiElement<EnergyMachineComponent> {
    public static final TextureInfo BASE_ENERGY_STORAGE_EMPTY_TEXTURE = CustomMachinery.texture("textures/gui/base_energy_storage_empty.png");
    public static final TextureInfo BASE_ENERGY_STORAGE_FILLED_TEXTURE = CustomMachinery.texture("textures/gui/base_energy_storage_filled.png");
    public static final NamedCodec<EnergyGuiElement> CODEC = NamedCodec.record(energyGuiElement -> energyGuiElement.group(EnergyGuiElement.makePropertiesCodec().forGetter(AbstractGuiElement::getProperties), TextureInfo.CODEC.optionalFieldOf("texture_empty", BASE_ENERGY_STORAGE_EMPTY_TEXTURE).forGetter(EnergyGuiElement::getEmptyTexture), TextureInfo.CODEC.optionalFieldOf("texture_filled", BASE_ENERGY_STORAGE_FILLED_TEXTURE).forGetter(EnergyGuiElement::getFilledTexture), NamedCodec.enumCodec(ProgressBarGuiElement.Orientation.class).optionalFieldOf("orientation", ProgressBarGuiElement.Orientation.TOP).aliases("direction").forGetter(EnergyGuiElement::getOrientation), NamedCodec.BOOL.optionalFieldOf("highlight", true).forGetter(EnergyGuiElement::highlight)).apply((Applicative)energyGuiElement, EnergyGuiElement::new), "Energy gui element");
    private final TextureInfo emptyTexture;
    private final TextureInfo filledTexture;
    private final ProgressBarGuiElement.Orientation orientation;
    private final boolean highlight;

    public EnergyGuiElement(AbstractGuiElement.Properties properties, TextureInfo emptyTexture, TextureInfo filledTexture, ProgressBarGuiElement.Orientation orientation, boolean highlight) {
        super(properties, emptyTexture);
        this.emptyTexture = emptyTexture;
        this.filledTexture = filledTexture;
        this.orientation = orientation;
        this.highlight = highlight;
    }

    public TextureInfo getEmptyTexture() {
        return this.emptyTexture;
    }

    public TextureInfo getFilledTexture() {
        return this.filledTexture;
    }

    public ProgressBarGuiElement.Orientation getOrientation() {
        return this.orientation;
    }

    public boolean highlight() {
        return this.highlight;
    }

    public GuiElementType<EnergyGuiElement> getType() {
        return Registration.ENERGY_GUI_ELEMENT.get();
    }

    @Override
    public MachineComponentType<EnergyMachineComponent> getComponentType() {
        return Registration.ENERGY_MACHINE_COMPONENT.get();
    }

    @Override
    public String getComponentId() {
        return "";
    }
}

