/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.init;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.component.ISideConfigComponent;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import fr.frinn.custommachinery.common.init.Registration;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class ConfigurationCardItem
extends Item {
    private static final String MACHINE_ID = "machineId";
    private static final String SIDE_CONFIG = "sideConfig";

    public ConfigurationCardItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof CustomMachineTile)) {
            return InteractionResult.FAIL;
        }
        CustomMachineTile machine = (CustomMachineTile)blockEntity;
        return this.copyConfiguration(level, player, machine, player.getItemInHand(context.getHand()));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide && player.isCrouching() && stack.has(Registration.CONFIGURATION_CARD_DATA)) {
            stack.remove(Registration.CONFIGURATION_CARD_DATA);
            player.displayClientMessage((Component)Component.translatable((String)"custommachinery.configuration_card.cleared").withStyle(ChatFormatting.GREEN), true);
            return InteractionResultHolder.success((Object)stack);
        }
        return super.use(level, player, hand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        ConfigurationCardItem.getMachineId(stack).flatMap(id -> Optional.ofNullable(CustomMachinery.MACHINES.get(id))).ifPresent(machine -> tooltip.add((Component)Component.translatable((String)"custommachinery.configuration_card.configured", (Object[])new Object[]{machine.getName()}).withStyle(ChatFormatting.AQUA)));
        tooltip.add((Component)Component.translatable((String)"custommachinery.configuration_card.copy").withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)"custommachinery.configuration_card.paste").withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)"custommachinery.configuration_card.reset").withStyle(ChatFormatting.GOLD));
    }

    private InteractionResult copyConfiguration(Level level, Player player, CustomMachineTile machine, ItemStack stack) {
        if (!level.isClientSide && player.isCrouching()) {
            ConfigurationCardData data = new ConfigurationCardData(machine.getId(), new HashMap<String, CompoundTag>());
            for (ISideConfigComponent component : machine.getComponentManager().getConfigComponents()) {
                data.configs().put(component.getId(), component.getConfig().serialize());
            }
            stack.set(Registration.CONFIGURATION_CARD_DATA, (Object)data);
            player.displayClientMessage((Component)Component.translatable((String)"custommachinery.configuration_card.copied", (Object[])new Object[]{machine.getMachine().getName()}).withStyle(ChatFormatting.GREEN), true);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public static ItemInteractionResult pasteConfiguration(Level level, Player player, CustomMachineTile machine, ItemStack stack) {
        if (!level.isClientSide) {
            Optional<ResourceLocation> machineId = ConfigurationCardItem.getMachineId(stack);
            if (!machineId.map(id -> id.equals((Object)machine.getId())).orElse(false).booleanValue()) {
                player.displayClientMessage((Component)Component.translatable((String)"custommachinery.configuration_card.different_machine").withStyle(ChatFormatting.RED), true);
                return ItemInteractionResult.FAIL;
            }
            for (ISideConfigComponent component : machine.getComponentManager().getConfigComponents()) {
                ConfigurationCardItem.deserializeSideConfig(stack, component);
            }
            player.displayClientMessage((Component)Component.translatable((String)"custommachinery.configuration_card.pasted", (Object[])new Object[]{machine.getMachine().getName()}).withStyle(ChatFormatting.GREEN), true);
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    private static Optional<ResourceLocation> getMachineId(ItemStack stack) {
        return Optional.ofNullable((ConfigurationCardData)stack.get(Registration.CONFIGURATION_CARD_DATA)).map(ConfigurationCardData::machineId);
    }

    private static void deserializeSideConfig(ItemStack stack, ISideConfigComponent component) {
        ConfigurationCardData data = (ConfigurationCardData)stack.get(Registration.CONFIGURATION_CARD_DATA);
        if (data != null && data.configs().containsKey(component.getId())) {
            component.getConfig().deserialize(data.configs().get(component.getId()));
        }
    }

    public record ConfigurationCardData(ResourceLocation machineId, Map<String, CompoundTag> configs) {
        public static final Codec<ConfigurationCardData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf(ConfigurationCardItem.MACHINE_ID).forGetter(ConfigurationCardData::machineId), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)CompoundTag.CODEC).fieldOf("config").forGetter(ConfigurationCardData::configs)).apply((Applicative)instance, ConfigurationCardData::new));
        public static final StreamCodec<ByteBuf, ConfigurationCardData> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
    }
}

