/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.crafttweaker.requirements;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import fr.frinn.custommachinery.api.integration.crafttweaker.RecipeCTBuilder;
import fr.frinn.custommachinery.common.requirement.ItemTransformRequirement;
import java.util.function.Function;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.custommachinery.requirement.ItemTransform")
public interface ItemTransformRequirementCT<T>
extends RecipeCTBuilder<T> {
    @ZenCodeType.Method
    default public T transformItem(IIngredient ingredient, @ZenCodeType.OptionalInt(value=1) int amount, @ZenCodeType.Optional IItemStack output, @ZenCodeType.OptionalString String inputSlot, @ZenCodeType.OptionalString String outputSlot, @ZenCodeType.Optional Function<IItemStack, IItemStack> nbt) {
        Item outputItem = output == null ? Items.AIR : output.getDefinition();
        int outputAmount = output == null ? 1 : output.amount();
        return this.addRequirement(new ItemTransformRequirement(ingredient.asVanillaIngredient(), amount, inputSlot, outputItem, outputAmount, outputSlot, true, new NbtTransformer(nbt)));
    }

    public static class NbtTransformer
    implements Function<ItemStack, ItemStack> {
        private final Function<IItemStack, IItemStack> function;

        public NbtTransformer(Function<IItemStack, IItemStack> function) {
            this.function = function;
        }

        @Override
        public ItemStack apply(@Nullable ItemStack stack) {
            return this.function.apply(IItemStack.of((ItemStack)stack)).getInternal();
        }
    }
}

