/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.kubejs;

import fr.frinn.custommachinery.api.machine.MachineAppearanceProperty;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.machine.MachineAppearance;
import fr.frinn.custommachinery.common.util.MachineModelLocation;
import fr.frinn.custommachinery.common.util.PartialBlockState;
import fr.frinn.custommachinery.common.util.sound.AmbientSound;
import fr.frinn.custommachinery.common.util.sound.CMSoundType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;

public class MachineAppearanceBuilderJS {
    private final Map<MachineAppearanceProperty<?>, Object> properties = MachineAppearance.defaultProperties();

    public MachineAppearanceBuilderJS block(ResourceLocation block) {
        this.put(Registration.BLOCK_MODEL_PROPERTY.get(), MachineModelLocation.of(block.toString()));
        return this;
    }

    public MachineAppearanceBuilderJS item(ResourceLocation item) {
        this.put(Registration.ITEM_MODEL_PROPERTY.get(), MachineModelLocation.of(item.toString()));
        return this;
    }

    public MachineAppearanceBuilderJS ambientSound(SoundEvent sound) {
        return this.ambientSound(sound, 1.0f, 1.0f);
    }

    public MachineAppearanceBuilderJS ambientSound(SoundEvent sound, float volume, float pitch) {
        this.put(Registration.AMBIENT_SOUND_PROPERTY.get(), new AmbientSound(sound, volume, pitch, SoundSource.BLOCKS, true, true, 0, false));
        return this;
    }

    public MachineAppearanceBuilderJS ambientSound(SoundEvent sound, float volume, float pitch, SoundSource source, boolean loop, boolean attenuation, int delay, boolean relative) {
        this.put(Registration.AMBIENT_SOUND_PROPERTY.get(), new AmbientSound(sound, volume, pitch, source, loop, attenuation, delay, relative));
        return this;
    }

    public MachineAppearanceBuilderJS interactionSound(Block sound) {
        this.put(Registration.INTERACTION_SOUND_PROPERTY.get(), new CMSoundType(new PartialBlockState(sound)));
        return this;
    }

    public MachineAppearanceBuilderJS light(int light) {
        this.put(Registration.LIGHT_PROPERTY.get(), Mth.clamp((int)light, (int)0, (int)15));
        return this;
    }

    public MachineAppearanceBuilderJS color(int color) {
        this.put(Registration.COLOR_PROPERTY.get(), color);
        return this;
    }

    public MachineAppearanceBuilderJS hardness(float hardness) {
        this.put(Registration.HARDNESS_PROPERTY.get(), Float.valueOf(hardness));
        return this;
    }

    public MachineAppearanceBuilderJS resistance(float resistance) {
        this.put(Registration.RESISTANCE_PROPERTY.get(), Float.valueOf(resistance));
        return this;
    }

    public MachineAppearanceBuilderJS toolType(ResourceLocation[] tools) {
        List<TagKey> list = Arrays.stream(tools).map(key -> TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)key)).toList();
        this.put(Registration.TOOL_TYPE_PROPERTY.get(), list);
        return this;
    }

    public MachineAppearanceBuilderJS miningLevel(ResourceLocation key) {
        TagKey level = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)key);
        this.put(Registration.MINING_LEVEL_PROPERTY.get(), level);
        return this;
    }

    public MachineAppearanceBuilderJS requiresTool(boolean requires) {
        this.put(Registration.REQUIRES_TOOL.get(), requires);
        return this;
    }

    private <T> void put(MachineAppearanceProperty<T> property, T value) {
        this.properties.put(property, value);
    }

    public MachineAppearance build() {
        return new MachineAppearance(this.properties);
    }
}

