/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.kubejs.requirements;

import fr.frinn.custommachinery.api.integration.kubejs.RecipeJSBuilder;
import fr.frinn.custommachinery.common.requirement.StructureRequirement;
import fr.frinn.custommachinery.common.util.BlockIngredient;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public interface StructureRequirementJS
extends RecipeJSBuilder {
    default public RecipeJSBuilder destroyStructure(String[][] pattern, Map<Character, List<BlockIngredient>> keys) {
        return this.requireStructure(pattern, keys, StructureRequirement.Action.DESTROY);
    }

    default public RecipeJSBuilder breakStructure(String[][] pattern, Map<Character, List<BlockIngredient>> keys) {
        return this.requireStructure(pattern, keys, StructureRequirement.Action.BREAK);
    }

    default public RecipeJSBuilder requireStructure(String[][] pattern, Map<Character, List<BlockIngredient>> keys) {
        return this.requireStructure(pattern, keys, StructureRequirement.Action.CHECK);
    }

    default public RecipeJSBuilder placeStructure(String[][] pattern, Map<Character, List<BlockIngredient>> keys, boolean drops) {
        return this.requireStructure(pattern, keys, drops ? StructureRequirement.Action.PLACE_BREAK : StructureRequirement.Action.PLACE_DESTROY);
    }

    default public RecipeJSBuilder requireStructure(String[][] pattern, Map<Character, List<BlockIngredient>> keys, StructureRequirement.Action action) {
        List<List<String>> patternList = Arrays.stream(pattern).map(floors -> Arrays.stream(floors).toList()).toList();
        try {
            return this.addRequirement(new StructureRequirement(patternList, keys, action));
        }
        catch (IllegalStateException e) {
            return this.error("Error while creating structure requirement: {}\nPattern: {}\nKeys: {}", new Object[]{e.getMessage(), pattern, keys});
        }
    }
}

