/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.network;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.component.ISideConfigComponent;
import fr.frinn.custommachinery.common.init.CustomMachineContainer;
import fr.frinn.custommachinery.impl.component.config.IOSideConfig;
import fr.frinn.custommachinery.impl.component.config.IOSideMode;
import fr.frinn.custommachinery.impl.component.config.RelativeSide;
import fr.frinn.custommachinery.impl.component.config.SideConfig;
import fr.frinn.custommachinery.impl.component.config.ToggleSideConfig;
import fr.frinn.custommachinery.impl.component.config.ToggleSideMode;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record CAllSidesNonePacket(int containerId, String componentId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CAllSidesNonePacket> TYPE = new CustomPacketPayload.Type(CustomMachinery.rl("all_sides_none"));
    public static final StreamCodec<ByteBuf, CAllSidesNonePacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, CAllSidesNonePacket::containerId, (StreamCodec)ByteBufCodecs.STRING_UTF8, CAllSidesNonePacket::componentId, CAllSidesNonePacket::new);

    public CustomPacketPayload.Type<CAllSidesNonePacket> type() {
        return TYPE;
    }

    public static void handle(CAllSidesNonePacket packet, IPayloadContext context) {
        Player player = context.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            context.enqueueWork(() -> {
                CustomMachineContainer container;
                Optional<ISideConfigComponent> component;
                AbstractContainerMenu patt0$temp;
                if (player.containerMenu.containerId == packet.containerId && (patt0$temp = player.containerMenu) instanceof CustomMachineContainer && (component = (container = (CustomMachineContainer)patt0$temp).getTile().getComponentManager().getConfigComponentById(packet.componentId())).isPresent()) {
                    SideConfig<?> config = component.get().getConfig();
                    for (RelativeSide side : RelativeSide.values()) {
                        if (config instanceof IOSideConfig) {
                            IOSideConfig ioSideConfig = (IOSideConfig)config;
                            ioSideConfig.setSideMode(side, IOSideMode.NONE);
                            continue;
                        }
                        if (!(config instanceof ToggleSideConfig)) continue;
                        ToggleSideConfig toggleSideConfig = (ToggleSideConfig)config;
                        toggleSideConfig.setSideMode(side, ToggleSideMode.DISABLED);
                    }
                }
            });
        }
    }
}

