/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.network;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.component.ISideConfigComponent;
import fr.frinn.custommachinery.common.init.CustomMachineContainer;
import fr.frinn.custommachinery.impl.component.config.IOSideConfig;
import fr.frinn.custommachinery.impl.component.config.RelativeSide;
import fr.frinn.custommachinery.impl.component.config.SideConfig;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record CChangeSideModePacket(int containerId, String id, byte side, boolean next) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CChangeSideModePacket> TYPE = new CustomPacketPayload.Type(CustomMachinery.rl("change_side_mode"));
    public static final StreamCodec<ByteBuf, CChangeSideModePacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, CChangeSideModePacket::containerId, (StreamCodec)ByteBufCodecs.STRING_UTF8, CChangeSideModePacket::id, (StreamCodec)ByteBufCodecs.BYTE, CChangeSideModePacket::side, (StreamCodec)ByteBufCodecs.BOOL, CChangeSideModePacket::next, CChangeSideModePacket::new);

    public CustomPacketPayload.Type<CChangeSideModePacket> type() {
        return TYPE;
    }

    public static void handle(CChangeSideModePacket packet, IPayloadContext context) {
        Player player = context.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            context.enqueueWork(() -> {
                if (player.containerMenu.containerId != packet.containerId) return;
                AbstractContainerMenu patt0$temp = player.containerMenu;
                if (!(patt0$temp instanceof CustomMachineContainer)) return;
                CustomMachineContainer container = (CustomMachineContainer)patt0$temp;
                Optional<ISideConfigComponent> component = container.getTile().getComponentManager().getConfigComponentById(packet.id);
                if (!component.isPresent()) return;
                SideConfig<?> config = component.get().getConfig();
                if (config instanceof IOSideConfig) {
                    IOSideConfig ioSideConfig = (IOSideConfig)config;
                    if (packet.side == 6 || packet.side == 7) {
                        switch (packet.side) {
                            case 6: {
                                ioSideConfig.setAutoInput(!ioSideConfig.isAutoInput());
                                return;
                            }
                            case 7: {
                                ioSideConfig.setAutoOutput(!ioSideConfig.isAutoOutput());
                                return;
                            }
                        }
                        return;
                    }
                }
                RelativeSide side = RelativeSide.values()[packet.side];
                if (packet.next) {
                    config.setNext(side);
                    return;
                }
                config.setPrevious(side);
            });
        }
    }
}

