/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.network;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.common.init.CustomMachineContainer;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.apache.commons.lang3.tuple.Triple;

public record CTransferRecipePacket(int containerId, List<Triple<Integer, Integer, Integer>> operations, boolean maxTransfer) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CTransferRecipePacket> TYPE = new CustomPacketPayload.Type(CustomMachinery.rl("transfer_recipe"));
    private static final StreamCodec<ByteBuf, Triple<Integer, Integer, Integer>> BASE_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, Triple::getLeft, (StreamCodec)ByteBufCodecs.VAR_INT, Triple::getMiddle, (StreamCodec)ByteBufCodecs.VAR_INT, Triple::getRight, Triple::of);
    public static final StreamCodec<ByteBuf, CTransferRecipePacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, CTransferRecipePacket::containerId, (StreamCodec)BASE_CODEC.apply(ByteBufCodecs.list()), CTransferRecipePacket::operations, (StreamCodec)ByteBufCodecs.BOOL, CTransferRecipePacket::maxTransfer, CTransferRecipePacket::new);

    public CustomPacketPayload.Type<CTransferRecipePacket> type() {
        return TYPE;
    }

    public static void handle(CTransferRecipePacket packet, IPayloadContext context) {
        Object object = context.player();
        if (object instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)object;
            object = player.containerMenu;
            if (object instanceof CustomMachineContainer) {
                CustomMachineContainer container = (CustomMachineContainer)((Object)object);
                if (container.containerId == packet.containerId) {
                    for (Triple triple : packet.operations) {
                        ItemStack stack;
                        int toTransfer;
                        if ((Integer)triple.getLeft() < 0 || (Integer)triple.getLeft() >= container.slots.size()) continue;
                        Slot from = container.getSlot((Integer)triple.getLeft());
                        if ((Integer)triple.getMiddle() < 0 || (Integer)triple.getMiddle() >= container.slots.size()) continue;
                        Slot to = container.getSlot((Integer)triple.getMiddle());
                        int amount = (Integer)triple.getRight();
                        if (from.getItem().isEmpty() || from.getItem().getCount() < amount || !from.allowModification((Player)player)) continue;
                        if (!to.getItem().isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)to.getItem(), (ItemStack)from.getItem())) {
                            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)to.remove(to.getItem().getCount()));
                            if (!to.getItem().isEmpty()) continue;
                        }
                        int n = toTransfer = packet.maxTransfer ? from.getItem().getCount() : amount;
                        if (!to.getItem().isEmpty()) {
                            toTransfer = Math.min(toTransfer, to.getItem().getMaxStackSize() - to.getItem().getCount());
                        }
                        if (!to.mayPlace(stack = from.getItem().copyWithCount(toTransfer))) continue;
                        ItemStack remaining = to.safeInsert(stack);
                        from.remove(toTransfer - remaining.getCount());
                    }
                }
            }
        }
    }
}

