/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.network;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.client.ClientPacketHandler;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.machine.MachineLocation;
import fr.frinn.custommachinery.common.machine.UpgradedCustomMachine;
import fr.frinn.custommachinery.common.util.Comparators;
import io.netty.handler.codec.EncoderException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SUpdateMachinesPacket(Map<ResourceLocation, CustomMachine> machines) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SUpdateMachinesPacket> TYPE = new CustomPacketPayload.Type(CustomMachinery.rl("update_machines"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SUpdateMachinesPacket> CODEC = new StreamCodec<RegistryFriendlyByteBuf, SUpdateMachinesPacket>(){

        public SUpdateMachinesPacket decode(RegistryFriendlyByteBuf buf) {
            HashMap<ResourceLocation, CustomMachine> map = new HashMap<ResourceLocation, CustomMachine>();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                try {
                    CustomMachine machine;
                    MachineLocation location = MachineLocation.CODEC.fromNetwork((FriendlyByteBuf)buf);
                    if (buf.readBoolean()) {
                        ResourceLocation parent = buf.readResourceLocation();
                        machine = UpgradedCustomMachine.makeCodec((CustomMachine)map.get(parent)).fromNetwork((FriendlyByteBuf)buf);
                    } else {
                        machine = CustomMachine.CODEC.fromNetwork((FriendlyByteBuf)buf);
                    }
                    machine.setLocation(location);
                    map.put(location.getId(), machine);
                    continue;
                }
                catch (EncoderException e) {
                    e.printStackTrace();
                }
            }
            return new SUpdateMachinesPacket(map);
        }

        public void encode(RegistryFriendlyByteBuf buf, SUpdateMachinesPacket packet) {
            buf.writeInt(packet.machines.size());
            packet.machines.values().stream().sorted(Comparators.PARENT_MACHINE_FIRST).forEach(machine -> {
                try {
                    MachineLocation.CODEC.toNetwork(machine.getLocation(), (FriendlyByteBuf)buf);
                    if (machine instanceof UpgradedCustomMachine) {
                        UpgradedCustomMachine upgradedMachine = (UpgradedCustomMachine)machine;
                        buf.writeBoolean(true);
                        buf.writeResourceLocation(((UpgradedCustomMachine)machine).getParentId());
                        UpgradedCustomMachine.makeCodec(packet.machines.get(upgradedMachine.getParentId())).toNetwork(upgradedMachine, (FriendlyByteBuf)buf);
                    } else {
                        buf.writeBoolean(false);
                        CustomMachine.CODEC.toNetwork((CustomMachine)machine, (FriendlyByteBuf)buf);
                    }
                }
                catch (EncoderException e) {
                    e.printStackTrace();
                }
            });
        }
    };

    public CustomPacketPayload.Type<SUpdateMachinesPacket> type() {
        return TYPE;
    }

    public static void handle(SUpdateMachinesPacket packet, IPayloadContext context) {
        if (context.flow().isClientbound()) {
            context.enqueueWork(() -> ClientPacketHandler.handleUpdateMachinesPacket(packet.machines));
        }
    }
}

