/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.network.data;

import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Color;
import fr.frinn.custommachinery.impl.component.config.IOSideConfig;
import fr.frinn.custommachinery.impl.component.config.IOSideMode;
import fr.frinn.custommachinery.impl.component.config.RelativeSide;
import fr.frinn.custommachinery.impl.network.Data;
import java.util.HashMap;
import net.minecraft.network.RegistryFriendlyByteBuf;

public class IOSideConfigData
extends Data<IOSideConfig> {
    public IOSideConfigData(Short id, IOSideConfig value) {
        super(Registration.IO_SIDE_CONFIG_DATA.get(), id, value);
    }

    public static IOSideConfigData readData(short id, RegistryFriendlyByteBuf buffer) {
        HashMap<RelativeSide, IOSideMode> map = new HashMap<RelativeSide, IOSideMode>();
        for (RelativeSide side : RelativeSide.values()) {
            map.put(side, IOSideMode.values()[buffer.readByte()]);
        }
        return new IOSideConfigData(id, new IOSideConfig(null, map, buffer.readBoolean(), buffer.readBoolean(), true, Color.fromARGB(buffer.readVarInt())));
    }

    @Override
    public void writeData(RegistryFriendlyByteBuf buffer) {
        super.writeData(buffer);
        for (RelativeSide side : RelativeSide.values()) {
            buffer.writeByte(((IOSideMode)((IOSideConfig)this.getValue()).getSideMode(side)).ordinal());
        }
        buffer.writeBoolean(((IOSideConfig)this.getValue()).isAutoInput());
        buffer.writeBoolean(((IOSideConfig)this.getValue()).isAutoOutput());
        buffer.writeVarInt(((IOSideConfig)this.getValue()).getColor().getARGB());
    }
}

