/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.network.data;

import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Color;
import fr.frinn.custommachinery.impl.component.config.RelativeSide;
import fr.frinn.custommachinery.impl.component.config.ToggleSideConfig;
import fr.frinn.custommachinery.impl.component.config.ToggleSideMode;
import fr.frinn.custommachinery.impl.network.Data;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;

public class ToggleSideConfigData
extends Data<ToggleSideConfig> {
    public ToggleSideConfigData(Short id, ToggleSideConfig value) {
        super(Registration.TOGGLE_SIDE_CONFIG_DATA.get(), id, value);
    }

    public static ToggleSideConfigData readData(short id, RegistryFriendlyByteBuf buffer) {
        HashMap<RelativeSide, ToggleSideMode> map = new HashMap<RelativeSide, ToggleSideMode>();
        for (RelativeSide side : RelativeSide.values()) {
            map.put(side, buffer.readBoolean() ? ToggleSideMode.ENABLED : ToggleSideMode.DISABLED);
        }
        return new ToggleSideConfigData(id, new ToggleSideConfig(null, (Map<RelativeSide, ToggleSideMode>)map, true, Color.fromARGB(buffer.readVarInt())));
    }

    @Override
    public void writeData(RegistryFriendlyByteBuf buffer) {
        super.writeData(buffer);
        for (RelativeSide side : RelativeSide.values()) {
            buffer.writeBoolean(((ToggleSideConfig)this.getValue()).getSideMode(side) == ToggleSideMode.ENABLED);
        }
        buffer.writeVarInt(((ToggleSideConfig)this.getValue()).getColor().getARGB());
    }
}

